/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import cronapi.TokenUtils;
import cronapp.framework.security.ApiAuthenticationSuccessHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.token", name={"enabled"}, havingValue="true")
public class JwtAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private final ApiAuthenticationSuccessHandler apiAuthenticationSuccessHandler;
    private final UserDetailsService userDetailsService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        this.apiAuthenticationSuccessHandler.onAuthenticationSuccess(request, response, authentication);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(authentication.getName());
        LinkedHashMap<String, String> extra = new LinkedHashMap<String, String>();
        extra.put("details", this.objectMapper.writeValueAsString((Object)userDetails));
        String token = TokenUtils.generateToken((UserDetails)userDetails, (String)authentication.getName(), (String)"cronapp", extra);
        Date expires = TokenUtils.getExpirationDateFromToken((String)token);
        long expiresIn = (expires.getTime() - System.currentTimeMillis()) / 1000L;
        HashMap<String, Object> tokenResponse = new HashMap<String, Object>();
        tokenResponse.put("access_token", token);
        tokenResponse.put("token_type", "Bearer");
        tokenResponse.put("expires_in", expiresIn);
        response.setStatus(200);
        response.setContentType("application/json");
        this.objectMapper.writeValue((OutputStream)response.getOutputStream(), tokenResponse);
    }

    @Generated
    public JwtAuthenticationSuccessHandler(ApiAuthenticationSuccessHandler apiAuthenticationSuccessHandler, UserDetailsService userDetailsService) {
        this.apiAuthenticationSuccessHandler = apiAuthenticationSuccessHandler;
        this.userDetailsService = userDetailsService;
    }
}

