/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.AuthenticationMethod;
import cronapp.framework.security.AuthenticationProviders;
import cronapp.framework.security.OAuthProperties;
import cronapp.framework.security.OAuthRegistrationProperties;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.oauth", name={"enabled"}, havingValue="true")
public class OAuthRegistrationRepository
implements ClientRegistrationRepository {
    private final Map<String, ClientRegistration> registrations;

    public OAuthRegistrationRepository(OAuthProperties properties, AuthenticationProviders authenticationProviders) {
        this.registrations = properties.getRegistrations().stream().map(this::getOauthRegistration).collect(Collectors.toMap(ClientRegistration::getRegistrationId, Function.identity(), (a, b) -> a, ConcurrentHashMap::new));
        properties.getRegistrations().forEach(registration -> authenticationProviders.addMethod(new AuthenticationMethod(registration.getName(), "/oauth2/authorization/" + registration.getName(), registration.getIcon(), registration.getDisplayName(), "oauth2")));
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        return this.registrations.get(registrationId);
    }

    private ClientRegistration getOauthRegistration(OAuthRegistrationProperties properties) {
        return ClientRegistration.withRegistrationId((String)properties.getName()).clientId(properties.getClientId()).clientSecret(properties.getClientSecret()).authorizationUri(properties.getAuthorizationUri()).tokenUri(properties.getTokenUri()).userInfoUri(properties.getUserInfoUri()).userNameAttributeName(properties.getNameAttributeKey()).jwkSetUri(properties.getJwkSetUri()).clientAuthenticationMethod(properties.getClientAuthenticationMethod()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri("{baseUrl}/login/oauth2/code/{registrationId}").scope(Arrays.stream(properties.getScope().split(" ")).toList()).build();
    }
}

