/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;

public class SecuritySupport {
    public static final String ENCRYPT = "$2a$10$";
    public static final RequestHeaderRequestMatcher X_REQUESTED_WITH = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
    public static final RequestHeaderRequestMatcher X_AUTH_TOKEN = new RequestHeaderRequestMatcher("X-AUTH-TOKEN");

    public static boolean isMobileDevice(HttpServletRequest request) {
        String[] mobileAgents;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        for (String mobileAgent : mobileAgents = new String[]{"Mobile", "Android", "iPhone", "iPad", "iPod", "BlackBerry", "Windows Phone", "Opera Mini", "IEMobile"}) {
            if (!userAgent.contains(mobileAgent)) continue;
            return true;
        }
        return false;
    }

    public static String getProvider(Authentication authentication) {
        if (authentication instanceof Saml2Authentication) {
            return "saml";
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            return "form";
        }
        if (authentication instanceof OAuth2AuthenticationToken) {
            return "oauth";
        }
        return "unknown";
    }

    public static boolean isSso(Authentication authentication) {
        return authentication instanceof Saml2Authentication || authentication instanceof OAuth2AuthenticationToken;
    }
}

