/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.Var;
import cronapp.framework.api.EventsManager;
import cronapp.framework.security.ApiUserDetailsManager;
import cronapp.framework.security.CustomCorsFilter;
import cronapp.framework.security.CustomHeadersFilter;
import cronapp.framework.security.FormsAuthenticationProvider;
import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.SecuritySupport;
import jakarta.servlet.Filter;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ComponentScan
@EnableWebSecurity
public class SecurityConfiguration {
    private final AuthorizationManager<RequestAuthorizationContext>[] authorizationManagers;
    private final HttpSecurityCustomizer[] securityConfigurers;
    private final ApiUserDetailsManager userDetailsManager;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authenticationProvider((AuthenticationProvider)new FormsAuthenticationProvider(this.userDetailsManager));
        http.userDetailsService((UserDetailsService)this.userDetailsManager);
        http.headers(headers -> {
            headers.cacheControl(HeadersConfigurer.CacheControlConfig::disable);
            headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable);
            headers.httpStrictTransportSecurity(HeadersConfigurer.HstsConfig::disable);
        });
        http.sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).cors(Customizer.withDefaults());
        http.addFilterAfter((Filter)this.customHeadersFilter(), HeaderWriterFilter.class);
        http.addFilterBefore((Filter)this.corsFilter(), CorsFilter.class);
        http.anonymous(anonymous -> anonymous.authorities(new String[]{"Public"}));
        http.logout(logout -> {
            logout.logoutSuccessHandler(this.logoutSuccessHandler());
            logout.addLogoutHandler((LogoutHandler)this.logoutHandler());
        });
        for (HttpSecurityCustomizer securityConfigurer : this.securityConfigurers) {
            securityConfigurer.customize(http);
        }
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).access(AuthorizationManagers.allOf((AuthorizationDecision)new AuthorizationDecision(false), this.authorizationManagers)));
        http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint(this.authenticationEntryPoint()));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationFailureHandler authenticationFailureHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setUseForward(true);
        failureHandler.setDefaultFailureUrl("/error");
        return failureHandler;
    }

    @Bean
    public LogoutSuccessHandler logoutSuccessHandler() {
        SimpleUrlLogoutSuccessHandler handler = new SimpleUrlLogoutSuccessHandler();
        handler.setDefaultTargetUrl("/login?logout");
        return handler;
    }

    @Bean
    public SecurityContextLogoutHandler logoutHandler() {
        SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
        logoutHandler.setInvalidateHttpSession(true);
        logoutHandler.setClearAuthentication(true);
        return logoutHandler;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void doSomethingAfterStartup() {
        if (EventsManager.hasEvent("onSystemStarts")) {
            EventsManager.executeEventOnTransaction("onSystemStarts", new Var[0]);
        }
    }

    private CustomHeadersFilter customHeadersFilter() {
        return new CustomHeadersFilter();
    }

    private CustomCorsFilter corsFilter() {
        return new CustomCorsFilter();
    }

    private AuthenticationEntryPoint authenticationEntryPoint() {
        LinkedHashMap<RequestHeaderRequestMatcher, HttpStatusEntryPoint> entryPoints = new LinkedHashMap<RequestHeaderRequestMatcher, HttpStatusEntryPoint>();
        entryPoints.put(SecuritySupport.X_REQUESTED_WITH, new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED));
        DelegatingAuthenticationEntryPoint defaultEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        defaultEntryPoint.setDefaultEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/"));
        return defaultEntryPoint;
    }

    @Generated
    public SecurityConfiguration(AuthorizationManager<RequestAuthorizationContext>[] authorizationManagers, HttpSecurityCustomizer[] securityConfigurers, ApiUserDetailsManager userDetailsManager) {
        this.authorizationManagers = authorizationManagers;
        this.securityConfigurers = securityConfigurers;
        this.userDetailsManager = userDetailsManager;
    }
}

