/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.TokenUtils;
import cronapp.framework.i18n.Messages;
import cronapp.framework.security.JwtAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = request.getHeader("X-AUTH-TOKEN");
        if (StringUtils.isNotBlank((CharSequence)token) && TokenUtils.getClaimsFromToken((String)token) != null) {
            JwtAuthenticationToken authentication = new JwtAuthenticationToken(token);
            authentication.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IllegalArgumentException e) {
            if ("You have entered a password with no PasswordEncoder. If that is your intent, it should be prefixed with `{noop}`.".equals(e.getMessage())) {
                throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"), (Throwable)e);
            }
            throw e;
        }
    }
}

