/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.LdapProperties;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.ldap", name={"enabled"}, havingValue="true")
public class LdapConfiguration
implements BeanPostProcessor {
    private final LdapProperties ldapProperties;

    @Bean
    public HttpSecurityCustomizer ldapCustomizer() {
        return http -> {};
    }

    @Autowired
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.ldapAuthentication().userDnPatterns(this.ldapProperties.getUserDnPatterns().toArray(new String[0])).groupSearchBase(this.ldapProperties.getGroupSearchBase()).groupSearchFilter(this.ldapProperties.getGroupSearchFilter()).rolePrefix("").withObjectPostProcessor(this::postProcess).contextSource().url(this.ldapProperties.getUrl());
    }

    private <O> O postProcess(O object) {
        if (object instanceof DefaultLdapAuthoritiesPopulator) {
            DefaultLdapAuthoritiesPopulator populator = (DefaultLdapAuthoritiesPopulator)object;
            populator.setConvertToUpperCase(false);
            populator.setRolePrefix("");
            populator.setDefaultRole("Authenticated");
        }
        return object;
    }

    @Generated
    public LdapConfiguration(LdapProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }
}

