/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.SessionListener;
import cronapp.framework.core.CronappDatabaseConfiguration;
import cronapp.framework.core.DatabaseSupport;
import cronapp.framework.security.CsrfTokenResponseHeaderFilter;
import cronapp.framework.security.FormsProperties;
import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.OAuthProperties;
import cronapp.framework.security.SamlProperties;
import cronapp.framework.security.SecuritySupport;
import cronapp.framework.security.SessionProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpSessionListener;
import java.util.EventListener;
import javax.naming.NamingException;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.Db2JdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.MySqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.OracleJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.PostgreSqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Component;

@Component
public class SessionConfiguration {
    private final SessionProperties sessionProperties;
    private final SamlProperties samlProperties;
    private final OAuthProperties oauthProperties;
    private final FormsProperties formsProperties;
    private final ApplicationContext context;

    @Bean
    public HttpSecurityCustomizer sessionCustomizer() {
        return http -> {
            if (this.isSessionEnabled()) {
                RequestCache requestCache = (RequestCache)this.context.getBeanProvider(RequestCache.class).getIfUnique();
                http.requestCache(configurer -> configurer.requestCache(requestCache));
                http.sessionManagement(configurer -> configurer.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED));
                http.csrf(configurer -> {
                    configurer.csrfTokenRepository((CsrfTokenRepository)new HttpSessionCsrfTokenRepository());
                    configurer.csrfTokenRequestHandler((CsrfTokenRequestHandler)new XorCsrfTokenRequestAttributeHandler());
                    configurer.ignoringRequestMatchers(new String[]{"/auth/signup"});
                });
                http.addFilterAfter((Filter)new CsrfTokenResponseHeaderFilter(), CsrfFilter.class);
            } else {
                http.sessionManagement(configurer -> configurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
            }
        };
    }

    @Bean
    public ServletListenerRegistrationBean<HttpSessionListener> sessionListener() {
        return new ServletListenerRegistrationBean((EventListener)((Object)new SessionListener()));
    }

    @Bean
    public RequestCache requestCache() {
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setMatchingRequestParameterName(null);
        requestCache.setRequestMatcher((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)SecuritySupport.X_REQUESTED_WITH));
        return requestCache;
    }

    @Bean(name={"sessionDataSource"})
    @SpringSessionDataSource
    @ConditionalOnProperty(value={"cronapp.data.enabled"})
    public DataSource sessionDataSource() throws NamingException {
        JndiObjectFactoryBean jndiFactoryBean = new JndiObjectFactoryBean();
        jndiFactoryBean.setJndiName((String)CronappDatabaseConfiguration.getCronappDataSourceName().get());
        jndiFactoryBean.setProxyInterface(DataSource.class);
        jndiFactoryBean.setLookupOnStartup(true);
        jndiFactoryBean.afterPropertiesSet();
        return (DataSource)jndiFactoryBean.getObject();
    }

    @Bean
    @ConditionalOnProperty(value={"cronapp.data.enabled"})
    public SessionRepositoryCustomizer<JdbcIndexedSessionRepository> sessionRepositoryCustomizer(@SpringSessionDataSource DataSource dataSource) {
        return switch (DatabaseSupport.getDatabaseDriver((DataSource)dataSource)) {
            case DatabaseDriver.MYSQL, DatabaseDriver.MARIADB -> new MySqlJdbcIndexedSessionRepositoryCustomizer();
            case DatabaseDriver.ORACLE -> new OracleJdbcIndexedSessionRepositoryCustomizer();
            case DatabaseDriver.POSTGRESQL -> new PostgreSqlJdbcIndexedSessionRepositoryCustomizer();
            case DatabaseDriver.DB2, DatabaseDriver.DB2_AS400 -> new Db2JdbcIndexedSessionRepositoryCustomizer();
            default -> sessionRepository -> {};
        };
    }

    @Bean
    private CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        if (this.samlProperties.isEnabled()) {
            serializer.setSameSite("None");
            serializer.setUseSecureCookie(true);
        }
        return serializer;
    }

    private boolean isSessionEnabled() {
        return this.sessionProperties.isEnabled() || this.samlProperties.isEnabled() || this.oauthProperties.isEnabled() || this.formsProperties.isEnabled();
    }

    @Generated
    public SessionConfiguration(SessionProperties sessionProperties, SamlProperties samlProperties, OAuthProperties oauthProperties, FormsProperties formsProperties, ApplicationContext context) {
        this.sessionProperties = sessionProperties;
        this.samlProperties = samlProperties;
        this.oauthProperties = oauthProperties;
        this.formsProperties = formsProperties;
        this.context = context;
    }
}

