/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impls.baseup;

import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.entity.interfaces.Runner;
import io.github.kloping.MySpringTool.exceptions.NoRunException;
import io.github.kloping.MySpringTool.interfaces.Executor;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.QueueExecutor;
import io.github.kloping.MySpringTool.interfaces.entitys.MatherResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QueueExecutorImpl
implements QueueExecutor {
    private Class<?> cla = Long.class;
    private Executor executor;
    private int poolSize = 20;
    private long waitTime = 10000L;
    private Runner runner1;
    private Runner runner2;
    private Setting setting;
    private Logger logger;
    private ExecutorService threads;
    private ExecutorService runThreads = null;
    private Map<Object, Queue> queueMap = new ConcurrentHashMap<Object, Queue>();
    private Set<Object> runSet = new CopyOnWriteArraySet<Object>();

    public QueueExecutorImpl(Setting setting) {
        this.setting = setting;
        setting.getSTARTED_RUNNABLE().add(() -> {
            this.logger = setting.getContextManager().getContextEntity(Logger.class);
        });
    }

    public void setBefore(Runner runner) {
        this.runner1 = runner;
    }

    public void setAfter(Runner runner) {
        this.runner2 = runner;
    }

    public QueueExecutorImpl(Class<?> cla, Executor executor) {
        this.cla = cla;
        this.executor = executor;
        this.init();
    }

    private void init() {
        this.threads = new ThreadPoolExecutor(this.poolSize, this.poolSize, this.waitTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize));
        this.runThreads = Executors.newFixedThreadPool(this.poolSize);
    }

    public static QueueExecutor create(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        QueueExecutorImpl queueExecutor = new QueueExecutorImpl(setting);
        queueExecutor.executor = executor;
        queueExecutor.poolSize = poolSize;
        queueExecutor.cla = cla;
        queueExecutor.waitTime = waitTime;
        queueExecutor.init();
        return queueExecutor;
    }

    @Override
    public Object execute(Object this_, Method method, Object ... objects) throws InvocationTargetException, IllegalAccessException {
        Object o = null;
        try {
            o = this.executor.execute(this_, method, objects);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException ite = e;
            if (ite.getTargetException().getClass() == NoRunException.class) {
                NoRunException exception = (NoRunException)ite.getTargetException();
                this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + exception.getMessage(), 2);
            }
            this.logger.Log("\u5b58\u5728\u6620\u5c04\u4e00\u4e2a\u5f02\u5e38(Has a Invoke Exception)=>" + ite.getTargetException() + " at " + PartUtils.getExceptionLine(ite.getTargetException()), -1);
        }
        return o;
    }

    @Override
    public <T> int queueExecute(T t, Object ... objects) {
        if (t.getClass() != this.cla) {
            this.logger.Log("not is mainKey type for " + t.getClass().getSimpleName(), 2);
            return 0;
        }
        if (this.runSet.add(t)) {
            this.runThreads.execute(() -> {
                Future<?> future = this.threads.submit(() -> {
                    block13: {
                        try {
                            long startTime = System.currentTimeMillis();
                            Object[] parts = Arrays.copyOfRange(objects, 2, objects.length);
                            if (this.setting.getArgsManager().isLegal(parts)) {
                                try {
                                    MatherResult result = (MatherResult)this.setting.getActionManager().mather(objects[1].toString());
                                    if (result != null) {
                                        Method[] methods = result.getMethods();
                                        Class<?> cla = methods[0].getDeclaringClass();
                                        if (this.runner1 != null) {
                                            this.runner1.run(methods[0], t, objects);
                                        }
                                        Object o = this.setting.getContextManager().getContextEntity(cla);
                                        Object reo = null;
                                        ArrayList<Object> results = new ArrayList<Object>();
                                        for (Method m : methods) {
                                            Object[] parObjs = this.setting.getAutomaticWiringParams().wiring(m, result, results, parts);
                                            Object to = this.executor.execute(o, m, parObjs);
                                            if (to == null) continue;
                                            results.add(to);
                                            reo = to;
                                        }
                                        if (this.runner2 != null) {
                                            this.runner2.run(methods[0], reo, objects);
                                        }
                                        this.logger.Log("lost time " + (System.currentTimeMillis() - startTime) + " Millisecond", 1);
                                        break block13;
                                    }
                                    this.logger.Log("No match for " + objects[1].toString(), 2);
                                }
                                catch (NoRunException e) {
                                    this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + e.getMessage() + " At " + PartUtils.getExceptionLine(e), 2);
                                }
                                catch (InvocationTargetException e) {
                                    InvocationTargetException ite = e;
                                    if (ite.getTargetException().getClass() == NoRunException.class) {
                                        NoRunException exception = (NoRunException)ite.getTargetException();
                                        this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + exception.getMessage(), 2);
                                        break block13;
                                    }
                                    this.logger.Log("\u5b58\u5728\u6620\u5c04\u4e00\u4e2a\u5f02\u5e38(Has a Invoke Exception)=>" + ite.getTargetException() + " at " + PartUtils.getExceptionLine(ite.getTargetException()), -1);
                                }
                                catch (Exception e) {
                                    this.logger.Log("\u5b58\u5728\u4e00\u4e2a\u5f02\u5e38(Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
                                }
                                break block13;
                            }
                            this.logger.Log("Can't Access types for " + Arrays.toString(objects), 2);
                        }
                        catch (NoRunException e) {
                            this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + e.getMessage() + " At " + PartUtils.getExceptionLine(e), 2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                try {
                    future.get(this.waitTime, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.logger.Log("\u8fd0\u884c\u65f6\u9519\u8bef(Running Has Error)=>" + e, -1);
                    future.cancel(true);
                }
                catch (TimeoutException e) {
                    this.logger.Log("\u8fd0\u884c\u8d85\u65f6(Run Time Out)=>" + e, -1);
                    future.cancel(true);
                }
                catch (Exception e) {
                    this.logger.Log("\u5176\u4ed6\u9519\u8bef(Other Error)=>" + e + "\n", -1);
                    e.printStackTrace();
                    future.cancel(true);
                }
                this.runSet.remove(t);
                if (this.queueMap.containsKey(t)) {
                    this.queueExecute(t, this.end(t));
                }
            });
            return this.queueMap.size();
        }
        this.append(t, objects);
        this.logger.Log("append queue list and next run", 0);
        return 0;
    }

    private void append(Object t, Object ... objects) {
        if (this.queueMap.containsKey(t)) {
            this.queueMap.get(t).offer(objects);
        } else {
            ConcurrentLinkedDeque<Object[]> queue = new ConcurrentLinkedDeque<Object[]>();
            queue.offer(objects);
            this.queueMap.put(t, queue);
        }
    }

    private Object[] end(Object t) {
        Object[] objects = null;
        if (this.queueMap.containsKey(t)) {
            objects = (Object[])this.queueMap.get(t).poll();
        }
        if (this.queueMap.get(t).isEmpty()) {
            this.queueMap.remove(t);
        }
        return objects;
    }
}

