/*
 * ============================================================================
 * GNU General Public License
 * ============================================================================
 *
 * Copyright (C) 2006-2011 Serotonin Software Technologies Inc. http://serotoninsoftware.com
 * @author Matthew Lohbihler
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.huangjian.modbus4j.serial.rtu;

import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.msg.ModbusRequest;
import com.huangjian.modbus4j.sero.messaging.IncomingRequestMessage;
import com.huangjian.modbus4j.sero.messaging.OutgoingRequestMessage;
import com.huangjian.modbus4j.sero.util.queue.ByteQueue;

/**
 * Handles the RTU enveloping of modbus requests.
 *
 * @author mlohbihler
 * @version 5.0.0
 */
public class RtuMessageRequest extends RtuMessage implements OutgoingRequestMessage, IncomingRequestMessage {
    static RtuMessageRequest createRtuMessageRequest(ByteQueue queue) throws ModbusTransportException {
        ModbusRequest request = ModbusRequest.createModbusRequest(queue);
        RtuMessageRequest rtuRequest = new RtuMessageRequest(request);

        // Check the CRC
        ModbusUtils.checkCRC(rtuRequest.modbusMessage, queue);

        // Return the data.
        return rtuRequest;
    }

    /**
     * <p>Constructor for RtuMessageRequest.</p>
     *
     * @param modbusRequest a {@link com.huangjian.modbus4j.msg.ModbusRequest} object.
     */
    public RtuMessageRequest(ModbusRequest modbusRequest) {
        super(modbusRequest);
    }

    /** {@inheritDoc} */
    @Override
    public boolean expectsResponse() {
        return modbusMessage.getSlaveId() != 0;
    }

    /**
     * <p>getModbusRequest.</p>
     *
     * @return a {@link com.huangjian.modbus4j.msg.ModbusRequest} object.
     */
    public ModbusRequest getModbusRequest() {
        return (ModbusRequest) modbusMessage;
    }
}
