/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j;

import com.huangjian.modbus4j.ModbusMaster;
import com.huangjian.modbus4j.base.KeyedModbusLocator;
import com.huangjian.modbus4j.base.ReadFunctionGroup;
import com.huangjian.modbus4j.base.SlaveAndRange;
import com.huangjian.modbus4j.locator.BaseLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class BatchRead<K> {
    private final List<KeyedModbusLocator<K>> requestValues = new ArrayList<KeyedModbusLocator<K>>();
    private boolean contiguousRequests = false;
    private boolean errorsInResults = false;
    private boolean exceptionsInResults = false;
    private boolean cancel;
    private List<ReadFunctionGroup<K>> functionGroups;

    public boolean isContiguousRequests() {
        return this.contiguousRequests;
    }

    public void setContiguousRequests(boolean contiguousRequests) {
        this.contiguousRequests = contiguousRequests;
        this.functionGroups = null;
    }

    public boolean isErrorsInResults() {
        return this.errorsInResults;
    }

    public void setErrorsInResults(boolean errorsInResults) {
        this.errorsInResults = errorsInResults;
    }

    public boolean isExceptionsInResults() {
        return this.exceptionsInResults;
    }

    public void setExceptionsInResults(boolean exceptionsInResults) {
        this.exceptionsInResults = exceptionsInResults;
    }

    public List<ReadFunctionGroup<K>> getReadFunctionGroups(ModbusMaster master) {
        if (this.functionGroups == null) {
            this.doPartition(master);
        }
        return this.functionGroups;
    }

    public void addLocator(K id, BaseLocator<?> locator) {
        this.addLocator(new KeyedModbusLocator<K>(id, locator));
    }

    private void addLocator(KeyedModbusLocator<K> locator) {
        this.requestValues.add(locator);
        this.functionGroups = null;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    private void doPartition(ModbusMaster master) {
        HashMap<SlaveAndRange, ArrayList<KeyedModbusLocator<K>>> slaveRangeBatch = new HashMap<SlaveAndRange, ArrayList<KeyedModbusLocator<K>>>();
        for (KeyedModbusLocator<K> locator : this.requestValues) {
            ArrayList<KeyedModbusLocator<K>> functionList = (ArrayList<KeyedModbusLocator<K>>)slaveRangeBatch.get(locator.getSlaveAndRange());
            if (functionList == null) {
                functionList = new ArrayList<KeyedModbusLocator<K>>();
                slaveRangeBatch.put(locator.getSlaveAndRange(), functionList);
            }
            functionList.add(locator);
        }
        Collection functionLocatorLists = slaveRangeBatch.values();
        FunctionLocatorComparator comparator = new FunctionLocatorComparator(this);
        this.functionGroups = new ArrayList<ReadFunctionGroup<K>>();
        for (List functionLocatorList : functionLocatorLists) {
            Collections.sort(functionLocatorList, comparator);
            int maxReadCount = master.getMaxReadCount(((KeyedModbusLocator)functionLocatorList.get(0)).getSlaveAndRange().getRange());
            this.createRequestGroups(this.functionGroups, functionLocatorList, maxReadCount);
        }
    }

    private void createRequestGroups(List<ReadFunctionGroup<K>> functionGroups, List<KeyedModbusLocator<K>> locators, int maxCount) {
        block0: while (locators.size() > 0) {
            ReadFunctionGroup<K> functionGroup = new ReadFunctionGroup<K>(locators.remove(0));
            functionGroups.add(functionGroup);
            int endOffset = functionGroup.getStartOffset() + maxCount - 1;
            int index = 0;
            while (locators.size() > index) {
                KeyedModbusLocator<K> locator = locators.get(index);
                boolean added = false;
                if (locator.getEndOffset() <= endOffset) {
                    if (this.contiguousRequests) {
                        if (locator.getOffset() <= functionGroup.getEndOffset() + 1) {
                            functionGroup.add(locators.remove(index));
                            added = true;
                        }
                    } else {
                        functionGroup.add(locators.remove(index));
                        added = true;
                    }
                }
                if (added) continue;
                if (locator.getOffset() > endOffset) continue block0;
                ++index;
            }
        }
    }

    class FunctionLocatorComparator
    implements Comparator<KeyedModbusLocator<K>> {
        FunctionLocatorComparator(BatchRead this$0) {
        }

        @Override
        public int compare(KeyedModbusLocator<K> ml1, KeyedModbusLocator<K> ml2) {
            return ml1.getOffset() - ml2.getOffset();
        }
    }
}

