/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j;

import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.sero.messaging.DefaultMessagingExceptionHandler;
import com.huangjian.modbus4j.sero.messaging.MessagingExceptionHandler;

public class Modbus {
    public static final int DEFAULT_MAX_READ_BIT_COUNT = 2000;
    public static final int DEFAULT_MAX_READ_REGISTER_COUNT = 125;
    public static final int DEFAULT_MAX_WRITE_REGISTER_COUNT = 120;
    private MessagingExceptionHandler exceptionHandler = new DefaultMessagingExceptionHandler();
    private int maxReadBitCount = 2000;
    private int maxReadRegisterCount = 125;
    private int maxWriteRegisterCount = 120;

    public int getMaxReadCount(int registerRange) {
        switch (registerRange) {
            case 1: 
            case 2: {
                return this.maxReadBitCount;
            }
            case 3: 
            case 4: {
                return this.maxReadRegisterCount;
            }
        }
        return -1;
    }

    public void validateNumberOfBits(int bits) throws ModbusTransportException {
        if (bits < 1 || bits > this.maxReadBitCount) {
            throw new ModbusTransportException("Invalid number of bits: " + bits);
        }
    }

    public void validateNumberOfRegisters(int registers) throws ModbusTransportException {
        if (registers < 1 || registers > this.maxReadRegisterCount) {
            throw new ModbusTransportException("Invalid number of registers: " + registers);
        }
    }

    public void setExceptionHandler(MessagingExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler == null ? new DefaultMessagingExceptionHandler() : exceptionHandler;
    }

    public MessagingExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public int getMaxReadBitCount() {
        return this.maxReadBitCount;
    }

    public void setMaxReadBitCount(int maxReadBitCount) {
        this.maxReadBitCount = maxReadBitCount;
    }

    public int getMaxReadRegisterCount() {
        return this.maxReadRegisterCount;
    }

    public void setMaxReadRegisterCount(int maxReadRegisterCount) {
        this.maxReadRegisterCount = maxReadRegisterCount;
    }

    public int getMaxWriteRegisterCount() {
        return this.maxWriteRegisterCount;
    }

    public void setMaxWriteRegisterCount(int maxWriteRegisterCount) {
        this.maxWriteRegisterCount = maxWriteRegisterCount;
    }
}

