/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j;

import com.huangjian.modbus4j.ModbusMaster;
import com.huangjian.modbus4j.ModbusSlaveSet;
import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.exception.ModbusIdException;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.ip.IpParameters;
import com.huangjian.modbus4j.ip.listener.TcpListener;
import com.huangjian.modbus4j.ip.tcp.TcpMaster;
import com.huangjian.modbus4j.ip.tcp.TcpSlave;
import com.huangjian.modbus4j.ip.udp.UdpMaster;
import com.huangjian.modbus4j.ip.udp.UdpSlave;
import com.huangjian.modbus4j.msg.ModbusRequest;
import com.huangjian.modbus4j.msg.ReadCoilsRequest;
import com.huangjian.modbus4j.msg.ReadDiscreteInputsRequest;
import com.huangjian.modbus4j.msg.ReadHoldingRegistersRequest;
import com.huangjian.modbus4j.msg.ReadInputRegistersRequest;
import com.huangjian.modbus4j.serial.SerialPortWrapper;
import com.huangjian.modbus4j.serial.ascii.AsciiMaster;
import com.huangjian.modbus4j.serial.ascii.AsciiSlave;
import com.huangjian.modbus4j.serial.rtu.RtuMaster;
import com.huangjian.modbus4j.serial.rtu.RtuSlave;

public class ModbusFactory {
    public ModbusMaster createRtuMaster(SerialPortWrapper wrapper) {
        return new RtuMaster(wrapper);
    }

    public ModbusMaster createAsciiMaster(SerialPortWrapper wrapper) {
        return new AsciiMaster(wrapper);
    }

    public ModbusMaster createTcpMaster(IpParameters params, boolean keepAlive) {
        return new TcpMaster(params, keepAlive);
    }

    public ModbusMaster createTcpMaster(IpParameters params, boolean keepAlive, Integer lingerTime) {
        return new TcpMaster(params, keepAlive, lingerTime);
    }

    public ModbusMaster createUdpMaster(IpParameters params) {
        return new UdpMaster(params);
    }

    public ModbusMaster createTcpListener(IpParameters params) {
        return new TcpListener(params);
    }

    public ModbusSlaveSet createRtuSlave(SerialPortWrapper wrapper) {
        return new RtuSlave(wrapper);
    }

    public ModbusSlaveSet createAsciiSlave(SerialPortWrapper wrapper) {
        return new AsciiSlave(wrapper);
    }

    public ModbusSlaveSet createTcpSlave(boolean encapsulated) {
        return new TcpSlave(encapsulated);
    }

    public ModbusSlaveSet createUdpSlave(boolean encapsulated) {
        return new UdpSlave(encapsulated);
    }

    public ModbusRequest createReadRequest(int slaveId, int range, int offset, int length) throws ModbusTransportException, ModbusIdException {
        ModbusUtils.validateRegisterRange(range);
        if (range == 1) {
            return new ReadCoilsRequest(slaveId, offset, length);
        }
        if (range == 2) {
            return new ReadDiscreteInputsRequest(slaveId, offset, length);
        }
        if (range == 4) {
            return new ReadInputRegistersRequest(slaveId, offset, length);
        }
        return new ReadHoldingRegistersRequest(slaveId, offset, length);
    }
}

