/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.ip.tcp;

import com.huangjian.modbus4j.ModbusMaster;
import com.huangjian.modbus4j.base.BaseMessageParser;
import com.huangjian.modbus4j.exception.ModbusInitException;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.ip.IpMessage;
import com.huangjian.modbus4j.ip.IpMessageResponse;
import com.huangjian.modbus4j.ip.IpParameters;
import com.huangjian.modbus4j.ip.encap.EncapMessageParser;
import com.huangjian.modbus4j.ip.encap.EncapMessageRequest;
import com.huangjian.modbus4j.ip.encap.EncapWaitingRoomKeyFactory;
import com.huangjian.modbus4j.ip.xa.XaMessageParser;
import com.huangjian.modbus4j.ip.xa.XaMessageRequest;
import com.huangjian.modbus4j.ip.xa.XaWaitingRoomKeyFactory;
import com.huangjian.modbus4j.msg.ModbusRequest;
import com.huangjian.modbus4j.msg.ModbusResponse;
import com.huangjian.modbus4j.sero.messaging.EpollStreamTransport;
import com.huangjian.modbus4j.sero.messaging.MessageControl;
import com.huangjian.modbus4j.sero.messaging.OutgoingRequestMessage;
import com.huangjian.modbus4j.sero.messaging.StreamTransport;
import com.huangjian.modbus4j.sero.messaging.Transport;
import com.huangjian.modbus4j.sero.messaging.WaitingRoomKeyFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpMaster
extends ModbusMaster {
    private final Log LOG = LogFactory.getLog(TcpMaster.class);
    private short nextTransactionId = 0;
    private final IpParameters ipParameters;
    private final boolean keepAlive;
    private final boolean autoIncrementTransactionId;
    private final Integer lingerTime;
    private Socket socket;
    private Transport transport;
    private MessageControl conn;

    public TcpMaster(IpParameters params, boolean keepAlive, boolean autoIncrementTransactionId, boolean validateResponse, Integer lingerTime) {
        this.ipParameters = params;
        this.keepAlive = keepAlive;
        this.autoIncrementTransactionId = autoIncrementTransactionId;
        this.lingerTime = lingerTime;
    }

    public TcpMaster(IpParameters params, boolean keepAlive, boolean autoIncrementTransactionId, boolean validateResponse) {
        this(params, keepAlive, autoIncrementTransactionId, validateResponse, -1);
    }

    public TcpMaster(IpParameters params, boolean keepAlive, boolean autoIncrementTransactionId) {
        this(params, keepAlive, autoIncrementTransactionId, false, -1);
    }

    public TcpMaster(IpParameters params, boolean keepAlive, Integer lingerTime) {
        this(params, keepAlive, true, false, lingerTime);
    }

    public TcpMaster(IpParameters params, boolean keepAlive) {
        this(params, keepAlive, true, false, -1);
    }

    public void setNextTransactionId(short id) {
        this.nextTransactionId = id;
    }

    protected short getNextTransactionId() {
        return this.nextTransactionId;
    }

    @Override
    public synchronized void init() throws ModbusInitException {
        try {
            if (this.keepAlive) {
                this.openConnection();
            }
        }
        catch (Exception e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    public synchronized void destroy() {
        this.closeConnection();
        this.initialized = false;
    }

    @Override
    public synchronized ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        IpMessageResponse ipResponse;
        IpMessage ipRequest;
        try {
            if (!this.keepAlive) {
                this.openConnection();
            }
            if (this.conn == null) {
                this.LOG.debug((Object)("Connection null: " + this.ipParameters.getPort()));
            }
        }
        catch (Exception e) {
            this.closeConnection();
            throw new ModbusTransportException(e, request.getSlaveId());
        }
        if (this.ipParameters.isEncapsulated()) {
            ipRequest = new EncapMessageRequest(request);
        } else {
            if (this.autoIncrementTransactionId) {
                this.nextTransactionId = (short)(this.nextTransactionId + 1);
            }
            ipRequest = new XaMessageRequest(request, (int)this.getNextTransactionId());
        }
        if (this.LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (byte b : Arrays.copyOfRange(ipRequest.getMessageData(), 0, ipRequest.getMessageData().length)) {
                sb.append(String.format("%02X ", b));
            }
            this.LOG.debug((Object)("Encap Request: " + sb.toString()));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Sending on port: " + this.ipParameters.getPort()));
        }
        try {
            Object sb;
            if (this.conn == null && this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Connection null: " + this.ipParameters.getPort()));
            }
            if ((ipResponse = (IpMessageResponse)this.conn.send((OutgoingRequestMessage)((Object)ipRequest))) == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.LOG.isDebugEnabled()) {
                sb = new StringBuilder();
                for (byte b : Arrays.copyOfRange(ipResponse.getMessageData(), 0, ipResponse.getMessageData().length)) {
                    ((StringBuilder)sb).append(String.format("%02X ", b));
                }
                this.LOG.debug((Object)("Response: " + ((StringBuilder)sb).toString()));
            }
            sb = ipResponse.getModbusResponse();
            return sb;
        }
        catch (Exception e) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Exception sending message", (Throwable)e);
            }
            if (this.keepAlive) {
                block32: {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)"KeepAlive - reconnect!");
                    }
                    try {
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug((Object)"Modbus4J: Keep-alive connection may have been reset. Attempting to re-open.");
                        }
                        this.openConnection();
                        ipResponse = (IpMessageResponse)this.conn.send((OutgoingRequestMessage)((Object)ipRequest));
                        if (ipResponse != null) break block32;
                        ModbusResponse modbusResponse = null;
                        return modbusResponse;
                    }
                    catch (Exception e2) {
                        this.closeConnection();
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug((Object)"Exception re-sending message", (Throwable)e);
                        }
                        throw new ModbusTransportException(e2, request.getSlaveId());
                    }
                }
                if (this.LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    for (byte b : Arrays.copyOfRange(ipResponse.getMessageData(), 0, ipResponse.getMessageData().length)) {
                        sb.append(String.format("%02X ", b));
                    }
                    this.LOG.debug((Object)("Response: " + sb.toString()));
                }
                ModbusResponse sb = ipResponse.getModbusResponse();
                return sb;
            }
            throw new ModbusTransportException(e, request.getSlaveId());
        }
        finally {
            if (!this.keepAlive) {
                this.closeConnection();
            }
        }
    }

    private void openConnection() throws IOException {
        WaitingRoomKeyFactory waitingRoomKeyFactory;
        BaseMessageParser ipMessageParser;
        this.closeConnection();
        Integer soLinger = this.getLingerTime();
        this.socket = new Socket();
        this.socket.setSoTimeout(this.getTimeout());
        if (soLinger == null || soLinger < 0) {
            this.socket.setSoLinger(false, 0);
        } else {
            this.socket.setSoLinger(true, soLinger);
        }
        this.socket.connect(new InetSocketAddress(this.ipParameters.getHost(), this.ipParameters.getPort()), this.getTimeout());
        this.transport = this.getePoll() != null ? new EpollStreamTransport(this.socket.getInputStream(), this.socket.getOutputStream(), this.getePoll()) : new StreamTransport(this.socket.getInputStream(), this.socket.getOutputStream());
        if (this.ipParameters.isEncapsulated()) {
            ipMessageParser = new EncapMessageParser(true);
            waitingRoomKeyFactory = new EncapWaitingRoomKeyFactory();
        } else {
            ipMessageParser = new XaMessageParser(true);
            waitingRoomKeyFactory = new XaWaitingRoomKeyFactory();
        }
        this.conn = this.getMessageControl();
        this.conn.start(this.transport, ipMessageParser, null, waitingRoomKeyFactory);
        if (this.getePoll() == null) {
            ((StreamTransport)this.transport).start("Modbus4J TcpMaster");
        }
    }

    private void closeConnection() {
        this.closeMessageControl(this.conn);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.getExceptionHandler().receivedException(e);
        }
        this.conn = null;
        this.socket = null;
    }

    public Integer getLingerTime() {
        return this.lingerTime;
    }
}

