/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.locator;

import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.base.RangeAndOffset;
import com.huangjian.modbus4j.exception.ModbusIdException;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.locator.BinaryLocator;
import com.huangjian.modbus4j.locator.NumericLocator;
import com.huangjian.modbus4j.locator.StringLocator;
import java.nio.charset.Charset;

public abstract class BaseLocator<T> {
    private final int slaveId;
    protected final int range;
    protected final int offset;

    public static BaseLocator<Boolean> coilStatus(int slaveId, int offset) {
        return new BinaryLocator(slaveId, 1, offset);
    }

    public static BaseLocator<Boolean> inputStatus(int slaveId, int offset) {
        return new BinaryLocator(slaveId, 2, offset);
    }

    public static BaseLocator<Number> inputRegister(int slaveId, int offset, int dataType) {
        return new NumericLocator(slaveId, 4, offset, dataType);
    }

    public static BaseLocator<Boolean> inputRegisterBit(int slaveId, int offset, int bit) {
        return new BinaryLocator(slaveId, 4, offset, bit);
    }

    public static BaseLocator<Number> holdingRegister(int slaveId, int offset, int dataType) {
        return new NumericLocator(slaveId, 3, offset, dataType);
    }

    public static BaseLocator<Boolean> holdingRegisterBit(int slaveId, int offset, int bit) {
        return new BinaryLocator(slaveId, 3, offset, bit);
    }

    public static BaseLocator<?> createLocator(int slaveId, int registerId, int dataType, int bit, int registerCount) {
        RangeAndOffset rao = new RangeAndOffset(registerId);
        return BaseLocator.createLocator(slaveId, rao.getRange(), rao.getOffset(), dataType, bit, registerCount, StringLocator.ASCII);
    }

    public static BaseLocator<?> createLocator(int slaveId, int registerId, int dataType, int bit, int registerCount, Charset charset) {
        RangeAndOffset rao = new RangeAndOffset(registerId);
        return BaseLocator.createLocator(slaveId, rao.getRange(), rao.getOffset(), dataType, bit, registerCount, charset);
    }

    public static BaseLocator<?> createLocator(int slaveId, int range, int offset, int dataType, int bit, int registerCount) {
        return BaseLocator.createLocator(slaveId, range, offset, dataType, bit, registerCount, StringLocator.ASCII);
    }

    public static BaseLocator<?> createLocator(int slaveId, int range, int offset, int dataType, int bit, int registerCount, Charset charset) {
        if (dataType == 1) {
            if (BinaryLocator.isBinaryRange(range)) {
                return new BinaryLocator(slaveId, range, offset);
            }
            return new BinaryLocator(slaveId, range, offset, bit);
        }
        if (dataType == 18 || dataType == 19) {
            return new StringLocator(slaveId, range, offset, dataType, registerCount, charset);
        }
        return new NumericLocator(slaveId, range, offset, dataType);
    }

    public BaseLocator(int slaveId, int range, int offset) {
        this.slaveId = slaveId;
        this.range = range;
        this.offset = offset;
    }

    protected void validate(int registerCount) {
        try {
            ModbusUtils.validateOffset(this.offset);
            ModbusUtils.validateEndOffset(this.offset + registerCount - 1);
        }
        catch (ModbusTransportException e) {
            throw new ModbusIdException(e);
        }
    }

    public abstract int getDataType();

    public abstract int getRegisterCount();

    public int getSlaveId() {
        return this.slaveId;
    }

    public int getRange() {
        return this.range;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.getRegisterCount() - 1;
    }

    public T bytesToValue(byte[] data, int requestOffset) {
        return this.bytesToValueRealOffset(data, this.offset - requestOffset);
    }

    public abstract T bytesToValueRealOffset(byte[] var1, int var2);

    public abstract short[] valueToShorts(T var1);
}

