/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.msg;

import com.huangjian.modbus4j.Modbus;
import com.huangjian.modbus4j.ProcessImage;
import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.msg.ModbusRequest;
import com.huangjian.modbus4j.sero.util.queue.ByteQueue;

public abstract class ReadNumericRequest
extends ModbusRequest {
    private int startOffset;
    private int numberOfRegisters;

    public ReadNumericRequest(int slaveId, int startOffset, int numberOfRegisters) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.numberOfRegisters = numberOfRegisters;
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.startOffset);
        modbus.validateNumberOfRegisters(this.numberOfRegisters);
        ModbusUtils.validateEndOffset(this.startOffset + this.numberOfRegisters - 1);
    }

    ReadNumericRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.numberOfRegisters);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        this.numberOfRegisters = ModbusUtils.popUnsignedShort(queue);
    }

    protected byte[] getData(ProcessImage processImage) throws ModbusTransportException {
        short[] data = new short[this.numberOfRegisters];
        for (int i = 0; i < this.numberOfRegisters; ++i) {
            data[i] = this.getNumeric(processImage, i + this.startOffset);
        }
        return this.convertToBytes(data);
    }

    protected abstract short getNumeric(ProcessImage var1, int var2) throws ModbusTransportException;

    public String toString() {
        return "ReadNumericRequest [startOffset=" + this.startOffset + ", numberOfRegisters=" + this.numberOfRegisters + "]";
    }
}

