/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.msg;

import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.msg.ModbusResponse;
import com.huangjian.modbus4j.sero.util.queue.ByteQueue;

public class ReportSlaveIdResponse
extends ModbusResponse {
    private byte[] data;

    ReportSlaveIdResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    ReportSlaveIdResponse(int slaveId, byte[] data) throws ModbusTransportException {
        super(slaveId);
        this.data = data;
    }

    @Override
    public byte getFunctionCode() {
        return 17;
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        int numberOfBytes = ModbusUtils.popUnsignedByte(queue);
        if (queue.size() < numberOfBytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data = new byte[numberOfBytes];
        queue.pop(this.data);
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushByte(queue, this.data.length);
        queue.push(this.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

