/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.msg;

import com.huangjian.modbus4j.Modbus;
import com.huangjian.modbus4j.ProcessImage;
import com.huangjian.modbus4j.base.ModbusUtils;
import com.huangjian.modbus4j.exception.ModbusTransportException;
import com.huangjian.modbus4j.msg.ModbusRequest;
import com.huangjian.modbus4j.msg.ModbusResponse;
import com.huangjian.modbus4j.msg.WriteCoilResponse;
import com.huangjian.modbus4j.sero.util.queue.ByteQueue;

public class WriteCoilRequest
extends ModbusRequest {
    private int writeOffset;
    private boolean writeValue;

    public WriteCoilRequest(int slaveId, int writeOffset, boolean writeValue) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.writeValue = writeValue;
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.writeOffset);
    }

    WriteCoilRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.writeValue ? 65280 : 0);
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        processImage.writeCoil(this.writeOffset, this.writeValue);
        return new WriteCoilResponse(this.slaveId, this.writeOffset, this.writeValue);
    }

    @Override
    public byte getFunctionCode() {
        return 5;
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new WriteCoilResponse(slaveId);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.writeValue = ModbusUtils.popUnsignedShort(queue) == 65280;
    }
}

