/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.sero.messaging;

import com.huangjian.modbus4j.ModbusConfig;
import com.huangjian.modbus4j.sero.io.StreamUtils;
import com.huangjian.modbus4j.sero.log.BaseIOLog;
import com.huangjian.modbus4j.sero.messaging.DataConsumer;
import com.huangjian.modbus4j.sero.messaging.DefaultMessagingExceptionHandler;
import com.huangjian.modbus4j.sero.messaging.IncomingMessage;
import com.huangjian.modbus4j.sero.messaging.IncomingRequestMessage;
import com.huangjian.modbus4j.sero.messaging.IncomingResponseMessage;
import com.huangjian.modbus4j.sero.messaging.MessageParser;
import com.huangjian.modbus4j.sero.messaging.MessagingExceptionHandler;
import com.huangjian.modbus4j.sero.messaging.OutgoingRequestMessage;
import com.huangjian.modbus4j.sero.messaging.OutgoingResponseMessage;
import com.huangjian.modbus4j.sero.messaging.RequestHandler;
import com.huangjian.modbus4j.sero.messaging.TimeoutException;
import com.huangjian.modbus4j.sero.messaging.Transport;
import com.huangjian.modbus4j.sero.messaging.WaitingRoom;
import com.huangjian.modbus4j.sero.messaging.WaitingRoomKey;
import com.huangjian.modbus4j.sero.messaging.WaitingRoomKeyFactory;
import com.huangjian.modbus4j.sero.timer.SystemTimeSource;
import com.huangjian.modbus4j.sero.timer.TimeSource;
import com.huangjian.modbus4j.sero.util.queue.ByteQueue;
import java.io.IOException;

public class MessageControl
implements DataConsumer {
    private static int DEFAULT_RETRIES = 2;
    private static int DEFAULT_TIMEOUT = 500;
    public boolean DEBUG = false;
    private Transport transport;
    private MessageParser messageParser;
    private RequestHandler requestHandler;
    private WaitingRoomKeyFactory waitingRoomKeyFactory;
    private MessagingExceptionHandler exceptionHandler = new DefaultMessagingExceptionHandler();
    private int retries = DEFAULT_RETRIES;
    private int timeout = DEFAULT_TIMEOUT;
    private int discardDataDelay = 0;
    private long lastDataTimestamp;
    private BaseIOLog ioLog;
    private TimeSource timeSource = new SystemTimeSource();
    private final WaitingRoom waitingRoom = new WaitingRoom();
    private final ByteQueue dataBuffer = new ByteQueue();

    public void start(Transport transport, MessageParser messageParser, RequestHandler handler, WaitingRoomKeyFactory waitingRoomKeyFactory) throws IOException {
        if (transport == null) {
            throw new IllegalArgumentException("transport cannot be null");
        }
        this.transport = transport;
        this.messageParser = messageParser;
        this.requestHandler = handler;
        this.waitingRoomKeyFactory = waitingRoomKeyFactory;
        this.waitingRoom.setKeyFactory(waitingRoomKeyFactory);
        transport.setConsumer(this);
    }

    public void close() {
        if (this.transport != null) {
            this.transport.removeConsumer();
        }
    }

    public void setExceptionHandler(MessagingExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler == null ? new DefaultMessagingExceptionHandler() : exceptionHandler;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDiscardDataDelay() {
        return this.discardDataDelay;
    }

    public void setDiscardDataDelay(int discardDataDelay) {
        this.discardDataDelay = discardDataDelay;
    }

    public BaseIOLog getIoLog() {
        return this.ioLog;
    }

    public void setIoLog(BaseIOLog ioLog) {
        this.ioLog = ioLog;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public IncomingResponseMessage send(OutgoingRequestMessage request) throws IOException {
        return this.send(request, this.timeout, this.retries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingResponseMessage send(OutgoingRequestMessage request, int timeout, int retries) throws IOException {
        byte[] data = request.getMessageData();
        System.out.println("Message read :" + StreamUtils.dumpHex(data) + " ioLog:" + (this.ioLog == null ? "\u4e3a\u7a7a" : "\u4e0d\u4e3a\u7a7a") + " isOpenLog:" + ModbusConfig.isEnalbeSendLog());
        if ((this.DEBUG || ModbusConfig.isEnalbeSendLog()) && this.ioLog != null) {
            this.ioLog.sendByte(StreamUtils.dumpHex(data));
        }
        IncomingResponseMessage response = null;
        if (request.expectsResponse()) {
            WaitingRoomKey key = this.waitingRoomKeyFactory.createWaitingRoomKey(request);
            this.waitingRoom.enter(key);
            try {
                do {
                    this.write(data);
                    response = this.waitingRoom.getResponse(key, timeout);
                    if (!this.DEBUG || response != null) continue;
                    System.out.println("Timeout waiting for response");
                } while (response == null && retries-- > 0);
            }
            finally {
                this.waitingRoom.leave(key);
            }
            if (response == null) {
                throw new TimeoutException("request=" + String.valueOf(request));
            }
        } else {
            this.write(data);
        }
        return response;
    }

    public void send(OutgoingResponseMessage response) throws IOException {
        this.write(response.getMessageData());
    }

    @Override
    public void data(byte[] b, int len) {
        System.out.println("Message read :" + StreamUtils.dumpHex(b, 0, len) + " ioLog:" + (this.ioLog == null ? "\u4e3a\u7a7a" : "\u4e0d\u4e3a\u7a7a") + " isRecLog:" + ModbusConfig.isEnalbeRecvLog());
        if ((this.DEBUG || ModbusConfig.isEnalbeRecvLog()) && this.ioLog != null) {
            System.out.println("Message read :" + StreamUtils.dumpHex(b, 0, len) + " ioLog:" + (this.ioLog == null ? "\u4e3a\u7a7a" : "\u4e0d\u4e3a\u7a7a"));
            this.ioLog.readByte(StreamUtils.dumpHex(b, 0, len));
        }
        if (this.ioLog != null) {
            this.ioLog.input(b, 0, len);
        }
        if (this.discardDataDelay > 0) {
            long now = this.timeSource.currentTimeMillis();
            if (now - this.lastDataTimestamp > (long)this.discardDataDelay) {
                this.dataBuffer.clear();
            }
            this.lastDataTimestamp = now;
        }
        this.dataBuffer.push(b, 0, len);
        block2: while (true) {
            try {
                while (true) {
                    this.dataBuffer.mark();
                    IncomingMessage message = this.messageParser.parseMessage(this.dataBuffer);
                    if (message == null) {
                        this.dataBuffer.reset();
                        break block2;
                    }
                    if (message instanceof IncomingRequestMessage) {
                        OutgoingResponseMessage response;
                        if (this.requestHandler == null || (response = this.requestHandler.handleRequest((IncomingRequestMessage)message)) == null) continue;
                        this.send(response);
                        continue;
                    }
                    this.waitingRoom.response((IncomingResponseMessage)message);
                }
            }
            catch (Exception e) {
                this.exceptionHandler.receivedException(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] data) throws IOException {
        if (this.ioLog != null) {
            this.ioLog.output(data);
        }
        Transport transport = this.transport;
        synchronized (transport) {
            this.transport.write(data);
        }
    }

    @Override
    public void handleIOException(IOException e) {
        this.exceptionHandler.receivedException(e);
    }
}

