/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.sero.messaging;

import com.huangjian.modbus4j.sero.messaging.StreamTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamTransportCharSpaced
extends StreamTransport {
    private final long charSpacing;

    public StreamTransportCharSpaced(InputStream in, OutputStream out, long charSpacing) {
        super(in, out);
        this.charSpacing = charSpacing;
    }

    @Override
    public void write(byte[] data) throws IOException {
        try {
            long waited = 0L;
            for (byte b : data) {
                long writeStart = System.nanoTime();
                this.out.write(b);
                long writeEnd = System.nanoTime();
                waited = writeEnd - writeStart;
                if (waited >= this.charSpacing) continue;
                long waitRemaining = this.charSpacing - waited;
                Thread.sleep(waitRemaining / 1000000L, (int)(waitRemaining % 1000000L));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.out.flush();
    }

    @Override
    public void write(byte[] data, int len) throws IOException {
        try {
            long waited = 0L;
            for (int i = 0; i < len; ++i) {
                long writeStart = System.nanoTime();
                this.out.write(data[i]);
                long writeEnd = System.nanoTime();
                waited = writeEnd - writeStart;
                if (waited >= this.charSpacing) continue;
                long waitRemaining = this.charSpacing - waited;
                Thread.sleep(waitRemaining / 1000000L, (int)(waitRemaining % 1000000L));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.out.flush();
    }
}

