/*
 * Decompiled with CFR 0.152.
 */
package com.huangjian.modbus4j.sero.util;

import java.util.List;

public class ArrayUtils {
    private static int[] bitFromMask = new int[]{255, 127, 63, 31, 15, 7, 3, 1};

    public static String toHexString(byte[] bytes) {
        return ArrayUtils.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int start, int len) {
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(Integer.toHexString(bytes[start] & 0xFF));
        for (int i = 1; i < len; ++i) {
            sb.append(',').append(Integer.toHexString(bytes[start + i] & 0xFF));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toPlainHexString(byte[] bytes) {
        return ArrayUtils.toPlainHexString(bytes, 0, bytes.length);
    }

    public static String toPlainHexString(byte[] bytes, int start, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String s = Integer.toHexString(bytes[start + i] & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toString(byte[] bytes) {
        return ArrayUtils.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int start, int len) {
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(Integer.toString(bytes[start] & 0xFF));
        for (int i = 1; i < len; ++i) {
            sb.append(',').append(Integer.toString(bytes[start + i] & 0xFF));
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isEmpty(int[] value) {
        return value == null || value.length == 0;
    }

    public static int indexOf(String[] values, String value) {
        if (values == null) {
            return -1;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(String[] values, String value) {
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(byte[] src, byte[] target) {
        return ArrayUtils.indexOf(src, 0, src.length, target);
    }

    public static int indexOf(byte[] src, int len, byte[] target) {
        return ArrayUtils.indexOf(src, 0, len, target);
    }

    public static int indexOf(byte[] src, int start, int len, byte[] target) {
        int pos = start;
        while (pos + target.length <= len) {
            if (src[pos] == target[0]) {
                boolean matched = true;
                for (int i = 1; i < target.length; ++i) {
                    if (src[pos + i] == target[i]) continue;
                    matched = false;
                    break;
                }
                if (matched) {
                    return pos;
                }
            }
            ++pos;
        }
        return -1;
    }

    public static long bitRangeValueLong(byte[] b, int offset, int length) {
        if (length <= 0) {
            return 0L;
        }
        int byteFrom = offset / 8;
        int byteTo = (offset + length - 1) / 8;
        long result = b[byteFrom] & bitFromMask[offset % 8];
        for (int i = byteFrom + 1; i <= byteTo; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result >>= 8 - ((offset + length - 1) % 8 + 1);
    }

    public static int bitRangeValue(byte[] b, int offset, int length) {
        return (int)ArrayUtils.bitRangeValueLong(b, offset, length);
    }

    public static long byteRangeValueLong(byte[] b, int offset, int length) {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static int byteRangeValue(byte[] b, int offset, int length) {
        return (int)ArrayUtils.byteRangeValueLong(b, offset, length);
    }

    public static int sum(int[] a) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] result = new double[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String concatenate(Object[] a, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : a) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static void shift(Object[] a, int count) {
        if (count > 0) {
            System.arraycopy(a, 0, a, count, a.length - count);
        } else {
            System.arraycopy(a, -count, a, 0, a.length + count);
        }
    }
}

