/*
 * Decompiled with CFR 0.152.
 */
package io.github.abissell.javautil.concurrent;

import java.util.function.BiPredicate;

public final class LazyVolatile<V, T> {
    private final BiPredicate<T, T> rereadPred;
    private volatile V val;
    private LocalVal<V, T> localVal;

    public LazyVolatile(V initVal, T initTs, BiPredicate<T, T> rereadPred) {
        this.rereadPred = rereadPred;
        this.val = initVal;
        this.localVal = new LocalVal<V, T>(initVal, initTs);
    }

    public V get(T ts) {
        if (this.rereadPred.test(this.localVal.ts, ts)) {
            this.localVal = new LocalVal<V, T>(this.val, ts);
        }
        return this.localVal.val;
    }

    public void set(V val, T ts) {
        this.val = val;
        this.localVal = new LocalVal<V, T>(val, ts);
    }

    private record LocalVal<V, T>(V val, T ts) {
    }
}

