/*
 * Decompiled with CFR 0.152.
 */
package io.github.abissell.javautil.math;

import java.math.RoundingMode;
import java.util.Set;

public final class DoubleRounder {
    private final org.decimal4j.util.DoubleRounder[] rounders;

    public DoubleRounder(Set<Integer> places) {
        int highestPlace = (Integer)places.stream().max(Integer::compareTo).orElseThrow();
        if (highestPlace > 20) {
            throw new IllegalArgumentException("" + highestPlace);
        }
        this.rounders = new org.decimal4j.util.DoubleRounder[highestPlace + 1];
        for (int place : places) {
            this.rounders[place] = new org.decimal4j.util.DoubleRounder(place);
        }
    }

    public double round(double val, int places) {
        return this.rounders[places].round(val);
    }

    public double round(double val, int places, RoundingMode roundingMode) {
        return this.rounders[places].round(val, roundingMode);
    }
}

