/*
 * Decompiled with CFR 0.152.
 */
package org.layout;

import org.layout.Layout;

public final class LayoutContext {
    Layout.LayoutItem[] items = new Layout.LayoutItem[0];
    LayoutRect[] rects = new LayoutRect[0];
    int capacity;
    int count;

    public void reserveItemsCapacity(int count) {
        Layout.layReserveItemsCapacity(this, count);
    }

    public void resetContext() {
        Layout.layResetContext(this);
    }

    public void runContext() {
        Layout.layRunContext(this);
    }

    public void runItem(int item) {
        Layout.layRunItem(this, item);
    }

    public void clearItemBreak(int item) {
        Layout.layClearItemBreak(this, item);
    }

    public int itemsCount() {
        return Layout.layItemsCount(this);
    }

    public int itemsCapacity() {
        return Layout.layItemsCapacity(this);
    }

    public int item() {
        return Layout.layItem(this);
    }

    public int lastChild(int parent) {
        return Layout.layLastChild(this, parent);
    }

    public void insert(int parent, int child) {
        Layout.layInsert(this, parent, child);
    }

    public void append(int earlier, int later) {
        Layout.layAppend(this, earlier, later);
    }

    public void push(int parent, int newChild) {
        Layout.layPush(this, parent, newChild);
    }

    public void setSize(int item, float width, float height) {
        Layout.laySetSize(this, item, width, height);
    }

    public float getSizeX(int item) {
        return Layout.layGetSizeX(this, item);
    }

    public float getSizeY(int item) {
        return Layout.layGetSizeY(this, item);
    }

    public float[] getSizeXY(int item, float[] dst) {
        return Layout.layGetSizeXY(this, item, dst);
    }

    public void setBehave(int item, int flags) {
        Layout.laySetBehave(this, item, flags);
    }

    public void setContain(int item, int flags) {
        Layout.laySetContain(this, item, flags);
    }

    public void setMargins(int item, float left, float top, float right, float bottom) {
        Layout.laySetMargins(this, item, left, top, right, bottom);
    }

    public float[] getMarginsLTRB(int item, float[] dst) {
        return Layout.layGetMarginsLTRB(this, item, dst);
    }

    public int firstChild(int id) {
        return Layout.layFirstChild(this, id);
    }

    public int nextSibling(int id) {
        return Layout.layNextSibling(this, id);
    }

    public float getRectX(int id) {
        return Layout.layGetRectX(this, id);
    }

    public float getRectY(int id) {
        return Layout.layGetRectY(this, id);
    }

    public float getRectWidth(int id) {
        return Layout.layGetRectWidth(this, id);
    }

    public float getRectHeight(int id) {
        return Layout.layGetRectHeight(this, id);
    }

    public float[] getRect(int id, float[] dst) {
        return Layout.layGetRect(this, id, dst);
    }

    public void calcSize(int item, int dim) {
        Layout.layCalcSize(this, item, dim);
    }

    public void arrange(int item, int dim) {
        Layout.layArrange(this, item, dim);
    }

    public static class LayoutRect {
        public float x;
        public float y;
        public float w;
        public float h;

        public float get(int i) {
            switch (i) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.w;
                }
                case 3: {
                    return this.h;
                }
            }
            throw new IllegalArgumentException("Invalid index while reading layout rect component, should be [0;3], given: " + i);
        }

        public void set(int i, float value) {
            switch (i) {
                case 0: {
                    this.x = value;
                    break;
                }
                case 1: {
                    this.y = value;
                    break;
                }
                case 2: {
                    this.w = value;
                    break;
                }
                case 3: {
                    this.h = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid index while setting layout rect component, should be [0;3], given: " + i);
                }
            }
        }
    }
}

