/*
 * Decompiled with CFR 0.152.
 */
package io.github.layout;

import io.github.layout.LayoutContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class Layout {
    public static final int LAY_INVALID_ID = -1;
    public static final int LAY_USERMASK = 0x7FFF0000;
    public static final int LAY_ANY = Integer.MAX_VALUE;
    public static final int LAY_ITEM_BOX_MODEL_MASK = 7;
    public static final int LAY_ITEM_BOX_MASK = 31;
    public static final int LAY_ITEM_LAYOUT_MASK = 992;
    public static final int LAY_ITEM_INSERTED = 1024;
    public static final int LAY_ITEM_HFIXED = 2048;
    public static final int LAY_ITEM_VFIXED = 4096;
    public static final int LAY_ITEM_FIXED_MASK = 6144;
    public static final int LAY_ITEM_COMPARE_MASK = 2147418599;

    @NotNull
    static LayoutItem layGetItem(@NotNull LayoutContext ctx, int id) {
        assert (id >= 0 && id <= ctx.count);
        return ctx.items[id];
    }

    public static void layReserveItemsCapacity(@NotNull LayoutContext ctx, int count) {
        if (count >= ctx.capacity) {
            int prevCapacity = ctx.capacity;
            ctx.capacity = count;
            ctx.items = Arrays.copyOf(ctx.items, ctx.capacity);
            ctx.rects = Arrays.copyOf(ctx.rects, ctx.capacity);
            for (int i = prevCapacity; i < ctx.capacity; ++i) {
                ctx.items[i] = new LayoutItem();
                ctx.rects[i] = new LayoutContext.LayoutRect();
            }
        }
    }

    public static void layResetContext(@NotNull LayoutContext ctx) {
        ctx.count = 0;
    }

    public static void layRunContext(@NotNull LayoutContext ctx) {
        if (ctx.count > 0) {
            Layout.layRunItem(ctx, 0);
        }
    }

    public static void layRunItem(@NotNull LayoutContext ctx, int item) {
        Layout.layCalcSize(ctx, item, 0);
        Layout.layArrange(ctx, item, 0);
        Layout.layCalcSize(ctx, item, 1);
        Layout.layArrange(ctx, item, 1);
    }

    public static void layClearItemBreak(@NotNull LayoutContext ctx, int item) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.flags &= 0xFFFFFDFF;
    }

    public static int layItemsCount(@NotNull LayoutContext ctx) {
        return ctx.count;
    }

    public static int layItemsCapacity(@NotNull LayoutContext ctx) {
        return ctx.capacity;
    }

    public static int layItem(@NotNull LayoutContext ctx) {
        int idx;
        if ((idx = ctx.count++) >= ctx.capacity) {
            Layout.layReserveItemsCapacity(ctx, ctx.capacity < 1 ? 32 : ctx.capacity * 4);
        }
        LayoutItem item = Layout.layGetItem(ctx, idx);
        Layout._clearItem(item);
        item.firstChild = -1;
        item.nextSibling = -1;
        Layout._clearRect(ctx.rects[idx]);
        return idx;
    }

    static void layAppendByPtr(@NotNull LayoutItem pearlier, int later, @NotNull LayoutItem plater) {
        plater.nextSibling = pearlier.nextSibling;
        plater.flags |= 0x400;
        pearlier.nextSibling = later;
    }

    public static int layLastChild(@NotNull LayoutContext ctx, int parent) {
        int next;
        LayoutItem pparent = Layout.layGetItem(ctx, parent);
        int child = pparent.firstChild;
        if (child == -1) {
            return -1;
        }
        LayoutItem pchild = Layout.layGetItem(ctx, child);
        int result = child;
        while ((next = pchild.nextSibling) != -1) {
            result = next;
            pchild = Layout.layGetItem(ctx, next);
        }
        return result;
    }

    public static void layInsert(@NotNull LayoutContext ctx, int parent, int child) {
        assert (child != 0);
        assert (parent != child);
        LayoutItem pparent = Layout.layGetItem(ctx, parent);
        LayoutItem pchild = Layout.layGetItem(ctx, child);
        assert ((pchild.flags & 0x400) == 0);
        if (pparent.firstChild == -1) {
            pparent.firstChild = child;
            pchild.flags |= 0x400;
        } else {
            int next = pparent.firstChild;
            LayoutItem pnext = Layout.layGetItem(ctx, next);
            while ((next = pnext.nextSibling) != -1) {
                pnext = Layout.layGetItem(ctx, next);
            }
            Layout.layAppendByPtr(pnext, child, pchild);
        }
    }

    public static void layAppend(@NotNull LayoutContext ctx, int earlier, int later) {
        assert (later != 0);
        assert (earlier != later);
        LayoutItem pearlier = Layout.layGetItem(ctx, earlier);
        LayoutItem plater = Layout.layGetItem(ctx, later);
        Layout.layAppendByPtr(pearlier, later, plater);
    }

    public static void layPush(@NotNull LayoutContext ctx, int parent, int newChild) {
        assert (newChild != 0);
        assert (parent != newChild);
        LayoutItem pparent = Layout.layGetItem(ctx, parent);
        int oldChild = pparent.firstChild;
        LayoutItem pchild = Layout.layGetItem(ctx, newChild);
        assert ((pchild.flags & 0x400) == 0);
        pparent.firstChild = newChild;
        pchild.flags |= 0x400;
        pchild.nextSibling = oldChild;
    }

    public static void laySetGrow(@NotNull LayoutContext ctx, int item, float grow) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.grow = grow;
    }

    public static float layGetGrow(@NotNull LayoutContext ctx, int item) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        return pitem.grow;
    }

    public static void laySetSize(@NotNull LayoutContext ctx, int item, float width, float height) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.sizeX = width;
        pitem.sizeY = height;
        int flags = pitem.flags;
        flags = width == 0.0f ? (flags &= 0xFFFFF7FF) : (flags |= 0x800);
        flags = height == 0.0f ? (flags &= 0xFFFFEFFF) : (flags |= 0x1000);
        pitem.flags = flags;
    }

    public static float layGetSizeX(@NotNull LayoutContext ctx, int item) {
        return Layout.layGetItem((LayoutContext)ctx, (int)item).sizeX;
    }

    public static float layGetSizeY(@NotNull LayoutContext ctx, int item) {
        return Layout.layGetItem((LayoutContext)ctx, (int)item).sizeY;
    }

    public static float[] layGetSizeXY(@NotNull LayoutContext ctx, int item, float[] dst) {
        assert (dst.length >= 2);
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        dst[0] = pitem.sizeX;
        dst[1] = pitem.sizeY;
        return dst;
    }

    public static void laySetBehave(@NotNull LayoutContext ctx, int item, int flags) {
        assert ((flags & 0x3E0) == flags);
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.flags = pitem.flags & 0xFFFFFC1F | flags;
    }

    public static void laySetContain(@NotNull LayoutContext ctx, int item, int flags) {
        assert ((flags & 0x1F) == flags);
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.flags = pitem.flags & 0xFFFFFFE0 | flags;
    }

    public static void laySetMargins(@NotNull LayoutContext ctx, int item, float left, float top, float right, float bottom) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        pitem.marginLeft = left;
        pitem.marginTop = top;
        pitem.marginRight = right;
        pitem.marginBottom = bottom;
    }

    public static float[] layGetMarginsLTRB(@NotNull LayoutContext ctx, int item, float[] dst) {
        assert (dst.length >= 4);
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        dst[0] = pitem.marginLeft;
        dst[1] = pitem.marginTop;
        dst[2] = pitem.marginRight;
        dst[3] = pitem.marginBottom;
        return dst;
    }

    public static int layFirstChild(@NotNull LayoutContext ctx, int id) {
        return Layout.layGetItem((LayoutContext)ctx, (int)id).firstChild;
    }

    public static int layNextSibling(@NotNull LayoutContext ctx, int id) {
        return Layout.layGetItem((LayoutContext)ctx, (int)id).nextSibling;
    }

    public static float layGetRectX(@NotNull LayoutContext ctx, int id) {
        assert (id >= 0 && id < ctx.count);
        return ctx.rects[id].x;
    }

    public static float layGetRectY(@NotNull LayoutContext ctx, int id) {
        assert (id >= 0 && id < ctx.count);
        return ctx.rects[id].y;
    }

    public static float layGetRectWidth(@NotNull LayoutContext ctx, int id) {
        assert (id >= 0 && id < ctx.count);
        return ctx.rects[id].w;
    }

    public static float layGetRectHeight(@NotNull LayoutContext ctx, int id) {
        assert (id >= 0 && id < ctx.count);
        return ctx.rects[id].h;
    }

    public static float[] layGetRect(@NotNull LayoutContext ctx, int id, float[] dst) {
        assert (id >= 0 && id < ctx.count);
        assert (dst.length >= 4);
        LayoutContext.LayoutRect rect = ctx.rects[id];
        dst[0] = rect.x;
        dst[1] = rect.y;
        dst[2] = rect.w;
        dst[3] = rect.h;
        return dst;
    }

    static float layCalcOverlayedSize(@NotNull LayoutContext ctx, int item, int dim) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        float needSize = 0.0f;
        int child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            LayoutContext.LayoutRect rect = ctx.rects[child];
            float childSize = rect.get(dim) + rect.get(2 + dim) + pchild.margins(wdim);
            needSize = Math.max(needSize, childSize);
            child = pchild.nextSibling;
        }
        return needSize;
    }

    static float layCalcStackedSize(@NotNull LayoutContext ctx, int item, int dim) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        float needSize = 0.0f;
        int child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            LayoutContext.LayoutRect rect = ctx.rects[child];
            needSize += rect.get(dim) + rect.get(2 + dim) + pchild.margins(wdim);
            child = pchild.nextSibling;
        }
        return needSize;
    }

    static float layCalcWrappedOverlayedSize(@NotNull LayoutContext ctx, int item, int dim) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        float needSize = 0.0f;
        float needSize2 = 0.0f;
        int child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            LayoutContext.LayoutRect rect = ctx.rects[child];
            if ((pchild.flags & 0x200) > 0) {
                needSize2 += needSize;
                needSize = 0.0f;
            }
            float childSize = rect.get(dim) + rect.get(2 + dim) + pchild.margins(wdim);
            needSize = Math.max(needSize, childSize);
            child = pchild.nextSibling;
        }
        return needSize2 + needSize;
    }

    static float layCalcWrappedStackedSize(@NotNull LayoutContext ctx, int item, int dim) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        float needSize = 0.0f;
        float needSize2 = 0.0f;
        int child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            LayoutContext.LayoutRect rect = ctx.rects[child];
            if ((pchild.flags & 0x200) > 0) {
                needSize2 = Math.max(needSize2, needSize);
                needSize = 0.0f;
            }
            needSize2 += rect.get(dim) + rect.get(2 + dim) + pchild.margins(wdim);
            child = pchild.nextSibling;
        }
        return Math.max(needSize2, needSize);
    }

    public static void layCalcSize(@NotNull LayoutContext ctx, int item, int dim) {
        float calSize;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        int child = pitem.firstChild;
        while (child != -1) {
            Layout.layCalcSize(ctx, child, dim);
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            child = pchild.nextSibling;
        }
        ctx.rects[item].set(dim, pitem.margins(dim));
        if (pitem.size(dim) != 0.0f) {
            ctx.rects[item].set(2 + dim, pitem.size(dim));
            return;
        }
        switch (pitem.flags & 7) {
            case 4: {
                if (dim > 0) {
                    calSize = Layout.layCalcStackedSize(ctx, item, 1);
                    break;
                }
                calSize = Layout.layCalcOverlayedSize(ctx, item, 0);
                break;
            }
            case 6: {
                if (dim == 0) {
                    calSize = Layout.layCalcWrappedStackedSize(ctx, item, 0);
                    break;
                }
                calSize = Layout.layCalcWrappedOverlayedSize(ctx, item, 1);
                break;
            }
            case 2: 
            case 3: {
                if ((pitem.flags & 1) == dim) {
                    calSize = Layout.layCalcStackedSize(ctx, item, dim);
                    break;
                }
                calSize = Layout.layCalcOverlayedSize(ctx, item, dim);
                break;
            }
            default: {
                calSize = Layout.layCalcOverlayedSize(ctx, item, dim);
            }
        }
        ctx.rects[item].set(2 + dim, calSize);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void layArrangeStacked(@NotNull LayoutContext ctx, int item, int dim, boolean wrap) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        int itemFlags = pitem.flags;
        LayoutContext.LayoutRect rect = ctx.rects[item];
        float space = rect.get(2 + dim);
        float maxX2 = rect.get(dim) + space;
        int startChild = pitem.firstChild;
        while (startChild != -1) {
            float used = 0.0f;
            float sumOfFillers = 0.0f;
            int squeezedCount = 0;
            int total = 0;
            boolean hardbreak = false;
            int child = startChild;
            int endChild = -1;
            while (child != -1) {
                LayoutItem pchild = Layout.layGetItem(ctx, child);
                int childFlags = pchild.flags;
                int flags = (childFlags & 0x3E0) >> dim;
                int fflags = (childFlags & 0x1800) >> dim;
                LayoutContext.LayoutRect childRect = ctx.rects[child];
                float extend = used;
                if ((flags & 0xA0) == 160) {
                    sumOfFillers += pchild.grow == 0.0f ? 1.0f : pchild.grow;
                    extend += childRect.get(dim) + pchild.margins(wdim);
                } else {
                    if ((fflags & 0x800) != 2048) {
                        ++squeezedCount;
                    }
                    extend += childRect.get(dim) + childRect.get(2 + dim) + pchild.margins(wdim);
                }
                if (wrap && total > 0 && (extend > space || (childFlags & 0x200) > 0)) {
                    endChild = child;
                    hardbreak = (childFlags & 0x200) == 512;
                    pchild.flags = childFlags | 0x200;
                    break;
                }
                used = extend;
                child = pchild.nextSibling;
                ++total;
            }
            float extraSpace = space - used;
            float spacer = 0.0f;
            float extraMargin = 0.0f;
            float eater = 0.0f;
            if (extraSpace > 0.0f) {
                if (sumOfFillers <= 0.0f && total > 0) {
                    switch (itemFlags & 0x18) {
                        case 24: {
                            if (wrap && (endChild == -1 || hardbreak)) break;
                            spacer = extraSpace / (float)(total - 1);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 16: {
                            extraMargin = extraSpace;
                            break;
                        }
                        default: {
                            extraMargin = extraSpace / 2.0f;
                            break;
                        }
                    }
                }
            } else if (!wrap && squeezedCount > 0) {
                eater = extraSpace / (float)squeezedCount;
            }
            float x = rect.get(dim);
            child = startChild;
            while (child != endChild) {
                LayoutItem pchild = Layout.layGetItem(ctx, child);
                int childFlags = pchild.flags;
                int flags = (childFlags & 0x3E0) >> dim;
                int fflags = (childFlags & 0x1800) >> dim;
                LayoutContext.LayoutRect childRect = ctx.rects[child];
                float x1 = (flags & 0xA0) == 160 ? x + extraSpace * (pchild.grow == 0.0f ? 1.0f : pchild.grow) / sumOfFillers : ((fflags & 0x800) == 2048 ? x + childRect.get(2 + dim) : (x += childRect.get(dim) + extraMargin) + Math.max(0.0f, childRect.get(2 + dim) + eater));
                float ix0 = x;
                float ix1 = wrap ? Math.min(maxX2 - pchild.margins(wdim), x1) : x1;
                childRect.set(dim, ix0);
                childRect.set(dim + 2, ix1 - ix0);
                x = x1 + pchild.margins(wdim);
                child = pchild.nextSibling;
                extraMargin = spacer;
            }
            startChild = endChild;
        }
        return;
    }

    static void layArrangeOverlay(@NotNull LayoutContext ctx, int item, int dim) {
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        LayoutContext.LayoutRect rect = ctx.rects[item];
        float offset = rect.get(dim);
        float space = rect.get(2 + dim);
        int child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            int bFlags = (pchild.flags & 0x3E0) >> dim;
            LayoutContext.LayoutRect childRect = ctx.rects[child];
            switch (bFlags & 0xA0) {
                case 0: {
                    float centerSize = childRect.get(dim) + (space - childRect.get(2 + dim)) / 2.0f - pchild.margins(wdim);
                    childRect.set(dim, centerSize);
                    break;
                }
                case 128: {
                    float rightSize = childRect.get(dim) + space - childRect.get(2 + dim) - pchild.margins(dim) - pchild.margins(wdim);
                    childRect.set(dim, rightSize);
                    break;
                }
                case 160: {
                    float fillSize = Math.max(0.0f, space - childRect.get(dim) - pchild.margins(wdim));
                    childRect.set(2 + dim, fillSize);
                    break;
                }
            }
            childRect.set(dim, childRect.get(dim) + offset);
            child = pchild.nextSibling;
        }
    }

    static void layArrangeOverlaySqueezedRange(@NotNull LayoutContext ctx, int dim, int startItem, int endItem, float offset, float space) {
        int wdim = dim + 2;
        int item = startItem;
        while (item != endItem) {
            LayoutItem pitem = Layout.layGetItem(ctx, item);
            int bFlags = (pitem.flags & 0x3E0) >> dim;
            LayoutContext.LayoutRect rect = ctx.rects[item];
            float minSize = Math.max(0.0f, space - rect.get(dim) - pitem.margins(wdim));
            switch (bFlags & 0xA0) {
                case 0: {
                    rect.set(2 + dim, Math.min(rect.get(2 + dim), minSize));
                    rect.set(dim, rect.get(dim) + (space - rect.get(2 + dim)) / 2.0f - pitem.margins(wdim));
                    break;
                }
                case 128: {
                    rect.set(2 + dim, Math.min(rect.get(2 + dim), minSize));
                    rect.set(dim, space - rect.get(2 + dim) - pitem.margins(wdim));
                    break;
                }
                case 160: {
                    rect.set(2 + dim, minSize);
                    break;
                }
                default: {
                    rect.set(2 + dim, Math.min(rect.get(2 + dim), minSize));
                }
            }
            rect.set(dim, rect.get(dim) + offset);
            item = pitem.nextSibling;
        }
    }

    static float layArrangeWrappedOverlaySqueezed(@NotNull LayoutContext ctx, int item, int dim) {
        int child;
        int wdim = dim + 2;
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        float offset = ctx.rects[item].get(dim);
        float needSize = 0.0f;
        int startChild = child = pitem.firstChild;
        while (child != -1) {
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            if ((pchild.flags & 0x200) > 0) {
                Layout.layArrangeOverlaySqueezedRange(ctx, dim, startChild, child, offset, needSize);
                offset += needSize;
                startChild = child;
                needSize = 0.0f;
            }
            LayoutContext.LayoutRect rect = ctx.rects[child];
            float childSize = rect.get(dim) + rect.get(2 + dim) + pchild.margins(wdim);
            needSize = Math.max(needSize, childSize);
            child = pchild.nextSibling;
        }
        Layout.layArrangeOverlaySqueezedRange(ctx, dim, startChild, -1, offset, needSize);
        return offset += needSize;
    }

    public static void layArrange(@NotNull LayoutContext ctx, int item, int dim) {
        LayoutItem pitem = Layout.layGetItem(ctx, item);
        int flags = pitem.flags;
        switch (flags & 7) {
            case 7: {
                if (dim == 0) break;
                Layout.layArrangeStacked(ctx, item, 1, true);
                float offset = Layout.layArrangeWrappedOverlaySqueezed(ctx, item, 0);
                ctx.rects[item].set(2, offset - ctx.rects[item].get(0));
                break;
            }
            case 6: {
                if (dim == 0) {
                    Layout.layArrangeStacked(ctx, item, 0, true);
                    break;
                }
                Layout.layArrangeWrappedOverlaySqueezed(ctx, item, 1);
                break;
            }
            case 2: 
            case 3: {
                if ((flags & 1) == dim) {
                    Layout.layArrangeStacked(ctx, item, dim, false);
                    break;
                }
                LayoutContext.LayoutRect rect = ctx.rects[item];
                Layout.layArrangeOverlaySqueezedRange(ctx, dim, pitem.firstChild, -1, rect.get(dim), rect.get(2 + dim));
                break;
            }
            default: {
                Layout.layArrangeOverlay(ctx, item, dim);
            }
        }
        int child = pitem.firstChild;
        while (child != -1) {
            Layout.layArrange(ctx, child, dim);
            LayoutItem pchild = Layout.layGetItem(ctx, child);
            child = pchild.nextSibling;
        }
    }

    private static void _clearItem(@NotNull LayoutItem item) {
        item.flags = 0;
        item.firstChild = 0;
        item.nextSibling = 0;
        item.marginLeft = 0.0f;
        item.marginTop = 0.0f;
        item.marginRight = 0.0f;
        item.marginBottom = 0.0f;
        item.sizeX = 0.0f;
        item.sizeY = 0.0f;
        item.grow = 0.0f;
    }

    private static void _clearRect(@NotNull LayoutContext.LayoutRect rect) {
        rect.h = 0.0f;
        rect.w = 0.0f;
        rect.y = 0.0f;
        rect.x = 0.0f;
    }

    public static final class LayoutItem {
        int flags;
        int firstChild;
        int nextSibling;
        float marginLeft;
        float marginTop;
        float marginRight;
        float marginBottom;
        float sizeX;
        float sizeY;
        float grow;

        LayoutItem() {
        }

        public float margins(int i) {
            switch (i) {
                case 0: {
                    return this.marginLeft;
                }
                case 1: {
                    return this.marginTop;
                }
                case 2: {
                    return this.marginRight;
                }
                case 3: {
                    return this.marginBottom;
                }
            }
            throw new IllegalArgumentException("Invalid index for accessing layout item margin component, should be [0;3], given: " + i);
        }

        public float size(int i) {
            switch (i) {
                case 0: {
                    return this.sizeX;
                }
                case 1: {
                    return this.sizeY;
                }
            }
            throw new IllegalArgumentException("Invalid index for accessing layout item size component, should be [0;1], given: " + i);
        }
    }
}

