/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class Reflect2Utils {
    private static final String TAG = Reflect2Utils.class.getSimpleName();

    private Reflect2Utils() {
    }

    public static boolean setProperty(Object object, String fieldName, Object value) {
        if (object == null || fieldName == null) {
            return false;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
            return true;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "setProperty", new Object[0]);
            return false;
        }
    }

    public static <T> T getProperty(Object object, String fieldName) {
        if (object == null || fieldName == null) {
            return null;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getProperty", new Object[0]);
            return null;
        }
    }

    public static <T> T getStaticProperty(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.getStaticProperty(object.getClass().getName(), fieldName);
    }

    public static <T> T getStaticProperty(Class clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.getStaticProperty(clazz.getName(), fieldName);
    }

    public static <T> T getStaticProperty(String className, String fieldName) {
        if (className == null || fieldName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(clazz);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getStaticProperty", new Object[0]);
            return null;
        }
    }

    public static <T> T invokeMethod(Object object, String methodName) {
        return Reflect2Utils.invokeMethod(object, methodName, null, null);
    }

    public static <T> T invokeMethod(Object object, String methodName, Object[] args) {
        return Reflect2Utils.invokeMethod(object, methodName, args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T invokeMethod(Object object, String methodName, Object[] args, Class[] argsClass) {
        if (object == null || methodName == null) {
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            if (args != null && argsClass != null) {
                if (args.length == argsClass.length && args.length != 0) {
                    Method method = clazz.getDeclaredMethod(methodName, argsClass);
                    method.setAccessible(true);
                    return (T)method.invoke(object, args);
                }
            } else if (args == null && argsClass == null) {
                Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                method.setAccessible(true);
                return (T)method.invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "invokeMethod", new Object[0]);
        }
        return null;
    }

    public static <T> T invokeStaticMethod(Object object, String methodName) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(object.getClass().getName(), methodName, null, null);
    }

    public static <T> T invokeStaticMethod(Object object, String methodName, Object[] args) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(object.getClass().getName(), methodName, args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T invokeStaticMethod(Object object, String methodName, Object[] args, Class[] argsClass) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(object.getClass().getName(), methodName, args, argsClass);
    }

    public static <T> T invokeStaticMethod(Class clazz, String methodName) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(clazz.getName(), methodName, null, null);
    }

    public static <T> T invokeStaticMethod(Class clazz, String methodName, Object[] args) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(clazz.getName(), methodName, args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T invokeStaticMethod(Class clazz, String methodName, Object[] args, Class[] argsClass) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(clazz.getName(), methodName, args, argsClass);
    }

    public static <T> T invokeStaticMethod(String className, String methodName) {
        if (className == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(className, methodName, null, null);
    }

    public static <T> T invokeStaticMethod(String className, String methodName, Object[] args) {
        if (className == null) {
            return null;
        }
        return Reflect2Utils.invokeStaticMethod(className, methodName, args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T invokeStaticMethod(String className, String methodName, Object[] args, Class[] argsClass) {
        if (className == null || methodName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (args != null && argsClass != null) {
                if (args.length == argsClass.length && args.length != 0) {
                    Method method = clazz.getDeclaredMethod(methodName, argsClass);
                    method.setAccessible(true);
                    return (T)method.invoke(clazz, args);
                }
            } else if (args == null && argsClass == null) {
                Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                method.setAccessible(true);
                return (T)method.invoke(clazz, new Object[0]);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "invokeStaticMethod", new Object[0]);
        }
        return null;
    }

    public static <T> T newInstance(Object object) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.newInstance(object.getClass().getName(), null, null);
    }

    public static <T> T newInstance(Object object, Object[] args) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.newInstance(object.getClass().getName(), args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T newInstance(Object object, Object[] args, Class[] argsClass) {
        if (object == null) {
            return null;
        }
        return Reflect2Utils.newInstance(object.getClass().getName(), args, argsClass);
    }

    public static <T> T newInstance(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.newInstance(clazz.getName(), null, null);
    }

    public static <T> T newInstance(Class clazz, Object[] args) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.newInstance(clazz.getName(), args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T newInstance(Class clazz, Object[] args, Class[] argsClass) {
        if (clazz == null) {
            return null;
        }
        return Reflect2Utils.newInstance(clazz.getName(), args, argsClass);
    }

    public static <T> T newInstance(String className) {
        if (className == null) {
            return null;
        }
        return Reflect2Utils.newInstance(className, null, null);
    }

    public static <T> T newInstance(String className, Object[] args) {
        if (className == null) {
            return null;
        }
        return Reflect2Utils.newInstance(className, args, Reflect2Utils.getArgsClass(args));
    }

    public static <T> T newInstance(String className, Object[] args, Class[] argsClass) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> newClass = Class.forName(className);
            if (args == null) {
                return (T)newClass.newInstance();
            }
            Constructor<?> cons = newClass.getConstructor(argsClass);
            return (T)cons.newInstance(args);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "newInstance", new Object[0]);
            return null;
        }
    }

    public static boolean isInstance(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return false;
        }
        try {
            return clazz.isInstance(object);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "isInstance", new Object[0]);
            return false;
        }
    }

    public static Class[] getArgsClass(Object ... args) {
        if (args != null) {
            try {
                Class[] argsClass = new Class[args.length];
                int len = args.length;
                for (int i = 0; i < len; ++i) {
                    argsClass[i] = args[i].getClass();
                }
                return argsClass;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getArgsClass", new Object[0]);
            }
        }
        return new Class[0];
    }

    public static <T> T getProperty(Object object, Field field) {
        if (object == null || field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getProperty", new Object[0]);
            return null;
        }
    }

    public static <T> T getPropertyByParent(Object object, String fieldName) {
        return Reflect2Utils.getPropertyByParent(object, fieldName, 1);
    }

    public static <T> T getPropertyByParent(Object object, String fieldName, int fieldNumber) {
        if (object == null || fieldName == null) {
            return null;
        }
        try {
            Field field = Reflect2Utils.getDeclaredFieldParent(object, fieldName, fieldNumber);
            return Reflect2Utils.getProperty(object, field);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getPropertyByParent", new Object[0]);
            return null;
        }
    }

    public static Field getDeclaredFieldParent(Object object, String fieldName) {
        return Reflect2Utils.getDeclaredFieldParent(object, fieldName, 1);
    }

    public static Field getDeclaredFieldParent(Object object, String fieldName, int fieldNumber) {
        if (object == null || fieldName == null) {
            return null;
        }
        try {
            if (fieldNumber == 0) {
                return null;
            }
            int number = 0;
            int limitNumber = fieldNumber >= 0 ? fieldNumber : Integer.MAX_VALUE;
            Field field = null;
            for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    ++number;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (number < limitNumber) continue;
                return field;
            }
            if (fieldNumber < 0) {
                return field;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getDeclaredFieldParent", new Object[0]);
        }
        return null;
    }
}

