/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.cipher;

import dev.utils.common.cipher.Base64;
import dev.utils.common.cipher.Cipher;

public class Base64Cipher
implements Cipher {
    private Cipher mCipher;
    private int mFlags = 0;

    public Base64Cipher(int flags) {
        this.mFlags = flags;
    }

    public Base64Cipher(Cipher cipher) {
        this.mCipher = cipher;
    }

    public Base64Cipher(Cipher cipher, int flags) {
        this.mCipher = cipher;
        this.mFlags = flags;
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (data == null) {
            return null;
        }
        data = Base64.decode(data, this.mFlags);
        if (this.mCipher != null) {
            data = this.mCipher.decrypt(data);
        }
        return data;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (data == null) {
            return null;
        }
        if (this.mCipher != null) {
            data = this.mCipher.encrypt(data);
        }
        if (data == null) {
            return null;
        }
        return Base64.encode(data, this.mFlags);
    }
}

