/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public final class MD5Utils {
    private static final String TAG = MD5Utils.class.getSimpleName();

    private MD5Utils() {
    }

    public static String md5(String data) {
        if (data == null) {
            return null;
        }
        try {
            return MD5Utils.md5(data.getBytes());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "md5", new Object[0]);
            return null;
        }
    }

    public static String md5(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            return ConvertUtils.toHexString(digest.digest(), true);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "md5", new Object[0]);
            return null;
        }
    }

    public static String md5Upper(String data) {
        if (data == null) {
            return null;
        }
        try {
            return MD5Utils.md5Upper(data.getBytes());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "md5Upper", new Object[0]);
            return null;
        }
    }

    public static String md5Upper(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            return ConvertUtils.toHexString(digest.digest(), false);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "md5Upper", new Object[0]);
            return null;
        }
    }

    public static byte[] getFileMD5(String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return MD5Utils.getFileMD5(file);
    }

    public static String getFileMD5ToHexString(String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return MD5Utils.getFileMD5ToHexString(file);
    }

    public static String getFileMD5ToHexString(File file) {
        return ConvertUtils.toHexString(MD5Utils.getFileMD5(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileMD5(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, digest);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            digest = dis.getMessageDigest();
            byArray = digest.digest();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "getFileMD5", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(dis);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(dis);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(dis);
        return byArray;
    }
}

