/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.thread;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class DevThreadPool {
    private final ExecutorService mThreadPool;
    private ScheduledExecutorService mScheduleExec;

    public DevThreadPool(int threadNumber) {
        if (threadNumber <= 0) {
            threadNumber = 1;
        }
        this.mThreadPool = Executors.newFixedThreadPool(threadNumber);
        this.mScheduleExec = Executors.newScheduledThreadPool(threadNumber);
    }

    public DevThreadPool(ExecutorService threadPool) {
        this.mThreadPool = threadPool;
        this.mScheduleExec = Executors.newScheduledThreadPool(DevThreadPool.getThreads());
    }

    public DevThreadPool(DevThreadPoolType devThreadPoolType) {
        this.mScheduleExec = Executors.newScheduledThreadPool(DevThreadPool.getThreads());
        if (devThreadPoolType != null) {
            switch (devThreadPoolType) {
                case SINGLE: {
                    this.mThreadPool = Executors.newSingleThreadExecutor();
                    this.mScheduleExec = Executors.newScheduledThreadPool(1);
                    break;
                }
                case CALC_CPU: {
                    this.mThreadPool = Executors.newFixedThreadPool(DevThreadPool.getThreads());
                    break;
                }
                case CACHE: {
                    this.mThreadPool = Executors.newCachedThreadPool();
                    break;
                }
                default: {
                    this.mThreadPool = Executors.newFixedThreadPool(DevThreadPool.getThreads());
                    break;
                }
            }
        } else {
            this.mThreadPool = Executors.newFixedThreadPool(DevThreadPool.getThreads());
        }
    }

    public static int getThreads() {
        return DevThreadPool.getCalcThreads();
    }

    public static int getCalcThreads() {
        int cpuNumber = Runtime.getRuntime().availableProcessors();
        if (cpuNumber <= 5) {
            return 5;
        }
        if (cpuNumber * 2 + 1 >= 10) {
            return 10;
        }
        return cpuNumber * 2 + 1;
    }

    public void execute(Runnable runnable) {
        if (this.mThreadPool != null && runnable != null) {
            this.mThreadPool.execute(runnable);
        }
    }

    public void execute(List<Runnable> runnables) {
        if (this.mThreadPool != null && runnables != null) {
            for (Runnable command : runnables) {
                if (command == null) continue;
                this.mThreadPool.execute(command);
            }
        }
    }

    public void execute(final Method method, final Object object) {
        if (this.mThreadPool != null && method != null && object != null) {
            this.mThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void shutdown() {
        if (this.mThreadPool != null) {
            this.mThreadPool.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (this.mThreadPool != null) {
            return this.mThreadPool.shutdownNow();
        }
        return null;
    }

    public boolean isShutdown() {
        if (this.mThreadPool != null) {
            return this.mThreadPool.isShutdown();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.mThreadPool != null) {
            return this.mThreadPool.isTerminated();
        }
        return false;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.mThreadPool != null && unit != null) {
            return this.mThreadPool.awaitTermination(timeout, unit);
        }
        return false;
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (this.mThreadPool != null && task != null) {
            return this.mThreadPool.submit(task);
        }
        return null;
    }

    public <T> Future<T> submit(Runnable task, T result) {
        if (this.mThreadPool != null && task != null) {
            return this.mThreadPool.submit(task, result);
        }
        return null;
    }

    public Future<?> submit(Runnable task) {
        if (this.mThreadPool != null && task != null) {
            return this.mThreadPool.submit(task);
        }
        return null;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.mThreadPool != null && tasks != null) {
            return this.mThreadPool.invokeAll(tasks);
        }
        return null;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.mThreadPool != null && tasks != null && unit != null) {
            return this.mThreadPool.invokeAll(tasks, timeout, unit);
        }
        return null;
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.mThreadPool != null && tasks != null) {
            return this.mThreadPool.invokeAny(tasks);
        }
        return null;
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mThreadPool != null && tasks != null && unit != null) {
            return this.mThreadPool.invokeAny(tasks, timeout, unit);
        }
        return null;
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.mScheduleExec != null && command != null && unit != null) {
            return this.mScheduleExec.schedule(command, delay, unit);
        }
        return null;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.mScheduleExec != null && callable != null && unit != null) {
            return this.mScheduleExec.schedule(callable, delay, unit);
        }
        return null;
    }

    public ScheduledFuture<?> scheduleWithFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.mScheduleExec != null && command != null && unit != null) {
            return this.mScheduleExec.scheduleAtFixedRate(command, initialDelay, period, unit);
        }
        return null;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.mScheduleExec != null && command != null && unit != null) {
            return this.mScheduleExec.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
        return null;
    }

    public static enum DevThreadPoolType {
        SINGLE,
        AUTO_CPU,
        CALC_CPU,
        CACHE;

    }
}

