/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.StringUtils;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public final class HttpParamsUtils {
    private static final String TAG = HttpParamsUtils.class.getSimpleName();

    private HttpParamsUtils() {
    }

    public static Map<String, String> splitParams(String params) {
        return HttpParamsUtils.splitParams(params, false);
    }

    public static Map<String, String> splitParams(String params, boolean urlEncode) {
        HashMap<String, String> mapParams = new HashMap<String, String>();
        if (params != null) {
            String[] keyValues;
            for (String val : keyValues = params.split("&")) {
                int indexOf;
                int valLength;
                if (val == null || (valLength = val.length()) == 0 || (indexOf = val.indexOf(61)) == -1) continue;
                String key = val.substring(0, indexOf);
                String value = indexOf + 1 == valLength ? "" : val.substring(indexOf + 1, valLength);
                if (urlEncode) {
                    mapParams.put(key, HttpParamsUtils.urlEncode(value));
                    continue;
                }
                mapParams.put(key, value);
            }
        }
        return mapParams;
    }

    public static String joinParams(Map<String, String> mapParams) {
        return HttpParamsUtils.joinParams(mapParams, false);
    }

    public static String joinParams(Map<String, String> mapParams, boolean urlEncode) {
        if (mapParams != null) {
            int index = 0;
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : mapParams.entrySet()) {
                if (index > 0) {
                    builder.append('&');
                }
                builder.append(entry.getKey());
                builder.append('=');
                builder.append(urlEncode ? HttpParamsUtils.urlEncode(entry.getValue()) : entry.getValue());
                ++index;
            }
            return builder.toString();
        }
        return null;
    }

    public static String joinParamsObj(Map<String, Object> mapParams) {
        return HttpParamsUtils.joinParamsObj(mapParams, false);
    }

    public static String joinParamsObj(Map<String, Object> mapParams, boolean urlEncode) {
        if (mapParams != null) {
            int index = 0;
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                if (index > 0) {
                    builder.append('&');
                }
                builder.append(entry.getKey());
                builder.append('=');
                if (urlEncode) {
                    if (entry.getValue() instanceof String) {
                        builder.append(HttpParamsUtils.urlEncode((String)entry.getValue()));
                    }
                } else {
                    builder.append(entry.getValue());
                }
                ++index;
            }
            return builder.toString();
        }
        return null;
    }

    public static boolean convertObjToMS(Map<String, String> mapParams, String objStr, String key, String value) {
        if (mapParams != null) {
            String data = null;
            try {
                data = URLEncoder.encode(value, "UTF-8");
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "convertObjToMS", new Object[0]);
            }
            mapParams.put(objStr + "[" + key + "]", data);
            return true;
        }
        return false;
    }

    public static boolean convertObjToMO(Map<String, Object> mapParams, String objStr, String key, Object value) {
        if (mapParams != null) {
            String data = null;
            try {
                data = URLEncoder.encode(value.toString(), "UTF-8");
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "convertObjToMO", new Object[0]);
            }
            mapParams.put(objStr + "[" + key + "]", data);
            return true;
        }
        return false;
    }

    public static String urlEncode(String str) {
        return StringUtils.urlEncode(str);
    }

    public static String urlEncode(String str, String enc) {
        return StringUtils.urlEncode(str, enc);
    }
}

