/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.NumberUtils;
import dev.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public final class CalendarUtils {
    private static final String TAG = CalendarUtils.class.getSimpleName();
    public static final int MIN_LUNAR_YEAR = 1900;
    public static final int MIN_SOLAR_YEAR = 1900;
    public static final int MAX_YEAR = 2099;
    private static final String[] TIAN_GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] DI_ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] CHINESE_NUMBER = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    private static final String[] CHINESE_TEN = new String[]{"\u521d", "\u5341", "\u5eff", "\u4e09"};
    private static final String[] CHINESE_DAY = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static final String[] SOLAR_TERMS = new String[]{"\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2"};
    private static final String[] SOLAR_TERMS_DATE = new String[]{"2.3-5", "2.18-20", "3.5-7", "3.20-22", "4.4-6", "4.19-21", "5.5-7", "5.20-22", "6.5-7", "6.21-22", "7.6-8", "7.22-24", "8.7-9", "8.22-24", "9.7-9", "9.22-24", "10.8-9", "10.23-24", "11.7-8", "11.22-23", "12.6-8", "12.21-23", "1.5-7", "1.20-21"};
    private static final List<Festival> SOLAR_FESTIVAL_LIST = new ArrayList<Festival>();
    private static final List<Festival> LUNAR_FESTIVAL_LIST = new ArrayList<Festival>();
    private static final long[] LUNAR_INFO = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 21844L, 22191L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 53845L, 46415L, 54944L, 44450L, 38320L, 18807L, 18815L, 42160L, 46261L, 27216L, 27968L, 43860L, 11119L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 27285L, 23263L, 11104L, 34531L, 37615L, 51415L, 51551L, 54432L, 55462L, 46431L, 22176L, 42420L, 9695L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 21333L, 19887L, 42416L, 17779L, 21183L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 38310L, 38335L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 23232L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 20854L, 21183L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 53430L, 53855L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 45653L, 27951L, 44448L, 19299L, 37759L, 18936L, 18800L, 25776L, 26790L, 59999L, 27424L, 42692L, 43759L, 37600L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 19285L, 19311L, 42352L, 21732L, 53856L, 59752L, 54560L, 55968L, 27302L, 22239L, 19168L, 43476L, 42192L, 53584L, 62034L, 54560L};
    private static final int[] LUNAR_MONTH_DAYS = new int[]{1887, 5780, 5802, 19157, 2742, 50359, 1198, 2646, 46378, 7466, 3412, 30122, 5482, 67949, 2396, 5294, 43597, 6732, 6954, 36181, 2772, 4954, 18781, 2396, 54427, 5274, 6730, 47781, 5800, 6868, 21210, 4790, 59703, 2350, 5270, 46667, 3402, 3496, 38325, 1388, 4782, 18735, 2350, 52374, 6804, 7498, 44457, 2906, 1388, 29294, 4700, 63789, 6442, 6804, 56138, 5802, 2772, 38235, 1210, 4698, 22827, 5418, 63125, 3476, 5802, 43701, 2484, 5302, 27223, 2646, 70954, 7466, 3412, 54698, 5482, 2412, 38062, 5294, 2636, 32038, 6954, 60245, 2772, 4826, 43357, 2394, 5274, 39501, 6730, 72357, 5800, 5844, 53978, 4790, 2358, 38039, 5270, 87627, 3402, 3496, 54708, 5484, 4782, 43311, 2350, 3222, 27978, 7498, 68965, 2904, 5484, 45677, 4700, 6444, 39573, 6804, 6986, 19285, 2772, 62811, 1210, 4698, 47403, 5418, 5780, 38570, 5546, 76469, 2420, 5302, 51799, 2646, 5414, 36501, 3412, 5546, 18869, 2412, 54446, 5276, 6732, 48422, 6822, 2900, 28010, 4826, 92509, 2394, 5274, 55883, 6730, 6820, 47956, 5812, 2778, 18779, 2358, 62615, 5270, 5450, 46757, 3492, 5556, 27318, 4718, 67887, 2350, 3222, 52554, 7498, 3428, 38252, 5468, 4700, 31022, 6444, 64149, 6804, 6986, 43861, 2772, 5338, 35421, 2650, 70955, 5418, 5780, 54954, 5546, 2740, 38074, 5302, 2646, 29991, 3366, 61011, 3412, 5546, 43445, 2412, 5294, 35406, 6732, 72998, 6820, 6996, 52586, 2778, 2396, 38045, 5274, 6698, 23333, 6820, 64338, 5812, 2746, 43355, 2358, 5270, 39499, 5450, 79525, 3492, 5548};
    private static final int[] SOLAR = new int[]{1887, 966732, 967231, 967733, 968265, 968766, 969297, 969798, 970298, 970829, 971330, 971830, 972362, 972863, 973395, 973896, 974397, 974928, 975428, 975929, 976461, 976962, 977462, 977994, 978494, 979026, 979526, 980026, 980558, 981059, 981559, 982091, 982593, 983124, 983624, 984124, 984656, 985157, 985656, 986189, 986690, 987191, 987722, 988222, 988753, 989254, 989754, 990286, 990788, 991288, 991819, 992319, 992851, 993352, 993851, 994383, 994885, 995385, 995917, 996418, 996918, 997450, 997949, 998481, 998982, 999483, 1000014, 1000515, 1001016, 1001548, 1002047, 1002578, 1003080, 1003580, 1004111, 1004613, 1005113, 1005645, 1006146, 1006645, 1007177, 1007678, 1008209, 1008710, 1009211, 1009743, 1010243, 1010743, 1011275, 1011775, 1012306, 1012807, 1013308, 1013840, 1014341, 1014841, 1015373, 1015874, 1016404, 1016905, 1017405, 1017937, 1018438, 1018939, 1019471, 1019972, 1020471, 1021002, 1021503, 1022035, 1022535, 1023036, 1023568, 1024069, 1024568, 1025100, 1025601, 1026102, 1026633, 1027133, 1027666, 1028167, 1028666, 1029198, 1029699, 1030199, 1030730, 1031231, 1031763, 1032264, 1032764, 1033296, 1033797, 1034297, 1034828, 1035329, 1035830, 1036362, 1036861, 1037393, 1037894, 1038394, 1038925, 1039427, 1039927, 1040459, 1040959, 1041491, 1041992, 1042492, 1043023, 1043524, 1044024, 1044556, 1045057, 1045558, 1046090, 1046590, 1047121, 1047622, 1048122, 1048654, 1049154, 1049655, 1050187, 1050689, 1051219, 1051720, 1052220, 1052751, 1053252, 1053752, 1054284, 1054786, 1055285, 1055817, 1056317, 1056849, 1057349, 1057850, 1058382, 1058883, 1059383, 1059915, 1060415, 1060947, 1061447, 1061947, 1062479, 1062981, 1063480, 1064012, 1064514, 1065014, 1065545, 1066045, 1066577, 1067078, 1067578, 1068110, 1068611, 1069112, 1069642, 1070142, 1070674, 1071175, 1071675, 1072207, 1072709, 1073209, 1073740, 1074241, 1074741, 1075273, 1075773, 1076305, 1076807, 1077308, 1077839, 1078340, 1078840, 1079372, 1079871, 1080403, 1080904};
    private static FestivalHook sFestivalHook;

    private CalendarUtils() {
    }

    public static boolean isSupportLunar(int year) {
        return year <= 2099 && year >= 1900;
    }

    public static boolean isSupportSolar(int year) {
        return year <= 2099 && year >= 1900;
    }

    public static int[] solarToLunar(int year, int month, int day) {
        if (!CalendarUtils.isSupportSolar(year)) {
            return null;
        }
        int[] lunarInt = new int[4];
        int index = year - SOLAR[0];
        int data = year << 9 | month << 5 | day;
        if (SOLAR[index] > data) {
            --index;
        }
        int solar11 = SOLAR[index];
        int y = CalendarUtils.getBitInt(solar11, 12, 9);
        int m = CalendarUtils.getBitInt(solar11, 4, 5);
        int d = CalendarUtils.getBitInt(solar11, 5, 0);
        long offset = CalendarUtils.solarToInt(year, month, day) - CalendarUtils.solarToInt(y, m, d);
        int days = LUNAR_MONTH_DAYS[index];
        int leap = CalendarUtils.getBitInt(days, 4, 13);
        int lunarY = index + SOLAR[0];
        int lunarM = 1;
        ++offset;
        for (int i = 0; i < 13; ++i) {
            int dm;
            int n = dm = CalendarUtils.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
            if (offset <= (long)dm) break;
            ++lunarM;
            offset -= (long)dm;
        }
        int lunarD = (int)offset;
        lunarInt[0] = lunarY;
        lunarInt[1] = lunarM;
        lunarInt[3] = 0;
        if (leap != 0 && lunarM > leap) {
            lunarInt[1] = lunarM - 1;
            if (lunarM == leap + 1) {
                lunarInt[3] = 1;
            }
        }
        lunarInt[2] = lunarD;
        return lunarInt;
    }

    public static int[] lunarToSolar(int lunarYear, int lunarMonth, int lunarDay, boolean isLeap) {
        if (!CalendarUtils.isSupportLunar(lunarYear)) {
            return null;
        }
        int days = LUNAR_MONTH_DAYS[lunarYear - LUNAR_MONTH_DAYS[0]];
        int leap = CalendarUtils.getBitInt(days, 4, 13);
        int offset = 0;
        int loop = leap;
        if (!isLeap) {
            loop = lunarMonth <= leap || leap == 0 ? lunarMonth - 1 : lunarMonth;
        }
        for (int i = 0; i < loop; ++i) {
            offset += CalendarUtils.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
        }
        int solar11 = SOLAR[lunarYear - SOLAR[0]];
        int y = CalendarUtils.getBitInt(solar11, 12, 9);
        int m = CalendarUtils.getBitInt(solar11, 4, 5);
        int d = CalendarUtils.getBitInt(solar11, 5, 0);
        return CalendarUtils.solarFromInt(CalendarUtils.solarToInt(y, m, d) + (long)(offset += lunarDay) - 1L);
    }

    public static int getLunarYearDays(int year) {
        if (!CalendarUtils.isSupportLunar(year)) {
            return 0;
        }
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((LUNAR_INFO[year - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + CalendarUtils.getLunarLeapDays(year);
    }

    public static int getLunarLeapDays(int year) {
        if (!CalendarUtils.isSupportLunar(year)) {
            return 0;
        }
        if (CalendarUtils.getLunarLeapMonth(year) != 0) {
            if ((LUNAR_INFO[year - 1899] & 0xFL) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    public static int getLunarLeapMonth(int year) {
        if (!CalendarUtils.isSupportLunar(year)) {
            return 0;
        }
        long var = LUNAR_INFO[year - 1900] & 0xFL;
        return (int)(var == 15L ? 0L : var);
    }

    public static int getLunarMonthDays(int year, int month) {
        if (!CalendarUtils.isSupportLunar(year)) {
            return 0;
        }
        if ((LUNAR_INFO[year - 1900] & (long)(65536 >> month)) == 0L) {
            return 29;
        }
        return 30;
    }

    public static String getLunarGanZhi(int year) {
        int y = Math.abs(year - 4);
        return TIAN_GAN[y % 10] + DI_ZHI[y % 12];
    }

    public static String getLunarMonthChinese(int month, boolean isLeap) {
        if (month > 12 || month < 1) {
            return null;
        }
        return isLeap ? "\u95f0" + CHINESE_NUMBER[month - 1] + "\u6708" : CHINESE_NUMBER[month - 1] + "\u6708";
    }

    public static String getLunarDayChinese(int day) {
        if (day > 30 || day < 1) {
            return null;
        }
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        int dayIndex = day % 10 == 0 ? 9 : day % 10 - 1;
        return CHINESE_TEN[day / 10] + CHINESE_DAY[dayIndex];
    }

    public static int getSolarTermsIndex(int month, int day) {
        if (month > 12 || month < 1) {
            return -1;
        }
        int start = month - 2 >= 0 ? month - 2 : 11;
        int leftIndex = start * 2;
        int[] dates = CalendarUtils.solarTermsDateSplit(leftIndex);
        if (dates != null && day >= dates[0] && day <= dates[1]) {
            return leftIndex;
        }
        int rightIndex = leftIndex + 1;
        dates = CalendarUtils.solarTermsDateSplit(rightIndex);
        if (dates != null && day >= dates[0] && day <= dates[1]) {
            return rightIndex;
        }
        return -1;
    }

    public static String getSolarTerms(int month, int day) {
        int index = CalendarUtils.getSolarTermsIndex(month, day);
        return index != -1 ? SOLAR_TERMS[index] : null;
    }

    public static String getSolarTermsDate(int month, int day) {
        int index = CalendarUtils.getSolarTermsIndex(month, day);
        return index != -1 ? SOLAR_TERMS_DATE[index] : null;
    }

    public static boolean isFestival(Festival festival, int year, int month, int day) {
        return CalendarUtils.isFestival(festival, year, month, day, sFestivalHook);
    }

    public static boolean isFestival(Festival festival, int year, int month, int day, FestivalHook festivalHook) {
        if (festival == null) {
            return false;
        }
        ArrayList<Festival> list = new ArrayList<Festival>();
        list.add(festival);
        return CalendarUtils.getFestival(list, year, month, day, festivalHook) != null;
    }

    public static Festival getFestival(List<Festival> list, int year, int month, int day) {
        return CalendarUtils.getFestival(list, year, month, day, sFestivalHook);
    }

    public static Festival getFestival(List<Festival> list, int year, int month, int day, FestivalHook festivalHook) {
        if (list == null) {
            return null;
        }
        for (Festival festival : list) {
            Festival hook;
            if (festival == null) continue;
            if (festivalHook != null && (hook = festivalHook.hook(festival, year, month, day)) != null) {
                return hook;
            }
            if (!festival.isFestival(month, day)) continue;
            return festival;
        }
        return null;
    }

    public static Festival getSolarFestival(int year, int month, int day) {
        return CalendarUtils.getFestival(SOLAR_FESTIVAL_LIST, year, month, day);
    }

    public static Festival getLunarFestival(int year, int month, int day) {
        return CalendarUtils.getFestival(LUNAR_FESTIVAL_LIST, year, month, day);
    }

    private static int getBitInt(int data, int length, int shift) {
        return (data & (1 << length) - 1 << shift) >> shift;
    }

    private static long solarToInt(int y, int m, int d) {
        m = (m + 9) % 12;
        return 365 * (y -= m / 10) + y / 4 - y / 100 + y / 400 + (m * 306 + 5) / 10 + (d - 1);
    }

    private static int[] solarFromInt(long g) {
        long y = (10000L * g + 14780L) / 3652425L;
        long ddd = g - (365L * y + y / 4L - y / 100L + y / 400L);
        if (ddd < 0L) {
            ddd = g - (365L * --y + y / 4L - y / 100L + y / 400L);
        }
        long mi = (100L * ddd + 52L) / 3060L;
        long mm = (mi + 2L) % 12L + 1L;
        long dd = ddd - (mi * 306L + 5L) / 10L + 1L;
        int[] solar = new int[]{(int)(y += (mi + 2L) / 12L), (int)mm, (int)dd};
        return solar;
    }

    private static int[] solarTermsDateSplit(int index) {
        try {
            String date = SOLAR_TERMS_DATE[index];
            String[] splits = date.substring(date.indexOf(46) + 1).split("-");
            return new int[]{ConvertUtils.toInt(splits[0]), ConvertUtils.toInt(splits[1])};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "solarTermsDateSplit", new Object[0]);
            return null;
        }
    }

    public static FestivalHook getFestivalHook() {
        return sFestivalHook;
    }

    public static void setFestivalHook(FestivalHook festivalHook) {
        sFestivalHook = festivalHook;
    }

    static {
        SOLAR_FESTIVAL_LIST.clear();
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5143\u65e6", 1, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e2d\u56fd\u4eba\u6c11\u8b66\u5bdf\u8282", 1, 10));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u60c5\u4eba\u8282", 2, 14));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5987\u5973\u8282", 3, 8));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u690d\u6811\u8282", 3, 12));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u6d88\u8d39\u8005\u6743\u76ca\u65e5", 3, 15));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u611a\u4eba\u8282", 4, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u6e05\u660e\u8282", 4, 4));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e16\u754c\u536b\u751f\u65e5", 4, 7));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5730\u7403\u65e5", 4, 22));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u52b3\u52a8\u8282", 5, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u9752\u5e74\u8282", 5, 4));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u62a4\u58eb\u8282", 5, 12));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5168\u56fd\u79d1\u6280\u5de5\u4f5c\u8005\u65e5", 5, 30));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u513f\u7ae5\u8282", 6, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5168\u56fd\u7231\u773c\u65e5", 6, 6));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u56fd\u9645\u7981\u6bd2\u65e5", 6, 26));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5efa\u515a\u8282", 7, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e2d\u56fd\u822a\u6d77\u65e5", 7, 11));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5efa\u519b\u8282", 8, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e2d\u56fd\u533b\u5e08\u8282", 8, 19));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u6559\u5e08\u8282", 9, 10));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e5d\u4e00\u516b\u7eaa\u5ff5\u65e5", 9, 18));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e16\u754c\u963f\u5c14\u8328\u6d77\u9ed8\u75c5\u65e5", 9, 21));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u70c8\u58eb\u7eaa\u5ff5\u65e5", 9, 30));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u56fd\u5e86\u8282", 10, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5168\u56fd\u9ad8\u8840\u538b\u65e5", 10, 8));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e07\u5723\u8282", 10, 31));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u8bb0\u8005\u8282", 11, 8));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5168\u56fd\u6d88\u9632\u65e5", 11, 9));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5149\u68cd\u8282", 11, 11));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u56fd\u9645\u5927\u5b66\u751f\u8282", 11, 17));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e16\u754c\u827e\u6ecb\u75c5\u65e5", 12, 1));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u56fd\u9645\u6b8b\u75be\u4eba\u65e5", 12, 3));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u4e16\u754c\u4eba\u6743\u65e5", 12, 10));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5e73\u5b89\u591c", 12, 24));
        SOLAR_FESTIVAL_LIST.add(new Festival("\u5723\u8bde\u8282", 12, 25));
        LUNAR_FESTIVAL_LIST.clear();
        LUNAR_FESTIVAL_LIST.add(new Festival("\u6625\u8282", 1, 1, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u5143\u5bb5\u8282", 1, 15, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u9f99\u62ac\u5934", 2, 2, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u4e0a\u5df3\u8282", 3, 3, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u7aef\u5348\u8282", 5, 5, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u4e03\u5915\u8282", 7, 7, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u4e2d\u5143\u8282", 7, 15, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u5730\u85cf\u8282", 7, 30, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u7076\u541b\u8bde", 8, 2, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u4e2d\u79cb\u8282", 8, 15, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u5148\u5e08\u8bde", 8, 27, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u91cd\u9633\u8282", 9, 9, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u5bd2\u8863\u8282", 10, 1, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u4e0b\u5143\u8282", 10, 15, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u814a\u516b\u8282", 12, 8, false));
        LUNAR_FESTIVAL_LIST.add(new Festival("\u5c0f\u5e74", 12, 23, false));
        sFestivalHook = new FestivalHook(){

            @Override
            public Festival hook(Festival festival, int year, int month, int day) {
                block11: {
                    block12: {
                        if (festival == null) break block11;
                        if (!festival.isSolarFestival) break block12;
                        int sundays = 0;
                        switch (month) {
                            case 5: {
                                Calendar calendar = Calendar.getInstance();
                                calendar.set(1, year);
                                calendar.set(2, month - 1);
                                int monthDay = calendar.getActualMaximum(5);
                                for (int i = 1; i <= monthDay; ++i) {
                                    calendar.set(5, i);
                                    if (calendar.get(7) != 1 || ++sundays != 2) continue;
                                    if (i == day) {
                                        return new Festival("\u6bcd\u4eb2\u8282", month, day, true);
                                    }
                                    return null;
                                }
                                break block11;
                            }
                            case 6: {
                                Calendar calendar = Calendar.getInstance();
                                calendar.set(1, year);
                                calendar.set(2, month - 1);
                                int monthDay = calendar.getActualMaximum(5);
                                for (int i = 1; i <= monthDay; ++i) {
                                    calendar.set(5, i);
                                    if (calendar.get(7) != 1 || ++sundays != 3) continue;
                                    if (i == day) {
                                        return new Festival("\u7236\u4eb2\u8282", month, day, true);
                                    }
                                    return null;
                                }
                                break;
                            }
                        }
                        break block11;
                    }
                    switch (month) {
                        case 12: {
                            if (CalendarUtils.getLunarMonthDays(year, month) != day || day == 0) break;
                            return new Festival("\u9664\u5915", month, day, false);
                        }
                    }
                }
                return null;
            }
        };
    }

    public static interface FestivalHook {
        public Festival hook(Festival var1, int var2, int var3, int var4);
    }

    public static class Festival
    implements Comparable<Festival> {
        public final String name;
        public final int month;
        public final int day;
        public final boolean isSolarFestival;
        private final int compareValue;

        public Festival(String name, int month, int day) {
            this(name, month, day, true);
        }

        public Festival(String name, int month, int day, boolean isSolarFestival) {
            this.name = name;
            this.month = month;
            this.day = day;
            this.isSolarFestival = isSolarFestival;
            this.compareValue = ConvertUtils.toInt(month + NumberUtils.addZero(day));
        }

        public boolean isFestival(Festival festival) {
            if (festival == null) {
                return false;
            }
            return this.isFestival(festival.month, festival.day, festival.isSolarFestival);
        }

        public boolean isFestival(int month, int day) {
            return this.month == month && this.day == day;
        }

        public boolean isFestival(int month, int day, boolean solarFestival) {
            return this.month == month && this.day == day && this.isSolarFestival == solarFestival;
        }

        @Override
        public int compareTo(Festival festival) {
            int value = this.compareValue;
            int value1 = festival.compareValue;
            if (value < value1) {
                return 1;
            }
            if (value > value1) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return StringUtils.checkValue(this.name) + " " + NumberUtils.addZero(this.month) + NumberUtils.addZero(this.day);
        }
    }

    public static class SolarLunar {
        public final int year;
        public final int month;
        public final int day;
        public final boolean result;
        public final int lunarYear;
        public final int lunarMonth;
        public final int lunarDay;
        public final boolean isLunarLeap;

        public SolarLunar(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
            int[] lunars = CalendarUtils.solarToLunar(year, month, day);
            boolean bl = this.result = lunars != null;
            if (this.result) {
                this.lunarYear = lunars[0];
                this.lunarMonth = lunars[1];
                this.lunarDay = lunars[2];
                this.isLunarLeap = lunars[3] == 1;
            } else {
                this.lunarYear = 0;
                this.lunarMonth = 0;
                this.lunarDay = 0;
                this.isLunarLeap = false;
            }
        }

        public SolarLunar(int lunarYear, int lunarMonth, int lunarDay, boolean isLunarLeap) {
            this.lunarYear = lunarYear;
            this.lunarMonth = lunarMonth;
            this.lunarDay = lunarDay;
            this.isLunarLeap = isLunarLeap;
            int[] solars = CalendarUtils.lunarToSolar(lunarYear, lunarMonth, lunarDay, isLunarLeap);
            boolean bl = this.result = solars != null;
            if (this.result) {
                this.year = solars[0];
                this.month = solars[1];
                this.day = solars[2];
            } else {
                this.year = 0;
                this.month = 0;
                this.day = 0;
            }
        }

        public int getLunarYearDays() {
            return CalendarUtils.getLunarYearDays(this.lunarYear);
        }

        public int getLunarLeapDays() {
            return CalendarUtils.getLunarLeapDays(this.lunarYear);
        }

        public int getLunarLeapMonth() {
            return this.isLunarLeap ? this.lunarMonth : 0;
        }

        public int getLunarMonthDays() {
            return CalendarUtils.getLunarMonthDays(this.lunarYear, this.lunarMonth);
        }

        public String getLunarGanZhi() {
            return CalendarUtils.getLunarGanZhi(this.lunarYear);
        }

        public String getLunarMonthChinese() {
            return CalendarUtils.getLunarMonthChinese(this.lunarMonth, this.isLunarLeap);
        }

        public String getLunarDayChinese() {
            return CalendarUtils.getLunarDayChinese(this.lunarDay);
        }

        public int getSolarTermsIndex() {
            return CalendarUtils.getSolarTermsIndex(this.month, this.day);
        }

        public String getSolarTerms() {
            return CalendarUtils.getSolarTerms(this.month, this.day);
        }

        public String getSolarTermsDate() {
            return CalendarUtils.getSolarTermsDate(this.month, this.day);
        }
    }
}

