/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.common.ChineseUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.validator.ValidatorUtils;
import java.math.BigDecimal;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static String addZero(int value) {
        return NumberUtils.addZero(value, true);
    }

    public static String addZero(int value, boolean append) {
        if (!append) {
            return String.valueOf(value);
        }
        int temp = Math.max(0, value);
        return temp >= 10 ? String.valueOf(temp) : "0" + temp;
    }

    public static String subZeroAndDot(double value) {
        return NumberUtils.subZeroAndDot(String.valueOf(value));
    }

    public static String subZeroAndDot(float value) {
        return NumberUtils.subZeroAndDot(String.valueOf(value));
    }

    public static String subZeroAndDot(String value) {
        if (StringUtils.isNotEmpty(value)) {
            String str = value;
            if (str.contains(".")) {
                str = str.replaceAll("0+?$", "");
                str = str.replaceAll("[.]$", "");
            }
            return str;
        }
        return value;
    }

    public static int percentI(int value, int max) {
        if (max <= 0) {
            return 0;
        }
        if (value <= 0) {
            return 0;
        }
        if (value >= max) {
            return 1;
        }
        return value / max;
    }

    public static int percentI(float value, float max) {
        if (max <= 0.0f) {
            return 0;
        }
        if (value <= 0.0f) {
            return 0;
        }
        if (value >= max) {
            return 1;
        }
        return (int)(value / max);
    }

    public static int percentI(long value, long max) {
        if (max <= 0L) {
            return 0;
        }
        if (value <= 0L) {
            return 0;
        }
        if (value >= max) {
            return 1;
        }
        return (int)(value / max);
    }

    public static int percentI(double value, double max) {
        if (max <= 0.0) {
            return 0;
        }
        if (value <= 0.0) {
            return 0;
        }
        if (value >= max) {
            return 1;
        }
        return (int)(value / max);
    }

    public static double percentD(int value, int max) {
        if (max <= 0) {
            return 0.0;
        }
        if (value <= 0) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return (double)value / (double)max;
    }

    public static double percentD(float value, float max) {
        if (max <= 0.0f) {
            return 0.0;
        }
        if (value <= 0.0f) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return value / max;
    }

    public static double percentD(long value, long max) {
        if (max <= 0L) {
            return 0.0;
        }
        if (value <= 0L) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return (double)value / (double)max;
    }

    public static double percentD(double value, double max) {
        if (max <= 0.0) {
            return 0.0;
        }
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return value / max;
    }

    public static long percentL(int value, int max) {
        if (max <= 0) {
            return 0L;
        }
        if (value <= 0) {
            return 0L;
        }
        if (value >= max) {
            return 1L;
        }
        return (long)value / (long)max;
    }

    public static long percentL(float value, float max) {
        if (max <= 0.0f) {
            return 0L;
        }
        if (value <= 0.0f) {
            return 0L;
        }
        if (value >= max) {
            return 1L;
        }
        return (long)value / (long)max;
    }

    public static long percentL(long value, long max) {
        if (max <= 0L) {
            return 0L;
        }
        if (value <= 0L) {
            return 0L;
        }
        if (value >= max) {
            return 1L;
        }
        return value / max;
    }

    public static long percentL(double value, double max) {
        if (max <= 0.0) {
            return 0L;
        }
        if (value <= 0.0) {
            return 0L;
        }
        if (value >= max) {
            return 1L;
        }
        return (long)(value / max);
    }

    public static float percentF(int value, int max) {
        if (max <= 0) {
            return 0.0f;
        }
        if (value <= 0) {
            return 0.0f;
        }
        if (value >= max) {
            return 1.0f;
        }
        return (float)value / (float)max;
    }

    public static float percentF(float value, float max) {
        if (max <= 0.0f) {
            return 0.0f;
        }
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= max) {
            return 1.0f;
        }
        return value / max;
    }

    public static float percentF(long value, long max) {
        if (max <= 0L) {
            return 0.0f;
        }
        if (value <= 0L) {
            return 0.0f;
        }
        if (value >= max) {
            return 1.0f;
        }
        return (float)value / (float)max;
    }

    public static float percentF(double value, double max) {
        if (max <= 0.0) {
            return 0.0f;
        }
        if (value <= 0.0) {
            return 0.0f;
        }
        if (value >= max) {
            return 1.0f;
        }
        return (float)(value / max);
    }

    public static int percentI2(int value, int max) {
        if (max <= 0) {
            return 0;
        }
        if (value <= 0) {
            return 0;
        }
        return value / max;
    }

    public static int percentI2(float value, float max) {
        if (max <= 0.0f) {
            return 0;
        }
        if (value <= 0.0f) {
            return 0;
        }
        return (int)(value / max);
    }

    public static int percentI2(long value, long max) {
        if (max <= 0L) {
            return 0;
        }
        if (value <= 0L) {
            return 0;
        }
        return (int)(value / max);
    }

    public static int percentI2(double value, double max) {
        if (max <= 0.0) {
            return 0;
        }
        if (value <= 0.0) {
            return 0;
        }
        return (int)(value / max);
    }

    public static double percentD2(int value, int max) {
        if (max <= 0) {
            return 0.0;
        }
        if (value <= 0) {
            return 0.0;
        }
        return (double)value / (double)max;
    }

    public static double percentD2(float value, float max) {
        if (max <= 0.0f) {
            return 0.0;
        }
        if (value <= 0.0f) {
            return 0.0;
        }
        return value / max;
    }

    public static double percentD2(long value, long max) {
        if (max <= 0L) {
            return 0.0;
        }
        if (value <= 0L) {
            return 0.0;
        }
        return (double)value / (double)max;
    }

    public static double percentD2(double value, double max) {
        if (max <= 0.0) {
            return 0.0;
        }
        if (value <= 0.0) {
            return 0.0;
        }
        return value / max;
    }

    public static long percentL2(int value, int max) {
        if (max <= 0) {
            return 0L;
        }
        if (value <= 0) {
            return 0L;
        }
        return (long)value / (long)max;
    }

    public static long percentL2(float value, float max) {
        if (max <= 0.0f) {
            return 0L;
        }
        if (value <= 0.0f) {
            return 0L;
        }
        return (long)value / (long)max;
    }

    public static long percentL2(long value, long max) {
        if (max <= 0L) {
            return 0L;
        }
        if (value <= 0L) {
            return 0L;
        }
        return value / max;
    }

    public static long percentL2(double value, double max) {
        if (max <= 0.0) {
            return 0L;
        }
        if (value <= 0.0) {
            return 0L;
        }
        return (long)(value / max);
    }

    public static float percentF2(int value, int max) {
        if (max <= 0) {
            return 0.0f;
        }
        if (value <= 0) {
            return 0.0f;
        }
        return (float)value / (float)max;
    }

    public static float percentF2(float value, float max) {
        if (max <= 0.0f) {
            return 0.0f;
        }
        if (value <= 0.0f) {
            return 0.0f;
        }
        return value / max;
    }

    public static float percentF2(long value, long max) {
        if (max <= 0L) {
            return 0.0f;
        }
        if (value <= 0L) {
            return 0.0f;
        }
        return (float)value / (float)max;
    }

    public static float percentF2(double value, double max) {
        if (max <= 0.0) {
            return 0.0f;
        }
        if (value <= 0.0) {
            return 0.0f;
        }
        return (float)(value / max);
    }

    public static int clamp(int value, int max, int min) {
        return value > max ? max : Math.max(value, min);
    }

    public static double clamp(double value, double max, double min) {
        return value > max ? max : Math.max(value, min);
    }

    public static long clamp(long value, long max, long min) {
        return value > max ? max : Math.max(value, min);
    }

    public static float clamp(float value, float max, float min) {
        return value > max ? max : Math.max(value, min);
    }

    public static int getMultiple(int value, int divisor) {
        if (value <= 0 || divisor <= 0) {
            return 0;
        }
        if (value <= divisor) {
            return 1;
        }
        return value % divisor == 0 ? value / divisor : value / divisor + 1;
    }

    public static int getMultiple(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0;
        }
        if (value <= divisor) {
            return 1;
        }
        int result = (int)(value / divisor);
        return value - divisor * (double)result == 0.0 ? result : result + 1;
    }

    public static int getMultiple(long value, long divisor) {
        if (value <= 0L || divisor <= 0L) {
            return 0;
        }
        if (value <= divisor) {
            return 1;
        }
        return (int)(value % divisor == 0L ? value / divisor : value / divisor + 1L);
    }

    public static int getMultiple(float value, float divisor) {
        if (value <= 0.0f || divisor <= 0.0f) {
            return 0;
        }
        if (value <= divisor) {
            return 1;
        }
        int result = (int)(value / divisor);
        return value - divisor * (float)result == 0.0f ? result : result + 1;
    }

    public static int getMultipleI(int value, int divisor) {
        if (value <= 0 || divisor <= 0) {
            return 0;
        }
        return value / divisor;
    }

    public static int getMultipleI(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0;
        }
        return (int)(value / divisor);
    }

    public static int getMultipleI(long value, long divisor) {
        if (value <= 0L || divisor <= 0L) {
            return 0;
        }
        return (int)(value / divisor);
    }

    public static int getMultipleI(float value, float divisor) {
        if (value <= 0.0f || divisor <= 0.0f) {
            return 0;
        }
        return (int)(value / divisor);
    }

    public static double getMultipleD(int value, int divisor) {
        if ((double)value <= 0.0 || (double)divisor <= 0.0) {
            return 0.0;
        }
        return (double)value / (double)divisor;
    }

    public static double getMultipleD(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0.0;
        }
        return value / divisor;
    }

    public static double getMultipleD(long value, long divisor) {
        if ((double)value <= 0.0 || (double)divisor <= 0.0) {
            return 0.0;
        }
        return (double)value / (double)divisor;
    }

    public static double getMultipleD(float value, float divisor) {
        if ((double)value <= 0.0 || (double)divisor <= 0.0) {
            return 0.0;
        }
        return (double)value / (double)divisor;
    }

    public static long getMultipleL(int value, int divisor) {
        if ((long)value <= 0L || (long)divisor <= 0L) {
            return 0L;
        }
        return (long)value / (long)divisor;
    }

    public static long getMultipleL(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0L;
        }
        return (long)value / (long)divisor;
    }

    public static long getMultipleL(long value, long divisor) {
        if (value <= 0L || divisor <= 0L) {
            return 0L;
        }
        return value / divisor;
    }

    public static long getMultipleL(float value, float divisor) {
        if (value <= 0.0f || divisor <= 0.0f) {
            return 0L;
        }
        return (long)value / (long)divisor;
    }

    public static float getMultipleF(int value, int divisor) {
        if ((float)value <= 0.0f || (float)divisor <= 0.0f) {
            return 0.0f;
        }
        return (float)value / (float)divisor;
    }

    public static float getMultipleF(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0.0f;
        }
        return (float)value / (float)divisor;
    }

    public static float getMultipleF(long value, long divisor) {
        if ((float)value <= 0.0f || (float)divisor <= 0.0f) {
            return 0.0f;
        }
        return (float)value / (float)divisor;
    }

    public static float getMultipleF(float value, float divisor) {
        if (value <= 0.0f || divisor <= 0.0f) {
            return 0.0f;
        }
        return value / divisor;
    }

    public static int[] calculateUnit(double[] units, double value) {
        if (units == null) {
            return null;
        }
        if (value <= 0.0) {
            return null;
        }
        int len = units.length;
        int[] arrays = new int[len];
        double temp = value;
        for (int i = 0; i < len; ++i) {
            if (!(temp >= units[i])) continue;
            int mode = (int)(temp / units[i]);
            temp -= (double)mode * units[i];
            arrays[i] = mode;
        }
        return arrays;
    }

    public static String numberToCHN(double number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static String numberToCHN(String number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static String numberToCHN(BigDecimal number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static boolean isNumber(String str) {
        return ValidatorUtils.isNumber(str);
    }

    public static boolean isNumberDecimal(String str) {
        return ValidatorUtils.isNumberDecimal(str);
    }
}

