/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;

public final class CRCUtils {
    private static final String TAG = CRCUtils.class.getSimpleName();

    private CRCUtils() {
    }

    public static long getCRC32(String data) {
        if (data == null) {
            return -1L;
        }
        try {
            CRC32 crc32 = new CRC32();
            crc32.update(data.getBytes());
            return crc32.getValue();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getCRC32", new Object[0]);
            return -1L;
        }
    }

    public static String getCRC32ToHexString(String data) {
        if (data == null) {
            return null;
        }
        try {
            CRC32 crc32 = new CRC32();
            crc32.update(data.getBytes());
            return Long.toHexString(crc32.getValue());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getCRC32ToHexString", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileCRC32(String filePath) {
        String string;
        if (filePath == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            int numRead;
            is = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            CRC32 crc32 = new CRC32();
            while ((numRead = ((InputStream)is).read(buffer)) > 0) {
                crc32.update(buffer, 0, numRead);
            }
            string = Long.toHexString(crc32.getValue());
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "getFileCRC32", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(is);
            return null;
        }
        CloseUtils.closeIOQuietly(is);
        return string;
    }
}

