/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.RandomUtils;
import java.math.BigDecimal;
import java.util.Random;

public final class ChineseUtils {
    private static final String TAG = ChineseUtils.class.getSimpleName();
    private static final int ZERO = 0;
    private static final int TEN_POS = 10;
    private static final String[] CHN_NUMBER_UNITS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u767e", "\u5343", "\u4e07", "\u4ebf", "\u5146"};
    private static final String[] CHN_NUMBER_UPPER_UNITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u4ebf", "\u5146"};
    private static final double[] NUMBER_UNITS = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 100.0, 1000.0, 10000.0, 1.0E8, 1.0E12};

    private ChineseUtils() {
    }

    public static String randomWord(int number) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            builder.append(ChineseUtils.randomWord());
        }
        return builder.toString();
    }

    public static String randomWord() {
        Random random = new Random();
        int heightPos = 176 + Math.abs(random.nextInt(39));
        int lowPos = 161 + Math.abs(random.nextInt(93));
        byte[] bytes = new byte[]{Integer.valueOf(heightPos).byteValue(), Integer.valueOf(lowPos).byteValue()};
        try {
            return new String(bytes, "GBK");
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "randomWord", new Object[0]);
            return "";
        }
    }

    public static String randomName(String[] surnames, String[] names) {
        return ChineseUtils.randomName(surnames, names, 1);
    }

    public static String randomName(String[] surnames, String[] names, int nameLength) {
        if (surnames != null && surnames.length != 0 && names != null && names.length != 0) {
            return RandomUtils.getRandom(surnames, 1) + RandomUtils.getRandom(names, nameLength);
        }
        return null;
    }

    public static String numberToCHN(double number, boolean isUpper) {
        try {
            return ChineseUtils.numberToCHNNumber(BigDecimal.valueOf(number), isUpper ? CHN_NUMBER_UPPER_UNITS : CHN_NUMBER_UNITS);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "numberToCHN", new Object[0]);
            return null;
        }
    }

    public static String numberToCHN(String number, boolean isUpper) {
        if (number != null) {
            try {
                return ChineseUtils.numberToCHNNumber(new BigDecimal(number), isUpper ? CHN_NUMBER_UPPER_UNITS : CHN_NUMBER_UNITS);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "numberToCHN", new Object[0]);
            }
        }
        return null;
    }

    public static String numberToCHN(BigDecimal number, boolean isUpper) {
        return ChineseUtils.numberToCHNNumber(number, isUpper ? CHN_NUMBER_UPPER_UNITS : CHN_NUMBER_UNITS);
    }

    private static String numberToCHNNumber(BigDecimal bigDecimal, String[] chnUnits) {
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal number = bigDecimal.setScale(0, 1);
        if (number.doubleValue() < 1.0) {
            return chnUnits[0];
        }
        StringBuilder builder = new StringBuilder();
        int unitIndex = 0;
        int beforeUnitIndex = 0;
        for (int i = NUMBER_UNITS.length - 1; i > 0; --i) {
            double numberValue;
            if (number.doubleValue() >= NUMBER_UNITS[i]) {
                int multiple = (int)(number.doubleValue() / NUMBER_UNITS[i]);
                number = number.subtract(BigDecimal.valueOf((double)multiple * NUMBER_UNITS[i]));
                if (multiple >= 10000) {
                    builder.append(ChineseUtils.numberToCHNNumber(new BigDecimal(multiple), chnUnits));
                    builder.append(chnUnits[i]);
                    if (unitIndex > i && unitIndex != 0) {
                        builder.append(chnUnits[0]);
                    }
                } else {
                    if (i == 14 && unitIndex == 15 || i == 13 && unitIndex == 14) {
                        if (multiple < 1000) {
                            builder.append(chnUnits[0]);
                        }
                    } else if (unitIndex > i && unitIndex != 0) {
                        builder.append(chnUnits[0]);
                    }
                    builder.append(ChineseUtils.thousandConvertCHN(multiple, chnUnits));
                    builder.append(chnUnits[i]);
                }
                beforeUnitIndex = unitIndex;
                unitIndex = i;
            }
            if (!((numberValue = number.doubleValue()) < 10000.0)) continue;
            if (unitIndex >= 13 && numberValue >= 1.0) {
                if (beforeUnitIndex == 0) {
                    beforeUnitIndex = unitIndex;
                }
                if (unitIndex != 13 && (beforeUnitIndex == 14 || beforeUnitIndex == 15) && beforeUnitIndex >= unitIndex) {
                    builder.append(chnUnits[0]);
                } else if (numberValue < 1000.0) {
                    builder.append(chnUnits[0]);
                }
            }
            builder.append(ChineseUtils.thousandConvertCHN((int)numberValue, chnUnits));
            return builder.toString();
        }
        return builder.toString();
    }

    private static String thousandConvertCHN(int value, String[] chnUnits) {
        StringBuilder builder = new StringBuilder();
        int number = value;
        int[] units = new int[]{10, 100, 1000};
        boolean[] zeros = new boolean[]{number >= 10, number >= 100, false};
        for (int i = 2; i >= 0; --i) {
            if (number >= units[i]) {
                int multiple = number / units[i];
                number -= multiple * units[i];
                builder.append(chnUnits[multiple]);
                builder.append(chnUnits[10 + i]);
                zeros[i] = false;
            }
            if (number < 1 || !zeros[i]) continue;
            if (i == 1) {
                builder.append(chnUnits[0]);
                continue;
            }
            if (zeros[i + 1]) continue;
            builder.append(chnUnits[0]);
        }
        if (number >= 1) {
            builder.append(chnUnits[number]);
        }
        return builder.toString();
    }
}

