/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist.search;

import dev.utils.JCLogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public final class FileBreadthFirstSearchUtils {
    private static final String TAG = FileBreadthFirstSearchUtils.class.getSimpleName();
    private SearchHandler mSearchHandler;
    private final SearchHandler mInnerHandler = new SearchHandler(){

        @Override
        public boolean isHandlerFile(File file) {
            if (FileBreadthFirstSearchUtils.this.mSearchHandler != null) {
                return FileBreadthFirstSearchUtils.this.mSearchHandler.isHandlerFile(file);
            }
            return true;
        }

        @Override
        public boolean isAddToList(File file) {
            if (FileBreadthFirstSearchUtils.this.mSearchHandler != null) {
                return FileBreadthFirstSearchUtils.this.mSearchHandler.isAddToList(file);
            }
            return true;
        }

        @Override
        public void onEndListener(FileItem rootFileItem, long startTime, long endTime) {
            FileBreadthFirstSearchUtils.this.mIsRunning = false;
            if (FileBreadthFirstSearchUtils.this.mSearchHandler != null) {
                FileBreadthFirstSearchUtils.this.mSearchHandler.onEndListener(rootFileItem, startTime, endTime);
            }
        }
    };
    private FileItem mRootFileItem;
    private boolean mIsRunning = false;
    private boolean mIsStop = false;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private long mDelayTime = 50L;
    private int mQueueSameTimeNumber = 5;
    private final ExecutorService mExecutor = Executors.newCachedThreadPool();
    private final LinkedBlockingQueue<FileQueue> mTaskQueue = new LinkedBlockingQueue();

    public FileBreadthFirstSearchUtils() {
    }

    public FileBreadthFirstSearchUtils(SearchHandler searchHandler) {
        this.mSearchHandler = searchHandler;
    }

    public FileBreadthFirstSearchUtils setSearchHandler(SearchHandler searchHandler) {
        this.mSearchHandler = searchHandler;
        return this;
    }

    public int getQueueSameTimeNumber() {
        return this.mQueueSameTimeNumber;
    }

    public synchronized FileBreadthFirstSearchUtils setQueueSameTimeNumber(int queueSameTimeNumber) {
        if (this.mIsRunning) {
            return this;
        }
        this.mQueueSameTimeNumber = queueSameTimeNumber;
        return this;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void stop() {
        this.mIsStop = true;
    }

    public boolean isStop() {
        return this.mIsStop;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public long getDelayTime() {
        return this.mDelayTime;
    }

    public FileBreadthFirstSearchUtils setDelayTime(long delayTimeMillis) {
        this.mDelayTime = delayTimeMillis;
        return this;
    }

    public synchronized void query(String path) {
        if (this.mIsRunning) {
            return;
        }
        if (path == null || path.trim().length() == 0) {
            this.mInnerHandler.onEndListener(null, -1L, -1L);
            return;
        }
        this.mIsRunning = true;
        this.mIsStop = false;
        this.mStartTime = System.currentTimeMillis();
        try {
            File file = new File(path);
            this.mRootFileItem = new FileItem(file);
            if (file.isFile()) {
                this.mEndTime = System.currentTimeMillis();
                this.mInnerHandler.onEndListener(this.mRootFileItem, this.mStartTime, this.mEndTime);
                return;
            }
            String[] fileArrays = file.list();
            if (fileArrays != null && fileArrays.length != 0) {
                new Thread(() -> {
                    this.queryFile(this.mRootFileItem.file, this.mRootFileItem);
                    this.whileQueue();
                }).start();
            } else {
                this.mEndTime = System.currentTimeMillis();
                this.mInnerHandler.onEndListener(this.mRootFileItem, this.mStartTime, this.mEndTime);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "query", new Object[0]);
            this.mEndTime = System.currentTimeMillis();
            this.mInnerHandler.onEndListener(this.mRootFileItem, this.mStartTime, this.mEndTime);
        }
    }

    private void queryFile(File file, FileItem fileItem) {
        try {
            if (this.mIsStop) {
                return;
            }
            if (file != null && file.exists() && this.mInnerHandler.isHandlerFile(file)) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        return;
                    }
                    for (File queryFile : files) {
                        if (queryFile.isDirectory()) {
                            if (this.mIsStop) {
                                return;
                            }
                            FileItem subFileItem = fileItem.put(queryFile);
                            this.mTaskQueue.offer(new FileQueue(queryFile, subFileItem));
                            continue;
                        }
                        if (this.mIsStop || !this.mInnerHandler.isAddToList(queryFile)) continue;
                        fileItem.put(queryFile);
                    }
                } else if (!this.mIsStop && this.mInnerHandler.isAddToList(file)) {
                    fileItem.put(file);
                }
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "queryFile", new Object[0]);
        }
    }

    private void whileQueue() {
        boolean isEmpty = this.mTaskQueue.isEmpty();
        while (!isEmpty && !this.mIsStop) {
            int threadCount = ((ThreadPoolExecutor)this.mExecutor).getActiveCount();
            if (threadCount > this.mQueueSameTimeNumber) continue;
            FileQueue fileQueue = this.mTaskQueue.poll();
            if (fileQueue != null) {
                this.mExecutor.execute(() -> this.queryFile(fileQueue.file, fileQueue.fileItem));
            }
            if (!(isEmpty = this.mTaskQueue.isEmpty() && threadCount == 0)) continue;
            if (this.mIsStop) break;
            try {
                Thread.sleep(this.mDelayTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            isEmpty = this.mTaskQueue.isEmpty();
        }
        this.mEndTime = System.currentTimeMillis();
        this.mInnerHandler.onEndListener(this.mRootFileItem, this.mStartTime, this.mEndTime);
    }

    public static interface SearchHandler {
        public boolean isHandlerFile(File var1);

        public boolean isAddToList(File var1);

        public void onEndListener(FileItem var1, long var2, long var4);
    }

    private static class FileQueue {
        private final File file;
        private final FileItem fileItem;

        FileQueue(File file, FileItem fileItem) {
            this.file = file;
            this.fileItem = fileItem;
        }
    }

    public static final class FileItem {
        public File file;
        public Map<String, FileItem> mapChilds;

        public FileItem(File file) {
            this.file = file;
        }

        private synchronized FileItem put(File file) {
            if (this.mapChilds == null) {
                this.mapChilds = new HashMap<String, FileItem>();
            }
            if (file != null) {
                FileItem fileItem = new FileItem(file);
                this.mapChilds.put(file.getAbsolutePath(), fileItem);
                return fileItem;
            }
            return null;
        }
    }
}

