/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.NumberUtils;
import dev.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ColorUtils {
    private static final String TAG = ColorUtils.class.getSimpleName();
    public static final int TRANSPARENT = 0;
    public static final int WHITE = -1;
    public static final int WHITE_TRANSLUCENT = -2130706433;
    public static final int BLACK = -16777216;
    public static final int BLACK_TRANSLUCENT = Integer.MIN_VALUE;
    public static final int RED = -65536;
    public static final int RED_TRANSLUCENT = -2130771968;
    public static final int GREEN = -16711936;
    public static final int GREEN_TRANSLUCENT = -2147418368;
    public static final int BLUE = -16776961;
    public static final int BLUE_TRANSLUCENT = -2147483393;
    public static final int GRAY = -6908266;
    public static final int GRAY_TRANSLUCENT = -2137614698;
    public static final int SKYBLUE = -7876885;
    public static final int ORANGE = -23296;
    public static final int GOLD = -10496;
    public static final int PINK = -16181;
    public static final int FUCHSIA = -65281;
    public static final int GRAYWHITE = -855310;
    public static final int PURPLE = -8388480;
    public static final int CYAN = -16711681;
    public static final int YELLOW = -256;
    public static final int CHOCOLATE = -2987746;
    public static final int TOMATO = -40121;
    public static final int ORANGERED = -47872;
    public static final int SILVER = -4144960;
    public static final int DKGRAY = -12303292;
    public static final int LTGRAY = -3355444;
    public static final int MAGENTA = -65281;
    public static final int HIGHLIGHT = 0x33FFFFFF;
    public static final int LOWLIGHT = 0x33000000;
    private static final Map<String, Integer> sColorNameMaps;
    private static ColorInfo.Parser sParser;

    private ColorUtils() {
    }

    public static String hexAlpha(int alpha) {
        try {
            if (alpha >= 0 && alpha <= 255) {
                return Integer.toHexString(alpha);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "hexAlpha", new Object[0]);
        }
        return null;
    }

    public static int[] getARGB(int color) {
        int[] argb = new int[]{ColorUtils.isARGB(color) ? ColorUtils.alpha(color) : 255, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color)};
        return argb;
    }

    public static int alpha(int color) {
        return color >>> 24;
    }

    public static float alphaPercent(int color) {
        return NumberUtils.percentF(ColorUtils.alpha(color), 255.0);
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static float redPercent(int color) {
        return NumberUtils.percentF(ColorUtils.red(color), 255.0);
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static float greenPercent(int color) {
        return NumberUtils.percentF(ColorUtils.green(color), 255.0);
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static float bluePercent(int color) {
        return NumberUtils.percentF(ColorUtils.blue(color), 255.0);
    }

    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int rgb(float red, float green, float blue) {
        return 0xFF000000 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public static boolean isRGB(int color) {
        int red = ColorUtils.red(color);
        int green = ColorUtils.green(color);
        int blue = ColorUtils.blue(color);
        return red <= 255 && red >= 0 && green <= 255 && green >= 0 && blue <= 255 && blue >= 0;
    }

    public static boolean isARGB(int color) {
        int alpha = ColorUtils.alpha(color);
        int red = ColorUtils.red(color);
        int green = ColorUtils.green(color);
        int blue = ColorUtils.blue(color);
        return alpha <= 255 && alpha >= 0 && red <= 255 && red >= 0 && green <= 255 && green >= 0 && blue <= 255 && blue >= 0;
    }

    public static int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static int setAlpha(int color, float alpha) {
        return color & 0xFFFFFF | (int)(alpha * 255.0f + 0.5f) << 24;
    }

    public static int setRed(int color, int red) {
        return color & 0xFF00FFFF | red << 16;
    }

    public static int setRed(int color, float red) {
        return color & 0xFF00FFFF | (int)(red * 255.0f + 0.5f) << 16;
    }

    public static int setGreen(int color, int green) {
        return color & 0xFFFF00FF | green << 8;
    }

    public static int setGreen(int color, float green) {
        return color & 0xFFFF00FF | (int)(green * 255.0f + 0.5f) << 8;
    }

    public static int setBlue(int color, int blue) {
        return color & 0xFFFFFF00 | blue;
    }

    public static int setBlue(int color, float blue) {
        return color & 0xFFFFFF00 | (int)(blue * 255.0f + 0.5f);
    }

    private static int priParseColor(String colorStr) {
        if (colorStr.charAt(0) == '#') {
            long color = Long.parseLong(colorStr.substring(1), 16);
            if (colorStr.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (colorStr.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color;
        }
        Integer color = sColorNameMaps.get(colorStr.toLowerCase(Locale.ROOT));
        if (color != null) {
            return color;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static int parseColor(String colorStr) {
        if (colorStr != null) {
            try {
                return ColorUtils.priParseColor(colorStr);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "parseColor", new Object[0]);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static String intToRgbString(int colorInt) {
        try {
            int color = colorInt;
            String colorStr = Integer.toHexString(color &= 0xFFFFFF);
            while (colorStr.length() < 6) {
                colorStr = "0" + colorStr;
            }
            return "#" + colorStr;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "intToRgbString", new Object[0]);
            return null;
        }
    }

    public static String intToArgbString(int colorInt) {
        try {
            String colorString = Integer.toHexString(colorInt);
            while (colorString.length() < 6) {
                colorString = "0" + colorString;
            }
            while (colorString.length() < 8) {
                colorString = "f" + colorString;
            }
            return "#" + colorString;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "intToArgbString", new Object[0]);
            return null;
        }
    }

    public static int getRandomColor() {
        return ColorUtils.getRandomColor(true);
    }

    public static int getRandomColor(boolean supportAlpha) {
        int high = supportAlpha ? (int)(Math.random() * 256.0) << 24 : -16777216;
        return high | (int)(Math.random() * 1.6777216E7);
    }

    public static String getRandomColorString() {
        return ColorUtils.getRandomColorString(true);
    }

    public static String getRandomColorString(boolean supportAlpha) {
        if (supportAlpha) {
            return ColorUtils.intToArgbString(ColorUtils.getRandomColor(supportAlpha));
        }
        return ColorUtils.intToRgbString(ColorUtils.getRandomColor(supportAlpha));
    }

    public static boolean judgeColorString(String colorStr) {
        if (colorStr != null && colorStr.length() == 8) {
            char cc = colorStr.charAt(0);
            return cc == '0' || cc == '1' || cc == '2' || cc == '3' || cc == '4' || cc == '5' || cc == '6' || cc == '7' || cc == '8' || cc == '9' || cc == 'A' || cc == 'B' || cc == 'C' || cc == 'D' || cc == 'E' || cc == 'F' || cc == 'a' || cc == 'b' || cc == 'c' || cc == 'd' || cc == 'e' || cc == 'f';
        }
        return false;
    }

    public static int setDark(String colorStr, int darkValue) {
        int color = ColorUtils.parseColor(colorStr);
        return ColorUtils.setDark(color, darkValue);
    }

    public static int setDark(int color, int darkValue) {
        int red = ColorUtils.red(color);
        int green = ColorUtils.green(color);
        int blue = ColorUtils.blue(color);
        int colorTemp = color;
        colorTemp = ColorUtils.setRed(colorTemp, NumberUtils.clamp(red -= darkValue, 255, 0));
        colorTemp = ColorUtils.setGreen(colorTemp, NumberUtils.clamp(green -= darkValue, 255, 0));
        colorTemp = ColorUtils.setBlue(colorTemp, NumberUtils.clamp(blue -= darkValue, 255, 0));
        return colorTemp;
    }

    public static int setLight(String colorStr, int lightValue) {
        int color = ColorUtils.parseColor(colorStr);
        return ColorUtils.setLight(color, lightValue);
    }

    public static int setLight(int color, int lightValue) {
        int red = ColorUtils.red(color);
        int green = ColorUtils.green(color);
        int blue = ColorUtils.blue(color);
        int colorTemp = color;
        colorTemp = ColorUtils.setRed(colorTemp, NumberUtils.clamp(red += lightValue, 255, 0));
        colorTemp = ColorUtils.setGreen(colorTemp, NumberUtils.clamp(green += lightValue, 255, 0));
        colorTemp = ColorUtils.setBlue(colorTemp, NumberUtils.clamp(blue += lightValue, 255, 0));
        return colorTemp;
    }

    public static int setAlphaDark(String colorStr, int darkValue) {
        int color = ColorUtils.parseColor(colorStr);
        return ColorUtils.setAlphaDark(color, darkValue);
    }

    public static int setAlphaDark(int color, int darkValue) {
        int alpha = ColorUtils.alpha(color);
        return ColorUtils.setAlpha(color, NumberUtils.clamp(alpha += darkValue, 255, 0));
    }

    public static int setAlphaLight(String colorStr, int lightValue) {
        int color = ColorUtils.parseColor(colorStr);
        return ColorUtils.setAlphaLight(color, lightValue);
    }

    public static int setAlphaLight(int color, int lightValue) {
        int alpha = ColorUtils.alpha(color);
        return ColorUtils.setAlpha(color, NumberUtils.clamp(alpha -= lightValue, 255, 0));
    }

    public static int grayLevel(String colorStr) {
        int color = ColorUtils.parseColor(colorStr);
        int[] argb = ColorUtils.getARGB(color);
        return (int)((float)argb[1] * 0.299f + (float)argb[2] * 0.587f + (float)argb[3] * 0.114f);
    }

    public static int grayLevel(int color) {
        int[] argb = ColorUtils.getARGB(color);
        return (int)((float)argb[1] * 0.299f + (float)argb[2] * 0.587f + (float)argb[3] * 0.114f);
    }

    public static void setParser(ColorInfo.Parser parser) {
        sParser = parser;
    }

    public static void sortGray(List<ColorInfo> lists) {
        Collections.sort(lists, (c1, c2) -> {
            long diff = c1.getGrayLevel() - c2.getGrayLevel();
            if (diff < 0L) {
                return 1;
            }
            if (diff > 0L) {
                return -1;
            }
            return 0;
        });
    }

    public static void sortHUE(List<ColorInfo> lists) {
        Collections.sort(lists, (c1, c2) -> {
            float diff = c1.getHue() - c2.getHue();
            if (diff > 0.0f) {
                return 1;
            }
            if (diff < 0.0f) {
                return -1;
            }
            return 0;
        });
    }

    public static void sortSaturation(List<ColorInfo> lists) {
        Collections.sort(lists, (c1, c2) -> {
            float diff = c1.getSaturation() - c2.getSaturation();
            if (diff > 0.0f) {
                return 1;
            }
            if (diff < 0.0f) {
                return -1;
            }
            return 0;
        });
    }

    public static void sortBrightness(List<ColorInfo> lists) {
        Collections.sort(lists, (c1, c2) -> {
            float diff = c1.getBrightness() - c2.getBrightness();
            if (diff > 0.0f) {
                return 1;
            }
            if (diff < 0.0f) {
                return -1;
            }
            return 0;
        });
    }

    public static int blendColor(String color1, String color2, float ratio) {
        return ColorUtils.blendColor(ColorUtils.parseColor(color1), ColorUtils.parseColor(color2), ratio);
    }

    public static int blendColor(int color1, int color2, float ratio) {
        int[] color1Argb = ColorUtils.getARGB(color1);
        int[] color2Argb = ColorUtils.getARGB(color2);
        float inverseRatio = 1.0f - ratio;
        float a = (float)color1Argb[0] * inverseRatio + (float)color2Argb[0] * ratio;
        float r = (float)color1Argb[1] * inverseRatio + (float)color2Argb[1] * ratio;
        float g = (float)color1Argb[2] * inverseRatio + (float)color2Argb[2] * ratio;
        float b = (float)color1Argb[3] * inverseRatio + (float)color2Argb[3] * ratio;
        return ColorUtils.argb((int)a, (int)r, (int)g, (int)b);
    }

    public static int transitionColor(String startColor, String endColor, float ratio) {
        return ColorUtils.transitionColor(ColorUtils.parseColor(startColor), ColorUtils.parseColor(endColor), ratio);
    }

    public static int transitionColor(int startColor, int endColor, float ratio) {
        int[] startArgb = ColorUtils.getARGB(startColor);
        int[] endArgb = ColorUtils.getARGB(endColor);
        int startAlpha = startArgb[0];
        int startRed = startArgb[1];
        int startGreen = startArgb[2];
        int startBlue = startArgb[3];
        int endAlpha = endArgb[0];
        int endRed = endArgb[1];
        int endGreen = endArgb[2];
        int endBlue = endArgb[3];
        float a = (float)(endAlpha - startAlpha) * ratio + (float)startAlpha;
        float r = (float)(endRed - startRed) * ratio + (float)startRed;
        float g = (float)(endGreen - startGreen) * ratio + (float)startGreen;
        float b = (float)(endBlue - startBlue) * ratio + (float)startBlue;
        return ColorUtils.argb((int)a, (int)r, (int)g, (int)b);
    }

    static {
        ColorUtils.setParser(new ColorInfo.ColorParser());
        sColorNameMaps = new HashMap<String, Integer>();
        sColorNameMaps.put("transparent", 0);
        sColorNameMaps.put("white", -1);
        sColorNameMaps.put("black", -16777216);
        sColorNameMaps.put("red", -65536);
        sColorNameMaps.put("green", -16711936);
        sColorNameMaps.put("blue", -16776961);
        sColorNameMaps.put("gray", -6908266);
        sColorNameMaps.put("grey", -6908266);
        sColorNameMaps.put("skyblue", -7876885);
        sColorNameMaps.put("orange", -23296);
        sColorNameMaps.put("gold", -10496);
        sColorNameMaps.put("pink", -16181);
        sColorNameMaps.put("fuchsia", -65281);
        sColorNameMaps.put("graywhite", -855310);
        sColorNameMaps.put("purple", -8388480);
        sColorNameMaps.put("cyan", -16711681);
        sColorNameMaps.put("yellow", -256);
        sColorNameMaps.put("chocolate", -2987746);
        sColorNameMaps.put("tomato", -40121);
        sColorNameMaps.put("orangered", -47872);
        sColorNameMaps.put("silver", -4144960);
        sColorNameMaps.put("darkgray", -12303292);
        sColorNameMaps.put("lightgray", -3355444);
        sColorNameMaps.put("lightgrey", -3355444);
        sColorNameMaps.put("magenta", -65281);
        sColorNameMaps.put("highlight", 0x33FFFFFF);
        sColorNameMaps.put("lowlight", 0x33000000);
        sColorNameMaps.put("aqua", -16711681);
        sColorNameMaps.put("lime", -16711936);
        sColorNameMaps.put("maroon", -8388608);
        sColorNameMaps.put("navy", -16777088);
        sColorNameMaps.put("olive", -8355840);
        sColorNameMaps.put("teal", -16744320);
    }

    public static class ColorInfo {
        private final String key;
        private final String value;
        private String valueParser;
        private long valueColor;
        private int alpha = 255;
        private int red = 0;
        private int green = 0;
        private int blue = 0;
        private int grayLevel;
        private float hue;
        private float saturation;
        private float brightness;

        public ColorInfo(String key, String value) {
            this.key = key;
            this.value = value;
            this.priConvert();
        }

        public ColorInfo(String key, int valueColor) {
            this(key, ColorUtils.intToArgbString(valueColor));
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getValueParser() {
            return this.valueParser;
        }

        public long getValueColor() {
            return this.valueColor;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public int getGrayLevel() {
            return this.grayLevel;
        }

        public float getHue() {
            return this.hue;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getBrightness() {
            return this.brightness;
        }

        public String toString() {
            return "key : " + this.key + "\nvalue : " + this.value + "\nvalueParser : " + this.valueParser + "\nalpha : " + this.alpha + "\nred : " + this.red + "\ngreen : " + this.green + "\nblue : " + this.blue + "\ngrayLevel : " + this.grayLevel + "\nintToRgbString : " + ColorUtils.intToRgbString((int)this.valueColor) + "\nintToArgbString : " + ColorUtils.intToArgbString((int)this.valueColor);
        }

        private void priConvert() {
            String temp = this.value;
            if (sParser != null) {
                this.valueParser = temp = sParser.handleColor(this.value);
            }
            if (temp == null) {
                return;
            }
            this.valueColor = ColorUtils.parseColor(temp);
            int[] argb = ColorUtils.getARGB((int)this.valueColor);
            this.alpha = argb[0];
            this.red = argb[1];
            this.green = argb[2];
            this.blue = argb[3];
            this.grayLevel = (int)((float)argb[1] * 0.299f + (float)argb[2] * 0.587f + (float)argb[3] * 0.114f);
            float[] hsbArrays = ColorInfo.RGBtoHSB(this.red, this.green, this.blue, null);
            this.hue = hsbArrays[0];
            this.saturation = hsbArrays[1];
            this.brightness = hsbArrays[2];
        }

        private static float[] RGBtoHSB(int r, int g, int b, float[] hsbArrays) {
            float hue;
            int cmin;
            int cmax;
            if (hsbArrays == null) {
                hsbArrays = new float[3];
            }
            if (b > (cmax = Math.max(r, g))) {
                cmax = b;
            }
            if (b < (cmin = Math.min(r, g))) {
                cmin = b;
            }
            float brightness = (float)cmax / 255.0f;
            float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
            if (saturation == 0.0f) {
                hue = 0.0f;
            } else {
                float redc = (float)(cmax - r) / (float)(cmax - cmin);
                float greenc = (float)(cmax - g) / (float)(cmax - cmin);
                float bluec = (float)(cmax - b) / (float)(cmax - cmin);
                hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
                if ((hue /= 6.0f) < 0.0f) {
                    hue += 1.0f;
                }
            }
            hsbArrays[0] = hue;
            hsbArrays[1] = saturation;
            hsbArrays[2] = brightness;
            return hsbArrays;
        }

        public static class ColorParser
        implements Parser {
            @Override
            public String handleColor(String value) {
                if (value == null) {
                    return null;
                }
                String color = StringUtils.clearSpace(value);
                char[] chars = color.toCharArray();
                int length = chars.length;
                if (length != 0 && chars[0] == '#') {
                    if (length == 4) {
                        String colorSub = color.substring(1);
                        return color + colorSub;
                    }
                    if (length == 5) {
                        String colorSub = color.substring(3);
                        return color + colorSub + colorSub;
                    }
                }
                return color;
            }
        }

        public static interface Parser {
            public String handleColor(String var1);
        }
    }
}

