/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileIOUtils {
    private static final String TAG = FileIOUtils.class.getSimpleName();
    private static int sBufferSize = 8192;
    public static final int EOF = -1;

    private FileIOUtils() {
    }

    public static void setBufferSize(int bufferSize) {
        sBufferSize = bufferSize;
    }

    public static FileInputStream getFileInputStream(String filePath) {
        return FileIOUtils.getFileInputStream(FileUtils.getFile(filePath));
    }

    public static FileInputStream getFileInputStream(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getFileInputStream", new Object[0]);
            return null;
        }
    }

    public static FileOutputStream getFileOutputStream(String filePath) {
        return FileIOUtils.getFileOutputStream(FileUtils.getFile(filePath));
    }

    public static FileOutputStream getFileOutputStream(String filePath, boolean append) {
        return FileIOUtils.getFileOutputStream(FileUtils.getFile(filePath), append);
    }

    public static FileOutputStream getFileOutputStream(File file) {
        return FileIOUtils.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(File file, boolean append) {
        if (file == null) {
            return null;
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getFileOutputStream", new Object[0]);
            return null;
        }
    }

    public static boolean writeFileFromIS(String filePath, InputStream inputStream) {
        return FileIOUtils.writeFileFromIS(FileUtils.getFileByPath(filePath), inputStream, false);
    }

    public static boolean writeFileFromIS(String filePath, InputStream inputStream, boolean append) {
        return FileIOUtils.writeFileFromIS(FileUtils.getFileByPath(filePath), inputStream, append);
    }

    public static boolean writeFileFromIS(File file, InputStream inputStream) {
        return FileIOUtils.writeFileFromIS(file, inputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream inputStream, boolean append) {
        boolean bl;
        if (inputStream == null || !FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[sBufferSize];
            while ((len = inputStream.read(data, 0, sBufferSize)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "writeFileFromIS", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(inputStream, os);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(inputStream, os);
            return bl2;
        }
        CloseUtils.closeIOQuietly(inputStream, os);
        return bl;
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(FileUtils.getFileByPath(filePath), bytes, false);
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes, boolean append) {
        return FileIOUtils.writeFileFromBytesByStream(FileUtils.getFileByPath(filePath), bytes, append);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(file, bytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByStream(File file, byte[] bytes, boolean append) {
        boolean bl;
        if (bytes == null || !FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file, append));
            bos.write(bytes);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "writeFileFromBytesByStream", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(bos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(bos);
            return bl2;
        }
        CloseUtils.closeIOQuietly(bos);
        return bl;
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(FileUtils.getFileByPath(filePath), bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(FileUtils.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean append, boolean isForce) {
        boolean bl;
        if (bytes == null || !FileUtils.createOrExistsFile(file)) {
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap(bytes));
            if (isForce) {
                fc.force(true);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "writeFileFromBytesByChannel", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(fc);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(fc);
            return bl2;
        }
        CloseUtils.closeIOQuietly(fc);
        return bl;
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(filePath, bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(FileUtils.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean append, boolean isForce) {
        boolean bl;
        if (bytes == null || !FileUtils.createOrExistsFile(file)) {
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, fc.size(), bytes.length);
            mbb.put(bytes);
            if (isForce) {
                mbb.force();
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "writeFileFromBytesByMap", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(fc);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(fc);
            return bl2;
        }
        CloseUtils.closeIOQuietly(fc);
        return bl;
    }

    public static boolean writeFileFromString(String filePath, String content) {
        return FileIOUtils.writeFileFromString(FileUtils.getFileByPath(filePath), content, false);
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileIOUtils.writeFileFromString(FileUtils.getFileByPath(filePath), content, append);
    }

    public static boolean writeFileFromString(File file, String content) {
        return FileIOUtils.writeFileFromString(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (content == null || !FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, append));
            bw.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "writeFileFromString", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(bw);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(bw);
            return bl2;
        }
        CloseUtils.closeIOQuietly(bw);
        return bl;
    }

    public static List<String> readFileToList(String filePath) {
        return FileIOUtils.readFileToList(FileUtils.getFileByPath(filePath), null);
    }

    public static List<String> readFileToList(String filePath, String charsetName) {
        return FileIOUtils.readFileToList(FileUtils.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFileToList(File file) {
        return FileIOUtils.readFileToList(file, 0, Integer.MAX_VALUE, null);
    }

    public static List<String> readFileToList(File file, String charsetName) {
        return FileIOUtils.readFileToList(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFileToList(String filePath, int start, int end) {
        return FileIOUtils.readFileToList(FileUtils.getFileByPath(filePath), start, end, null);
    }

    public static List<String> readFileToList(String filePath, int start, int end, String charsetName) {
        return FileIOUtils.readFileToList(FileUtils.getFileByPath(filePath), start, end, charsetName);
    }

    public static List<String> readFileToList(File file, int start, int end) {
        return FileIOUtils.readFileToList(file, start, end, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileToList(File file, int start, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        if (start > end) {
            return null;
        }
        BufferedReader br = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            br = StringUtils.isEmpty((CharSequence)charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = br.readLine()) != null && curLine <= end; ++curLine) {
                if (start > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                JCLogUtils.eTag(TAG, e, "readFileToList", new Object[0]);
                list = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(br);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(br);
            return list;
        }
        CloseUtils.closeIOQuietly(br);
        return arrayList;
    }

    public static String readFileToString(String filePath) {
        return FileIOUtils.readFileToString(FileUtils.getFileByPath(filePath), null);
    }

    public static String readFileToString(String filePath, String charsetName) {
        return FileIOUtils.readFileToString(FileUtils.getFileByPath(filePath), charsetName);
    }

    public static String readFileToString(File file) {
        return FileIOUtils.readFileToString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String charsetName) {
        String string;
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        BufferedReader br = null;
        try {
            StringBuilder builder = new StringBuilder();
            br = StringUtils.isEmpty((CharSequence)charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            String line = br.readLine();
            if (line != null) {
                builder.append(line);
                while ((line = br.readLine()) != null) {
                    builder.append(DevFinal.NEW_LINE_STR).append(line);
                }
            }
            string = builder.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                JCLogUtils.eTag(TAG, e, "readFileToString", new Object[0]);
                string2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(br);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(br);
            return string2;
        }
        CloseUtils.closeIOQuietly(br);
        return string;
    }

    public static byte[] readFileToBytesByStream(String filePath) {
        return FileIOUtils.readFileToBytesByStream(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytesByStream(File file) {
        byte[] byArray;
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] b = new byte[sBufferSize];
            while ((len = fis.read(b, 0, sBufferSize)) != -1) {
                baos.write(b, 0, len);
            }
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "readFileToBytesByStream", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(fis, baos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(fis, baos);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(fis, baos);
        return byArray;
    }

    public static byte[] readFileToBytesByChannel(String filePath) {
        return FileIOUtils.readFileToBytesByChannel(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytesByChannel(File file) {
        byte[] byArray;
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fc.size());
            while (fc.read(byteBuffer) > 0) {
            }
            byArray = byteBuffer.array();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "readFileToBytesByChannel", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(fc);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(fc);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(fc);
        return byArray;
    }

    public static byte[] readFileToBytesByMap(String filePath) {
        return FileIOUtils.readFileToBytesByMap(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytesByMap(File file) {
        byte[] byArray;
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            int size = (int)fc.size();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size).load();
            byte[] result = new byte[size];
            mbb.get(result, 0, size);
            byArray = result;
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "readFileToBytesByMap", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(fc);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(fc);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(fc);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        long l;
        if (inputStream == null || outputStream == null) {
            return -1L;
        }
        try {
            int n;
            byte[] data = new byte[sBufferSize];
            long count = 0L;
            while (-1 != (n = inputStream.read(data))) {
                outputStream.write(data, 0, n);
                count += (long)n;
            }
            l = count;
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "copyLarge", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(inputStream, outputStream);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(inputStream, outputStream);
            return -1L;
        }
        CloseUtils.closeIOQuietly(inputStream, outputStream);
        return l;
    }
}

