/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist.record;

import dev.utils.DevFinal;
import dev.utils.common.ConvertUtils;
import dev.utils.common.DateUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.ThrowableUtils;
import dev.utils.common.assist.record.RecordConfig;
import dev.utils.common.assist.record.RecordInsert;
import java.io.File;

public final class FileRecordUtils {
    private static final String RECORD_SUCCESS = "record successful";
    private static boolean sHandler = true;
    private static RecordInsert sRecordInsert = null;
    private static Callback sCallback = null;

    private FileRecordUtils() {
    }

    private static String concatInsertLog(RecordInsert recordInsert, String logContent) {
        if (recordInsert == null) {
            return logContent;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty(recordInsert.getLogHeader())) {
            builder.append(recordInsert.getLogHeader());
        }
        builder.append(logContent);
        if (StringUtils.isNotEmpty(recordInsert.getLogTail())) {
            builder.append(recordInsert.getLogTail());
        }
        return builder.toString();
    }

    private static String concatLog(RecordConfig config, Object ... logs) {
        if (logs == null || logs.length == 0) {
            return null;
        }
        boolean headerData = config == null || config.isInsertHeaderData();
        StringBuilder builder = new StringBuilder();
        if (headerData) {
            builder.append(DevFinal.NEW_LINE_STR_X2).append(DateUtils.getDateNow()).append(" =>");
        }
        int len = logs.length;
        for (int i = 0; i < len; ++i) {
            Object object;
            builder.append(DevFinal.NEW_LINE_STR_X2);
            if (headerData) {
                builder.append("logs[").append(i).append("]: ").append(DevFinal.NEW_LINE_STR);
            }
            if ((object = logs[i]) instanceof Throwable) {
                String errorLog = ThrowableUtils.getThrowableStackTrace((Throwable)object);
                builder.append(errorLog);
                continue;
            }
            builder.append(ConvertUtils.toString(object));
        }
        return builder.toString();
    }

    private static String finalRecord(RecordConfig config, Object ... logs) {
        String fileInfo;
        String fileName;
        if (!sHandler) {
            return "global do not handle";
        }
        if (config == null) {
            return "config is null";
        }
        if (!config.isHandler()) {
            return "config do not handle";
        }
        if (logs == null || logs.length == 0) {
            return "no data record";
        }
        String filePath = config.getFinalPath();
        if (StringUtils.isEmpty(filePath, fileName = config.getFileName())) {
            return "filePath is null";
        }
        RecordInsert recordInsert = config.getRecordInsert(sRecordInsert);
        String logContent = FileRecordUtils.concatLog(config, logs);
        String finalLogContent = FileRecordUtils.concatInsertLog(recordInsert, logContent);
        File file = FileUtils.getFile(filePath, fileName);
        if (!FileUtils.isFileExists(file) && recordInsert != null && (fileInfo = recordInsert.getFileInfo()) != null) {
            FileUtils.saveFile(file, StringUtils.getBytes(fileInfo));
        }
        boolean result = FileUtils.appendFile(file, StringUtils.getBytes(finalLogContent));
        if (sCallback != null) {
            sCallback.callback(result, config, filePath, fileName, finalLogContent, logs);
        }
        return result ? RECORD_SUCCESS : "record failed";
    }

    public static boolean isSuccessful(String value) {
        return RECORD_SUCCESS.equals(value);
    }

    public static boolean isHandler() {
        return sHandler;
    }

    public static void setHandler(boolean handler) {
        sHandler = handler;
    }

    public static RecordInsert getRecordInsert() {
        return sRecordInsert;
    }

    public static void setRecordInsert(RecordInsert recordInsert) {
        sRecordInsert = recordInsert;
    }

    public static void setCallback(Callback callback) {
        sCallback = callback;
    }

    public static String getLogContent(RecordConfig config, Object ... logs) {
        if (config != null) {
            return FileRecordUtils.getLogContent(config, config.getRecordInsert(sRecordInsert), logs);
        }
        return FileRecordUtils.getLogContent(null, sRecordInsert, logs);
    }

    public static String getLogContent(RecordInsert recordInsert, Object ... logs) {
        return FileRecordUtils.getLogContent(null, recordInsert, logs);
    }

    public static String getLogContent(RecordConfig config, RecordInsert recordInsert, Object ... logs) {
        String logContent = FileRecordUtils.concatLog(config, logs);
        if (StringUtils.isEmpty((CharSequence)logContent)) {
            return null;
        }
        return FileRecordUtils.concatInsertLog(recordInsert, logContent);
    }

    public static String record(RecordConfig config, Object ... logs) {
        return FileRecordUtils.finalRecord(config, logs);
    }

    public static interface Callback {
        public void callback(boolean var1, RecordConfig var2, String var3, String var4, String var5, Object ... var6);
    }
}

