/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.comparator.sort;

import dev.utils.common.ConvertUtils;
import dev.utils.common.StringUtils;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsExplorerStringSimpleComparator
implements Comparator<String> {
    private final Pattern splitPattern = Pattern.compile("^(.*?)(\\d*)(?:\\.([^.]*))?$");

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null || o2 == null) {
            return -1;
        }
        return this.innerCompare(o1, o2);
    }

    private int innerCompare(String str1, String str2) {
        SplitFileName data1 = this.getSplitFileName(str1);
        SplitFileName data2 = this.getSplitFileName(str2);
        int result = data1.name.compareToIgnoreCase(data2.name);
        if (result == 0) {
            result = data1.number.compareTo(data2.number);
        }
        if (result == 0) {
            result = -Integer.compare(data1.numberText.length(), data2.numberText.length());
        }
        if (result == 0) {
            result = data1.ext.compareTo(data2.ext);
        }
        return result;
    }

    private SplitFileName getSplitFileName(String fileName) {
        Matcher matcher = this.splitPattern.matcher(fileName);
        if (matcher.matches()) {
            return new SplitFileName(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        return new SplitFileName(fileName, "", "");
    }

    private static class SplitFileName {
        String name;
        Long number;
        String numberText;
        String ext;

        public SplitFileName(String name, String numberText, String ext) {
            this.name = StringUtils.checkValue(name);
            this.number = ConvertUtils.toLong(numberText, -1L);
            this.numberText = StringUtils.checkValue(numberText);
            this.ext = StringUtils.checkValue(ext);
        }
    }
}

