/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.file;

import dev.utils.common.file.FilePartUtils;

public class FilePartItem {
    public final int partIndex;
    public final int partCount;
    public final long partByteLength;
    public final long fileByteLength;
    public final long start;
    public final long end;

    public FilePartItem(int partIndex, int partCount, long partByteLength, long fileByteLength, long start, long end) {
        this.partIndex = partIndex;
        this.partCount = partCount;
        this.partByteLength = partByteLength;
        this.fileByteLength = fileByteLength;
        this.start = start;
        this.end = end;
    }

    public boolean isFirstItem() {
        return this.partIndex == 0;
    }

    public boolean isLastItem() {
        return this.partIndex + 1 == this.partCount;
    }

    public boolean existsPart() {
        return this.partCount != 0;
    }

    public boolean isOnlyOne() {
        return this.partCount == 1;
    }

    public String getPartName(String fileName) {
        return FilePartUtils.getPartName(fileName, this.partIndex);
    }
}

