/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.JCLogUtils;
import dev.utils.common.ObjectUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final String TAG = StringUtils.class.getSimpleName();

    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(CharSequence ... args) {
        if (args != null && args.length != 0) {
            for (CharSequence value : args) {
                if (!StringUtils.isEmpty(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isEmptyClear(String str) {
        return StringUtils.isEmpty((CharSequence)StringUtils.clearSpaceTabLineTrim(str));
    }

    public static boolean isEmptyClear(String ... args) {
        if (args != null && args.length != 0) {
            for (String value : args) {
                if (!StringUtils.isEmptyClear(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return str != null && str.length() != 0;
    }

    public static boolean isNotEmptyClear(String str) {
        return StringUtils.isNotEmpty(StringUtils.clearSpaceTabLineTrim(str));
    }

    public static boolean isNull(String str) {
        return StringUtils.isEmpty((CharSequence)str) || "null".equalsIgnoreCase(str);
    }

    public static boolean isNull(String ... args) {
        if (args != null && args.length != 0) {
            for (String value : args) {
                if (!StringUtils.isNull(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNullClear(String str) {
        return StringUtils.isNull(StringUtils.clearSpaceTabLineTrim(str));
    }

    public static boolean isNullClear(String ... args) {
        if (args != null && args.length != 0) {
            for (String value : args) {
                if (!StringUtils.isNullClear(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNotNull(String str) {
        return !StringUtils.isNull(str);
    }

    public static boolean isNotNullClear(String str) {
        return StringUtils.isNotNull(StringUtils.clearSpaceTabLineTrim(str));
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static int length(String str, int defaultLength) {
        return str != null ? str.length() : defaultLength;
    }

    public static boolean isLength(String str, int length) {
        return str != null && str.length() == length;
    }

    public static <T> boolean equals(T value1, T value2) {
        return ObjectUtils.equals(value1, value2);
    }

    public static boolean isEquals(String ... args) {
        return StringUtils.isEquals(false, args);
    }

    public static boolean isEquals(boolean isIgnore, String ... args) {
        if (args != null) {
            String last = null;
            int len = args.length;
            if (len <= 1) {
                return false;
            }
            for (String value : args) {
                if (value == null) {
                    return false;
                }
                if (last != null && (isIgnore ? !value.equalsIgnoreCase(last) : !value.equals(last))) {
                    return false;
                }
                last = value;
            }
            return true;
        }
        return false;
    }

    public static boolean isOrEquals(String str, String ... args) {
        return StringUtils.isOrEquals(false, str, args);
    }

    public static boolean isOrEquals(boolean isIgnore, String str, String ... args) {
        if (str != null && args != null && args.length != 0) {
            for (String value : args) {
                if (!(isIgnore ? value.equalsIgnoreCase(str) : value.equals(str))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContains(String str, String ... args) {
        return StringUtils.isContains(false, str, args);
    }

    public static boolean isContains(boolean isIgnore, String str, String ... args) {
        if (str != null && args != null && args.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            int strLength = tempString.length();
            for (String value : args) {
                String valIgnore;
                if (!(!StringUtils.isEmpty((CharSequence)value) && strLength != 0 ? (isIgnore ? (valIgnore = value.toLowerCase()).contains(tempString) : value.contains(tempString)) : tempString.equals(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStartsWith(String str, String ... args) {
        return StringUtils.isStartsWith(false, str, args);
    }

    public static boolean isStartsWith(boolean isIgnore, String str, String ... args) {
        if (!StringUtils.isEmpty((CharSequence)str) && args != null && args.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            for (String value : args) {
                String valIgnore;
                if (StringUtils.isEmpty((CharSequence)value) || !(isIgnore ? tempString.startsWith(valIgnore = value.toLowerCase()) : tempString.startsWith(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEndsWith(String str, String ... args) {
        return StringUtils.isEndsWith(false, str, args);
    }

    public static boolean isEndsWith(boolean isIgnore, String str, String ... args) {
        if (!StringUtils.isEmpty((CharSequence)str) && args != null && args.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            for (String value : args) {
                String valIgnore;
                if (StringUtils.isEmpty((CharSequence)value) || !(isIgnore ? tempString.endsWith(valIgnore = value.toLowerCase()) : tempString.endsWith(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static int countMatches(String str, String keyword) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)keyword)) {
            return 0;
        }
        try {
            int count = 0;
            Matcher matcher = Pattern.compile(keyword).matcher(str);
            while (matcher.find()) {
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "countMatches", new Object[0]);
            return -1;
        }
    }

    public static int countMatches2(String str, String keyword) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)keyword)) {
            return 0;
        }
        try {
            int keyLength = keyword.length();
            int count = 0;
            int index = 0;
            while ((index = str.indexOf(keyword, index)) != -1) {
                index += keyLength;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "countMatches2", new Object[0]);
            return -1;
        }
    }

    public static boolean isSpace(CharSequence str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String str) {
        return str != null ? str.getBytes() : null;
    }

    public static String clearSpace(String str) {
        return StringUtils.replaceAll(str, " ", "");
    }

    public static String clearTab(String str) {
        return StringUtils.replaceAll(str, "\t", "");
    }

    public static String clearLine(String str) {
        return StringUtils.replaceAll(str, DevFinal.SYMBOL.NEW_LINE, "");
    }

    public static String clearLine2(String str) {
        return StringUtils.replaceAll(str, "\n", "");
    }

    public static String clearSpaceTrim(String str) {
        return StringUtils.clearSEWiths(str, " ");
    }

    public static String clearTabTrim(String str) {
        return StringUtils.clearSEWiths(str, "\t");
    }

    public static String clearLineTrim(String str) {
        return StringUtils.clearSEWiths(str, DevFinal.SYMBOL.NEW_LINE);
    }

    public static String clearLineTrim2(String str) {
        return StringUtils.clearSEWiths(str, "\n");
    }

    public static String clearSpaceTabLine(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String value = StringUtils.clearSpace(str);
        value = StringUtils.clearTab(value);
        value = StringUtils.clearLine(value);
        value = StringUtils.clearLine2(value);
        return value;
    }

    public static String clearSpaceTabLineTrim(String str) {
        boolean line2;
        boolean line;
        boolean tab;
        boolean space;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String value = str;
        do {
            boolean bl = space = value.startsWith(" ") || value.endsWith(" ");
            if (space) {
                value = StringUtils.clearSpaceTrim(value);
            }
            boolean bl2 = tab = value.startsWith("\t") || value.endsWith("\t");
            if (tab) {
                value = StringUtils.clearTabTrim(value);
            }
            boolean bl3 = line = value.startsWith(DevFinal.SYMBOL.NEW_LINE) || value.endsWith(DevFinal.SYMBOL.NEW_LINE);
            if (line) {
                value = StringUtils.clearLineTrim(value);
            }
            boolean bl4 = line2 = value.startsWith("\n") || value.endsWith("\n");
            if (!line2) continue;
            value = StringUtils.clearLineTrim2(value);
        } while (space || tab || line || line2);
        return value;
    }

    public static String appendSpace(int number) {
        return StringUtils.forString(number, " ");
    }

    public static String appendTab(int number) {
        return StringUtils.forString(number, "\t");
    }

    public static String appendLine(int number) {
        return StringUtils.forString(number, DevFinal.SYMBOL.NEW_LINE);
    }

    public static String appendLine2(int number) {
        return StringUtils.forString(number, "\n");
    }

    public static String forString(int number, String str) {
        StringBuilder builder = new StringBuilder();
        if (number > 0) {
            for (int i = 0; i < number; ++i) {
                builder.append(str);
            }
        }
        return builder.toString();
    }

    public static String joinArgs(Object delimiter, Object ... values) {
        int length;
        if (values != null && (length = values.length) != 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(values[0]);
            for (int i = 1; i < length; ++i) {
                builder.append(delimiter);
                builder.append(values[i]);
            }
            return builder.toString();
        }
        return null;
    }

    public static String join(Object delimiter, Object[] values) {
        int length;
        if (values != null && (length = values.length) != 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(values[0]);
            for (int i = 1; i < length; ++i) {
                builder.append(delimiter);
                builder.append(values[i]);
            }
            return builder.toString();
        }
        return null;
    }

    public static String join(Object delimiter, Iterable iterable) {
        if (iterable != null) {
            Iterator it = iterable.iterator();
            if (!it.hasNext()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(it.next());
            while (it.hasNext()) {
                builder.append(delimiter);
                builder.append(it.next());
            }
            return builder.toString();
        }
        return null;
    }

    public static String colonSplit(String str) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            return str.replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
        }
        return str;
    }

    public static String getString(String str) {
        return StringUtils.getString(str, "null");
    }

    public static String getString(String str, String defaultStr) {
        return str != null ? str : defaultStr;
    }

    public static String getString(Object object) {
        return StringUtils.getString(object, "null");
    }

    public static String getString(Object object, String defaultStr) {
        return object != null ? object.toString() : defaultStr;
    }

    public static String checkValue(String str) {
        return StringUtils.checkValue("", str);
    }

    public static String checkValue(String defaultStr, String str) {
        return StringUtils.isEmpty((CharSequence)str) ? defaultStr : str;
    }

    public static String checkValue(String defaultStr, String value1, String value2) {
        if (StringUtils.isEmpty((CharSequence)value1)) {
            if (StringUtils.isEmpty((CharSequence)value2)) {
                return defaultStr;
            }
            return value2;
        }
        return value1;
    }

    public static String checkValues(String defaultStr, String ... args) {
        if (args != null && args.length != 0) {
            for (String value : args) {
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                return value;
            }
        }
        return defaultStr;
    }

    public static String checkValuesSpace(String defaultStr, String ... args) {
        if (args != null && args.length != 0) {
            for (String value : args) {
                String result = StringUtils.clearSpaceTrim(value);
                if (StringUtils.isEmpty((CharSequence)result)) continue;
                return result;
            }
        }
        return defaultStr;
    }

    public static String getFormatString(String format, Object ... args) {
        if (format == null) {
            return null;
        }
        try {
            if (args != null && args.length != 0) {
                return String.format(format, args);
            }
            return format;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getFormatString", new Object[0]);
            return null;
        }
    }

    public static String getAutoFormatString(Object ... args) {
        if (args != null && args.length != 0) {
            try {
                int length = args.length;
                StringBuilder builder = new StringBuilder();
                builder.append("%s");
                if (length > 1) {
                    for (int i = 1; i < length; ++i) {
                        builder.append(" %s");
                    }
                }
                return String.format(builder.toString(), args);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getAutoFormatString", new Object[0]);
            }
        }
        return null;
    }

    public static String getAutoFormatString2(Object ... args) {
        if (args != null && args.length != 0) {
            try {
                int length = args.length;
                StringBuilder builder = new StringBuilder();
                builder.append("[%s]");
                if (length > 1) {
                    for (int i = 1; i < length; ++i) {
                        builder.append(" %s");
                    }
                }
                return String.format(builder.toString(), args);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getAutoFormatString2", new Object[0]);
            }
        }
        return null;
    }

    public static String concat(Object ... args) {
        return StringUtils.concatSpiltWith("", args);
    }

    public static String concatSpiltWith(String split, Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)split)) {
            for (Object value : args) {
                builder.append(value);
            }
        } else {
            for (Object value : args) {
                builder.append(value).append(split);
            }
        }
        return builder.toString();
    }

    public static String concatSpiltWithIgnoreLast(String split, Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = args.length;
        if (len > 0) {
            if (StringUtils.isEmpty((CharSequence)split)) {
                for (Object value : args) {
                    builder.append(value);
                }
            } else {
                for (int i = 0; i < len - 1; ++i) {
                    builder.append(args[i]).append(split);
                }
                builder.append(args[len - 1]);
            }
        }
        return builder.toString();
    }

    public static StringBuilder appends(StringBuilder builder, String split, Object ... args) {
        block4: {
            if (builder == null || args == null) break block4;
            if (StringUtils.isEmpty((CharSequence)split)) {
                for (Object value : args) {
                    builder.append(value);
                }
            } else {
                for (Object value : args) {
                    builder.append(value).append(split);
                }
            }
        }
        return builder;
    }

    public static StringBuilder appendsIgnoreLast(StringBuilder builder, String split, Object ... args) {
        int len;
        if (builder != null && args != null && (len = args.length) > 0) {
            if (StringUtils.isEmpty((CharSequence)split)) {
                for (Object value : args) {
                    builder.append(value);
                }
            } else {
                for (int i = 0; i < len - 1; ++i) {
                    builder.append(args[i]).append(split);
                }
                builder.append(args[len - 1]);
            }
        }
        return builder;
    }

    public static String gbkEncode(String str) {
        return StringUtils.strEncode(str, "GBK");
    }

    public static String gbk2312Encode(String str) {
        return StringUtils.strEncode(str, "GBK-2312");
    }

    public static String utf8Encode(String str) {
        return StringUtils.strEncode(str, "UTF-8");
    }

    public static String strEncode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return new String(str.getBytes(), enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "strEncode", new Object[0]);
            return str;
        }
    }

    public static String urlEncode(String str) {
        return StringUtils.urlEncode(str, "UTF-8");
    }

    public static String urlEncode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "urlEncode", new Object[0]);
            return null;
        }
    }

    public static String urlDecode(String str) {
        return StringUtils.urlDecode(str, "UTF-8");
    }

    public static String urlDecode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return URLDecoder.decode(str, enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "urlDecode", new Object[0]);
            return null;
        }
    }

    public static String urlDecodeWhile(String str, int threshold) {
        return StringUtils.urlDecodeWhile(str, "UTF-8", threshold);
    }

    public static String urlDecodeWhile(String str, String enc, int threshold) {
        if (str == null || enc == null) {
            return null;
        }
        int count = Math.max(threshold, 1);
        int number = 0;
        String result = str;
        String decodeValue = StringUtils.urlDecode(str, enc);
        do {
            if (result.equals(decodeValue)) {
                return decodeValue;
            }
            if (decodeValue == null) {
                return result;
            }
            result = decodeValue;
            decodeValue = StringUtils.urlDecode(result, enc);
        } while (++number <= count);
        if (decodeValue != null) {
            return decodeValue;
        }
        return result;
    }

    public static String ascii(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        try {
            byte[] bytes;
            StringBuilder builder = new StringBuilder();
            for (byte value : bytes = str.getBytes()) {
                builder.append(Integer.toHexString(value & 0xFF));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "ascii", new Object[0]);
            return null;
        }
    }

    public static String unicode(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        try {
            char[] chars;
            StringBuilder builder = new StringBuilder();
            for (char value : chars = str.toCharArray()) {
                builder.append("\\u").append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "unicode", new Object[0]);
            return null;
        }
    }

    public static String unicodeString(char[] chars) {
        if (chars == null) {
            return null;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (char value : chars) {
                builder.append("\\u").append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "unicodeString", new Object[0]);
            return null;
        }
    }

    public static String dbc(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == '\u3000' ? 32 : ('\uff01' <= chars[i] && chars[i] <= '\uff5e' ? (char)(chars[i] - 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String sbc(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == ' ' ? 12288 : ('!' <= chars[i] && chars[i] <= '~' ? (char)(chars[i] + 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static boolean checkChineseToString(String str) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        boolean result = true;
        for (char value : chars = str.toCharArray()) {
            if (StringUtils.isChinese(value)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isChinese(char ch) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String upperFirstLetter(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || !Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        try {
            return (char)(str.charAt(0) - 32) + str.substring(1);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "upperFirstLetter", new Object[0]);
            return str;
        }
    }

    public static String lowerFirstLetter(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || !Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        try {
            return (char)(str.charAt(0) + 32) + str.substring(1);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "lowerFirstLetter", new Object[0]);
            return str;
        }
    }

    public static String reverse(String str) {
        int len = StringUtils.length(str);
        if (len <= 1) {
            return str;
        }
        int mid = len >> 1;
        char[] chars = str.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char ch = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = ch;
        }
        return new String(chars);
    }

    public static String underScoreCaseToCamelCase(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (!str.contains("_")) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean hitUnderScore = false;
        builder.append(chars[0]);
        int len = chars.length;
        for (int i = 1; i < len; ++i) {
            char c = chars[i];
            if (c == '_') {
                hitUnderScore = true;
                continue;
            }
            if (hitUnderScore) {
                builder.append(Character.toUpperCase(c));
                hitUnderScore = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String camelCaseToUnderScoreCase(String str) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (char value : chars = str.toCharArray()) {
            if (Character.isUpperCase(value)) {
                builder.append("_").append(Character.toLowerCase(value));
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static String sqliteEscape(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String keyWord = str;
        keyWord = keyWord.replace("/", "//");
        keyWord = keyWord.replace("'", "''");
        keyWord = keyWord.replace("[", "/[");
        keyWord = keyWord.replace("]", "/]");
        keyWord = keyWord.replace("%", "/%");
        keyWord = keyWord.replace("&", "/&");
        keyWord = keyWord.replace("_", "/_");
        keyWord = keyWord.replace("(", "/(");
        keyWord = keyWord.replace(")", "/)");
        return keyWord;
    }

    public static String convertHideMobile(String phone) {
        return StringUtils.convertHideMobile(phone, "*");
    }

    public static String convertHideMobile(String phone, String symbol) {
        return StringUtils.convertSymbolHide(3, phone, symbol);
    }

    public static String convertSymbolHide(int start, String str, String symbol) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            if (start <= 0) {
                return str;
            }
            int length = str.length();
            if (length <= start) {
                return str;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(str.substring(0, start));
            int len = length - start;
            len /= 2;
            for (int i = 0; i < len; ++i) {
                builder.append(symbol);
            }
            builder.append(str.substring(start + len, length));
            return builder.toString();
        }
        return "";
    }

    public static String subEllipsize(int maxLength, String str, String symbol) {
        int strLength;
        if (maxLength >= 1 && (strLength = StringUtils.length(str)) != 0) {
            if (maxLength >= strLength) {
                return str;
            }
            return str.substring(0, maxLength) + StringUtils.checkValue(symbol);
        }
        return "";
    }

    public static String subSymbolHide(int start, int symbolNumber, String str, String symbol) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            if (start <= 0 || symbolNumber <= 0) {
                return str;
            }
            int length = str.length();
            if (length <= start) {
                return str;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(str.substring(0, start));
            int len = length - start - symbolNumber;
            len = len <= 0 ? length - start : symbolNumber;
            for (int i = 0; i < len; ++i) {
                builder.append(symbol);
            }
            builder.append(str.substring(start + len, length));
            return builder.toString();
        }
        return "";
    }

    public static String subSetSymbol(String str, int frontRetainLength, int rearRetainLength, String symbol) {
        if (str != null) {
            try {
                String startStr = str.substring(0, frontRetainLength);
                String endStr = str.substring(str.length() - rearRetainLength);
                int symbolLength = str.length() - (frontRetainLength + rearRetainLength);
                if (symbolLength >= 1) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < symbolLength; ++i) {
                        builder.append(symbol);
                    }
                    return startStr + builder.toString() + endStr;
                }
                return startStr + endStr;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "subSetSymbol", new Object[0]);
            }
        }
        return null;
    }

    public static String substring(String str, int endIndex) {
        return StringUtils.substring(str, 0, endIndex, true);
    }

    public static String substring(String str, int endIndex, boolean isReturn) {
        return StringUtils.substring(str, 0, endIndex, isReturn);
    }

    public static String substring(String str, int beginIndex, int endIndex, boolean isReturn) {
        if (!StringUtils.isEmpty((CharSequence)str) && beginIndex >= 0 && endIndex >= 0 && endIndex >= beginIndex) {
            int len = StringUtils.length(str);
            if (beginIndex > len) {
                return isReturn ? str : "";
            }
            return str.substring(beginIndex, Math.min(endIndex, len));
        }
        return isReturn ? str : "";
    }

    public static String replaceSEWith(String str, String suffix) {
        return StringUtils.replaceSEWith(str, suffix, "");
    }

    public static String replaceSEWith(String str, String suffix, String replace) {
        try {
            if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix) || replace == null || suffix.equals(replace)) {
                return str;
            }
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            if (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
                builder.insert(0, replace);
            }
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            if (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                builder.insert(lastIndexOf, replace);
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "replaceSEWith", new Object[0]);
            return str;
        }
    }

    public static String replaceStartsWith(String str, String prefix) {
        return StringUtils.replaceStartsWith(str, prefix, "");
    }

    public static String replaceStartsWith(String str, String prefix, String startAppend) {
        if (!StringUtils.isEmpty((CharSequence)str) && !StringUtils.isEmpty((CharSequence)prefix)) {
            try {
                if (str.startsWith(prefix)) {
                    return StringUtils.checkValue(startAppend) + str.substring(prefix.length());
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceStartsWith", new Object[0]);
            }
        }
        return str;
    }

    public static String replaceEndsWith(String str, String suffix) {
        return StringUtils.replaceEndsWith(str, suffix, "");
    }

    public static String replaceEndsWith(String str, String suffix, String replace) {
        if (!StringUtils.isEmpty((CharSequence)str) && !StringUtils.isEmpty((CharSequence)suffix)) {
            try {
                if (str.endsWith(suffix)) {
                    return str.substring(0, str.length() - suffix.length()) + replace;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceEndsWith", new Object[0]);
            }
        }
        return str;
    }

    public static String clearSEWiths(String str, String suffix) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            while (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
            }
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            while (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                lastIndexOf = builder.lastIndexOf(suffix);
                bufLength = builder.length();
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearSEWiths", new Object[0]);
            return str;
        }
    }

    public static String clearStartsWith(String str, String suffix) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            while (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearStartsWith", new Object[0]);
            return str;
        }
    }

    public static String clearEndsWith(String str, String suffix) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            while (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                lastIndexOf = builder.lastIndexOf(suffix);
                bufLength = builder.length();
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearEndsWith", new Object[0]);
            return str;
        }
    }

    public static String replaceAll(String str, String suffix, String replace) {
        if (!(StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix) || replace == null || suffix.equals(replace))) {
            try {
                return str.replaceAll(suffix, replace);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceAll", new Object[0]);
            }
        }
        return str;
    }

    public static String replaceAllToNull(String str, String suffix, String replace) {
        if (!(StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix) || replace == null || suffix.equals(replace))) {
            try {
                return str.replaceAll(suffix, replace);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceAllToNull", new Object[0]);
            }
        }
        return null;
    }

    public static String replaceAlls(String str, String[] suffixArrays, String[] replaceArrays) {
        if (str != null && suffixArrays != null && replaceArrays != null) {
            String tempString = str;
            int spCount = suffixArrays.length;
            int reCount = replaceArrays.length;
            if (spCount == reCount) {
                for (int i = 0; i < spCount; ++i) {
                    tempString = StringUtils.replaceAll(tempString, suffixArrays[i], replaceArrays[i]);
                }
                return tempString;
            }
        }
        return null;
    }

    public static String[] split(String str, String regex) {
        if (!StringUtils.isEmpty((CharSequence)str) && !StringUtils.isEmpty((CharSequence)regex)) {
            return str.split(regex);
        }
        return null;
    }

    public static String split(String str, String regex, int index) {
        return StringUtils.split(str, regex, index, null);
    }

    public static String split(String str, String regex, int index, String defaultStr) {
        String[] arrays;
        if (index >= 0 && (arrays = StringUtils.split(str, regex)) != null && arrays.length > index) {
            return arrays[index];
        }
        return defaultStr;
    }
}

