/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public final class SHAUtils {
    private static final String TAG = SHAUtils.class.getSimpleName();

    private SHAUtils() {
    }

    public static String sha1(String data) {
        return SHAUtils.shaHex(data, "SHA-1");
    }

    public static String sha224(String data) {
        return SHAUtils.shaHex(data, "SHA-224");
    }

    public static String sha256(String data) {
        return SHAUtils.shaHex(data, "SHA-256");
    }

    public static String sha384(String data) {
        return SHAUtils.shaHex(data, "SHA-384");
    }

    public static String sha512(String data) {
        return SHAUtils.shaHex(data, "SHA-512");
    }

    public static String getFileSHA1(String filePath) {
        File file = StringUtils.isEmpty((CharSequence)filePath) ? null : new File(filePath);
        return SHAUtils.getFileSHA(file, "SHA-1");
    }

    public static String getFileSHA1(File file) {
        return SHAUtils.getFileSHA(file, "SHA-1");
    }

    public static String getFileSHA256(String filePath) {
        File file = StringUtils.isEmpty((CharSequence)filePath) ? null : new File(filePath);
        return SHAUtils.getFileSHA(file, "SHA-256");
    }

    public static String getFileSHA256(File file) {
        return SHAUtils.getFileSHA(file, "SHA-256");
    }

    public static String shaHex(String data, String algorithm) {
        if (data == null || algorithm == null) {
            return null;
        }
        try {
            byte[] bytes = data.getBytes();
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(bytes);
            return ConvertUtils.toHexString(digest.digest(), true);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "shaHex", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileSHA(File file, String algorithm) {
        String string;
        if (file == null || algorithm == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            int numRead;
            is = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            while ((numRead = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, numRead);
            }
            string = ConvertUtils.toHexString(digest.digest(), true);
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "getFileSHA", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(is);
            return null;
        }
        CloseUtils.closeIOQuietly(is);
        return string;
    }
}

