/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ObjectUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class CollectionUtils {
    private static final String TAG = CollectionUtils.class.getSimpleName();

    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static int length(Collection<?> collection) {
        return CollectionUtils.length(collection, 0);
    }

    public static int length(Collection<?> collection, int defaultLength) {
        return collection != null ? collection.size() : defaultLength;
    }

    public static boolean isLength(Collection<?> collection, int length) {
        return collection != null && collection.size() == length;
    }

    public static boolean greaterThan(Collection<?> collection, int length) {
        return collection != null && collection.size() > length;
    }

    public static boolean greaterThanOrEqual(Collection<?> collection, int length) {
        return collection != null && collection.size() >= length;
    }

    public static boolean lessThan(Collection<?> collection, int length) {
        return collection != null && collection.size() < length;
    }

    public static boolean lessThanOrEqual(Collection<?> collection, int length) {
        return collection != null && collection.size() <= length;
    }

    public static int getCount(Collection<?> ... collections) {
        if (collections == null) {
            return 0;
        }
        int count = 0;
        for (Collection<?> collection : collections) {
            count += CollectionUtils.length(collection);
        }
        return count;
    }

    public static <T> T get(Collection<T> collection, int pos) {
        if (collection != null) {
            if (pos < 0) {
                return null;
            }
            if (collection instanceof List) {
                try {
                    return (T)((List)collection).get(pos);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "get %s", pos);
                }
            } else {
                try {
                    return (T)collection.toArray()[pos];
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "get %s", pos);
                }
            }
        }
        return null;
    }

    public static <T> T getFirst(Collection<T> collection) {
        return CollectionUtils.get(collection, 0);
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollectionUtils.get(collection, CollectionUtils.length(collection) - 1);
    }

    public static <T> T get(Collection<T> collection, T value, int number, boolean notNull, int offset) {
        if (collection != null) {
            if (notNull && value == null) {
                return null;
            }
            try {
                int temp = number;
                Object[] arrays = collection.toArray();
                int len = arrays.length;
                for (int i = 0; i < len; ++i) {
                    Object t = arrays[i];
                    if (!CollectionUtils.equals(t, value)) continue;
                    if (temp - 1 < 0) {
                        return (T)arrays[i + offset];
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return null;
    }

    public static <T> int getPosition(Collection<T> collection, T value, int number, boolean notNull, int offset) {
        if (collection != null) {
            if (notNull && value == null) {
                return -1;
            }
            try {
                int temp = number;
                Object[] arrays = collection.toArray();
                int len = arrays.length;
                for (int i = 0; i < len; ++i) {
                    Object t = arrays[i];
                    if (!CollectionUtils.equals(t, value)) continue;
                    if (temp - 1 < 0) {
                        return i + offset;
                    }
                    --temp;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPosition", new Object[0]);
            }
        }
        return -1;
    }

    public static <T> int getPosition(Collection<T> collection, T value) {
        return CollectionUtils.getPosition(collection, value, 0, false, 0);
    }

    public static <T> int getPosition(Collection<T> collection, T value, int number) {
        return CollectionUtils.getPosition(collection, value, number, false, 0);
    }

    public static <T> int getPosition(Collection<T> collection, T value, boolean notNull) {
        return CollectionUtils.getPosition(collection, value, 0, notNull, 0);
    }

    public static <T> int getPosition(Collection<T> collection, T value, int number, boolean notNull) {
        return CollectionUtils.getPosition(collection, value, number, notNull, 0);
    }

    public static <T> int getPositionNotNull(Collection<T> collection, T value) {
        return CollectionUtils.getPosition(collection, value, 0, true, 0);
    }

    public static <T> int getPositionNotNull(Collection<T> collection, T value, int number) {
        return CollectionUtils.getPosition(collection, value, number, true, 0);
    }

    public static <T> T getNext(Collection<T> collection, T value) {
        return CollectionUtils.get(collection, value, 0, false, 1);
    }

    public static <T> T getNext(Collection<T> collection, T value, int number) {
        return CollectionUtils.get(collection, value, number, false, 1);
    }

    public static <T> T getNext(Collection<T> collection, T value, boolean notNull) {
        return CollectionUtils.get(collection, value, 0, notNull, 1);
    }

    public static <T> T getNext(Collection<T> collection, T value, int number, boolean notNull) {
        return CollectionUtils.get(collection, value, number, notNull, 1);
    }

    public static <T> T getNextNotNull(Collection<T> collection, T value) {
        return CollectionUtils.get(collection, value, 0, true, 1);
    }

    public static <T> T getNextNotNull(Collection<T> collection, T value, int number) {
        return CollectionUtils.get(collection, value, number, true, 1);
    }

    public static <T> T getPrevious(Collection<T> collection, T value) {
        return CollectionUtils.get(collection, value, 0, false, -1);
    }

    public static <T> T getPrevious(Collection<T> collection, T value, int number) {
        return CollectionUtils.get(collection, value, number, false, -1);
    }

    public static <T> T getPrevious(Collection<T> collection, T value, boolean notNull) {
        return CollectionUtils.get(collection, value, 0, notNull, -1);
    }

    public static <T> T getPrevious(Collection<T> collection, T value, int number, boolean notNull) {
        return CollectionUtils.get(collection, value, number, notNull, -1);
    }

    public static <T> T getPreviousNotNull(Collection<T> collection, T value) {
        return CollectionUtils.get(collection, value, 0, true, -1);
    }

    public static <T> T getPreviousNotNull(Collection<T> collection, T value, int number) {
        return CollectionUtils.get(collection, value, number, true, -1);
    }

    public static <T> boolean add(Collection<T> collection, T value) {
        return CollectionUtils.add(collection, value, false);
    }

    public static <T> boolean addNotNull(Collection<T> collection, T value) {
        return CollectionUtils.add(collection, value, true);
    }

    public static <T> boolean add(Collection<T> collection, T value, boolean notNull) {
        if (collection != null) {
            if (notNull) {
                if (value != null) {
                    try {
                        return collection.add(value);
                    }
                    catch (Exception e) {
                        JCLogUtils.eTag(TAG, e, "add notNull", new Object[0]);
                    }
                }
            } else {
                try {
                    return collection.add(value);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "add", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <T> boolean addAll(Collection<T> collection, Collection<T> values) {
        return CollectionUtils.addAll(collection, values, false);
    }

    public static <T> boolean addAllNotNull(Collection<T> collection, Collection<T> values) {
        return CollectionUtils.addAll(collection, values, true);
    }

    public static <T> boolean addAll(Collection<T> collection, Collection<T> values, boolean notNull) {
        if (collection != null && values != null) {
            if (notNull) {
                try {
                    for (T value : values) {
                        if (value == null) continue;
                        collection.add(value);
                    }
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "addAll notNull", new Object[0]);
                }
            } else {
                try {
                    return collection.addAll(values);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "addAll", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <T> boolean clearAndAddAll(Collection<T> collection, Collection<T> values) {
        return CollectionUtils.clearAndAddAll(collection, values, false);
    }

    public static <T> boolean clearAndAddAllNotNull(Collection<T> collection, Collection<T> values) {
        return CollectionUtils.clearAndAddAll(collection, values, true);
    }

    public static <T> boolean clearAndAddAll(Collection<T> collection, Collection<T> values, boolean notNull) {
        CollectionUtils.clearAll(collection);
        return CollectionUtils.addAll(collection, values, notNull);
    }

    public static <T> boolean add(int index, List<T> list, T value) {
        return CollectionUtils.add(index, list, value, false);
    }

    public static <T> boolean addNotNull(int index, List<T> list, T value) {
        return CollectionUtils.add(index, list, value, true);
    }

    public static <T> boolean add(int index, List<T> list, T value, boolean notNull) {
        if (list != null) {
            if (notNull) {
                if (value != null) {
                    try {
                        list.add(index, value);
                        return true;
                    }
                    catch (Exception e) {
                        JCLogUtils.eTag(TAG, e, "add notNull", new Object[0]);
                    }
                }
            } else {
                try {
                    list.add(index, value);
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "add", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <T> boolean addAll(int index, List<T> list, List<T> values) {
        return CollectionUtils.addAll(index, list, values, false);
    }

    public static <T> boolean addAllNotNull(int index, List<T> list, List<T> values) {
        return CollectionUtils.addAll(index, list, values, true);
    }

    public static <T> boolean addAll(int index, List<T> list, List<T> values, boolean notNull) {
        if (list != null && values != null) {
            if (notNull) {
                try {
                    ArrayList<T> tempList = new ArrayList<T>();
                    for (T value : values) {
                        if (value == null) continue;
                        tempList.add(value);
                    }
                    list.addAll(index, tempList);
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "addAll notNull", new Object[0]);
                }
            } else {
                try {
                    list.addAll(index, values);
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "addAll", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <T> boolean remove(Collection<T> collection, T value) {
        if (collection != null) {
            try {
                return collection.remove(value);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "remove", new Object[0]);
            }
        }
        return false;
    }

    public static <T> T remove(List<T> list, int pos) {
        if (list != null) {
            if (pos < 0) {
                return null;
            }
            try {
                return list.remove(pos);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "remove", new Object[0]);
            }
        }
        return null;
    }

    public static <T> boolean removeAll(Collection<T> collection, Collection<T> values) {
        if (collection != null && values != null) {
            try {
                return collection.removeAll(values);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeAll", new Object[0]);
            }
        }
        return false;
    }

    public static <T> boolean clear(Collection<T> collection, T value) {
        if (collection != null) {
            try {
                Iterator<T> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    T t = iterator.next();
                    if (!CollectionUtils.equals(t, value)) continue;
                    iterator.remove();
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "clear", new Object[0]);
            }
        }
        return false;
    }

    public static <T> boolean clearNotBelong(Collection<T> collection, T value) {
        if (collection != null) {
            try {
                Iterator<T> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    T t = iterator.next();
                    if (CollectionUtils.equals(t, value)) continue;
                    iterator.remove();
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "clearNotBelong", new Object[0]);
            }
        }
        return false;
    }

    public static <T> boolean clearAll(Collection<T> collection) {
        if (collection != null) {
            try {
                collection.clear();
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "clearAll", new Object[0]);
            }
        }
        return false;
    }

    public static <T> boolean clearNull(Collection<T> collection) {
        return CollectionUtils.clear(collection, null);
    }

    public static <T> boolean isEqualCollection(Collection<T> collection1, Collection<T> collection2) {
        int len;
        if (collection1 != null && collection2 != null && (len = collection1.size()) == collection2.size()) {
            Object[] arrays2;
            Object[] arrays1;
            if (len == 0) {
                return true;
            }
            if (!collection1.getClass().getName().equals(collection2.getClass().getName())) {
                return false;
            }
            if (collection1.equals(collection2)) {
                return true;
            }
            try {
                arrays1 = collection1.toArray();
                arrays2 = collection2.toArray();
            }
            catch (Exception e) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                boolean equals = CollectionUtils.equals(arrays1[i], arrays2[i]);
                if (equals) continue;
                return false;
            }
            return true;
        }
        return collection1 == null && collection2 == null;
    }

    public static <T> boolean isEqualCollections(Collection<T> ... collections) {
        if (collections != null && collections.length >= 2) {
            int len = collections.length;
            Collection<T> temp = collections[0];
            for (int i = 1; i < len; ++i) {
                boolean equalCollection = CollectionUtils.isEqualCollection(temp, collections[i]);
                if (equalCollection) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> Collection<T> union(Collection<T> collection1, Collection<T> collection2) {
        if (collection1 != null && collection2 != null) {
            try {
                LinkedHashSet<T> sets = new LinkedHashSet<T>(collection1);
                sets.addAll(collection2);
                return sets;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "union", new Object[0]);
                return null;
            }
        }
        if (collection1 != null) {
            return collection1;
        }
        return collection2;
    }

    public static <T> Collection<T> unions(Collection<T> ... collections) {
        if (collections != null) {
            int len = collections.length;
            if (len >= 2) {
                try {
                    LinkedHashSet<T> sets = new LinkedHashSet<T>();
                    if (collections[0] != null) {
                        sets.addAll(collections[0]);
                    }
                    for (int i = 1; i < len; ++i) {
                        Collection<T> value = collections[i];
                        if (value == null) continue;
                        sets.addAll(value);
                    }
                    return sets;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "unions", new Object[0]);
                    return null;
                }
            }
            return collections[0];
        }
        return null;
    }

    public static <T> Collection<T> intersection(Collection<T> collection1, Collection<T> collection2) {
        if (collection1 != null && collection2 != null) {
            try {
                LinkedHashSet<T> sets = new LinkedHashSet<T>();
                LinkedHashSet<T> setsTemp = new LinkedHashSet<T>(collection1);
                for (T value : collection2) {
                    if (!setsTemp.contains(value)) continue;
                    sets.add(value);
                }
                return sets;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "intersection", new Object[0]);
                return null;
            }
        }
        if (collection1 != null) {
            return collection1;
        }
        return collection2;
    }

    public static <T> Collection<T> disjunction(Collection<T> collection1, Collection<T> collection2) {
        try {
            Collection<T> unionC = CollectionUtils.union(collection1, collection2);
            Collection<T> intersectionC = CollectionUtils.intersection(collection1, collection2);
            if (unionC != null && intersectionC != null) {
                try {
                    unionC.removeAll(intersectionC);
                    return unionC;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "disjunction", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "disjunction", new Object[0]);
        }
        return null;
    }

    public static <T> Collection<T> subtract(Collection<T> collection1, Collection<T> collection2) {
        try {
            Collection<T> intersectionC = CollectionUtils.intersection(collection1, collection2);
            if (intersectionC != null) {
                LinkedHashSet<T> sets = new LinkedHashSet<T>(collection1);
                sets.removeAll(intersectionC);
                return sets;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "subtract", new Object[0]);
        }
        return null;
    }

    public static <T> boolean equals(T value1, T value2) {
        return ObjectUtils.equals(value1, value2);
    }

    public static <T> Object[] toArray(Collection<T> collection) {
        if (collection != null) {
            try {
                return collection.toArray();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "toArray", new Object[0]);
            }
        }
        return null;
    }

    public static <T> T[] toArrayT(Collection<T> collection) {
        if (collection != null) {
            try {
                return new ArrayWithTypeToken<T>(collection).create();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "toArrayT", new Object[0]);
            }
        }
        return null;
    }

    public static <T> Collection<T> reverse(Collection<T> collection) {
        try {
            ArrayList<Object> lists = new ArrayList<Object>();
            Object[] arrays = collection.toArray();
            for (int i = arrays.length - 1; i >= 0; --i) {
                lists.add(arrays[i]);
            }
            return lists;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "reverse", new Object[0]);
            return null;
        }
    }

    public static int getMinimumIndexI(List<Integer> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Integer temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Integer value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (value >= temp) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndexL(List<Long> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Long temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Long value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (value >= temp) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndexF(List<Float> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Float temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Float value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (!(value.floatValue() < temp.floatValue())) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumIndexD(List<Double> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Double temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Double value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (!(value < temp)) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndexI(List<Integer> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Integer temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Integer value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (value <= temp) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndexL(List<Long> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Long temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Long value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (value <= temp) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndexF(List<Float> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Float temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Float value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (!(value.floatValue() > temp.floatValue())) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMaximumIndexD(List<Double> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            int index = 0;
            Double temp = list.get(index);
            for (int i = 1; i < len; ++i) {
                Double value = list.get(i);
                if (value == null) continue;
                if (temp == null) {
                    index = i;
                    temp = value;
                }
                if (!(value > temp)) continue;
                index = i;
                temp = value;
            }
            if (temp == null) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int getMinimumI(List<Integer> list) {
        try {
            return list.get(CollectionUtils.getMinimumIndexI(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimumI", new Object[0]);
            return 0;
        }
    }

    public static long getMinimumL(List<Long> list) {
        try {
            return list.get(CollectionUtils.getMinimumIndexL(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimumL", new Object[0]);
            return 0L;
        }
    }

    public static float getMinimumF(List<Float> list) {
        try {
            return list.get(CollectionUtils.getMinimumIndexF(list)).floatValue();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimumF", new Object[0]);
            return 0.0f;
        }
    }

    public static double getMinimumD(List<Double> list) {
        try {
            return list.get(CollectionUtils.getMinimumIndexD(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinimumD", new Object[0]);
            return 0.0;
        }
    }

    public static int getMaximumI(List<Integer> list) {
        try {
            return list.get(CollectionUtils.getMaximumIndexI(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximumI", new Object[0]);
            return 0;
        }
    }

    public static long getMaximumL(List<Long> list) {
        try {
            return list.get(CollectionUtils.getMaximumIndexL(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximumL", new Object[0]);
            return 0L;
        }
    }

    public static float getMaximumF(List<Float> list) {
        try {
            return list.get(CollectionUtils.getMaximumIndexF(list)).floatValue();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximumF", new Object[0]);
            return 0.0f;
        }
    }

    public static double getMaximumD(List<Double> list) {
        try {
            return list.get(CollectionUtils.getMaximumIndexD(list));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMaximumD", new Object[0]);
            return 0.0;
        }
    }

    public static int sumlistI(List<Integer> lists) {
        return CollectionUtils.sumlistI(lists, 0, CollectionUtils.length(lists), 0);
    }

    public static int sumlistI(List<Integer> lists, int end) {
        return CollectionUtils.sumlistI(lists, 0, end, 0);
    }

    public static int sumlistI(List<Integer> lists, int end, int extra) {
        return CollectionUtils.sumlistI(lists, 0, end, extra);
    }

    public static int sumlistI(List<Integer> lists, int start, int end, int extra) {
        int total = 0;
        if (lists != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += lists.get(i) + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumlistI", new Object[0]);
                }
            }
        }
        return total;
    }

    public static long sumlistL(List<Long> lists) {
        return CollectionUtils.sumlistL(lists, 0, CollectionUtils.length(lists), 0L);
    }

    public static long sumlistL(List<Long> lists, int end) {
        return CollectionUtils.sumlistL(lists, 0, end, 0L);
    }

    public static long sumlistL(List<Long> lists, int end, long extra) {
        return CollectionUtils.sumlistL(lists, 0, end, extra);
    }

    public static long sumlistL(List<Long> lists, int start, int end, long extra) {
        long total = 0L;
        if (lists != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += lists.get(i) + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumlistL", new Object[0]);
                }
            }
        }
        return total;
    }

    public static float sumlistF(List<Float> lists) {
        return CollectionUtils.sumlistF(lists, 0, CollectionUtils.length(lists), 0.0f);
    }

    public static float sumlistF(List<Float> lists, int end) {
        return CollectionUtils.sumlistF(lists, 0, end, 0.0f);
    }

    public static float sumlistF(List<Float> lists, int end, float extra) {
        return CollectionUtils.sumlistF(lists, 0, end, extra);
    }

    public static float sumlistF(List<Float> lists, int start, int end, float extra) {
        float total = 0.0f;
        if (lists != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += lists.get(i).floatValue() + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumlistF", new Object[0]);
                }
            }
        }
        return total;
    }

    public static double sumlistD(List<Double> lists) {
        return CollectionUtils.sumlistD(lists, 0, CollectionUtils.length(lists), 0.0);
    }

    public static double sumlistD(List<Double> lists, int end) {
        return CollectionUtils.sumlistD(lists, 0, end, 0.0);
    }

    public static double sumlistD(List<Double> lists, int end, double extra) {
        return CollectionUtils.sumlistD(lists, 0, end, extra);
    }

    public static double sumlistD(List<Double> lists, int start, int end, double extra) {
        double total = 0.0;
        if (lists != null) {
            for (int i = start; i < end; ++i) {
                try {
                    total += lists.get(i) + extra;
                    continue;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "sumlistD", new Object[0]);
                }
            }
        }
        return total;
    }

    public static class ArrayWithTypeToken<T> {
        private T[] array;

        public ArrayWithTypeToken(Collection<T> collection) {
            this.newInstance(collection);
        }

        public ArrayWithTypeToken(Class<T> type, int size) {
            this.newInstance(type, size);
        }

        public void put(int index, T item) {
            this.array[index] = item;
        }

        public T get(int index) {
            return this.array[index];
        }

        public T[] create() {
            return this.array;
        }

        private void newInstance(Class<T> type, int size) {
            this.array = (Object[])Array.newInstance(type, size);
        }

        private void newInstance(Collection<T> collection) {
            Object[] objects;
            Object value = null;
            for (Object object : objects = collection.toArray()) {
                if (object == null) continue;
                value = object;
                break;
            }
            this.newInstance(value.getClass(), objects.length);
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                Object object = objects[i];
                this.put(i, object != null ? object : null);
            }
        }
    }
}

