/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.util.Random;

public final class RandomUtils {
    private static final String TAG = RandomUtils.class.getSimpleName();
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] LOWER_CASE_LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] CAPITAL_LETTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] NUMBERS_AND_LETTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    private RandomUtils() {
    }

    public static boolean nextBoolean(Random random) {
        return random != null ? random.nextBoolean() : new Random().nextBoolean();
    }

    public static byte[] nextBytes(Random random, byte[] data) {
        if (random == null || data == null) {
            return data;
        }
        try {
            random.nextBytes(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static double nextDouble(Random random) {
        return random != null ? random.nextDouble() : new Random().nextDouble();
    }

    public static double nextGaussian(Random random) {
        return random != null ? random.nextGaussian() : new Random().nextGaussian();
    }

    public static float nextFloat(Random random) {
        return random != null ? random.nextFloat() : new Random().nextFloat();
    }

    public static int nextInt(Random random) {
        return random != null ? random.nextInt() : new Random().nextInt();
    }

    public static int nextInt(Random random, int number) {
        if (number <= 0) {
            return 0;
        }
        return random != null ? random.nextInt(number) : new Random().nextInt(number);
    }

    public static long nextLong(Random random) {
        return random != null ? random.nextLong() : new Random().nextLong();
    }

    public static boolean nextBoolean() {
        return new Random().nextBoolean();
    }

    public static byte[] nextBytes(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            new Random().nextBytes(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static double nextDouble() {
        return new Random().nextDouble();
    }

    public static double nextGaussian() {
        return new Random().nextGaussian();
    }

    public static float nextFloat() {
        return new Random().nextFloat();
    }

    public static int nextInt() {
        return new Random().nextInt();
    }

    public static int nextInt(int number) {
        if (number <= 0) {
            return 0;
        }
        return new Random().nextInt(number);
    }

    public static long nextLong() {
        return new Random().nextLong();
    }

    public static String getRandomNumbers(int length) {
        return RandomUtils.getRandom(NUMBERS, length);
    }

    public static String getRandomLowerCaseLetters(int length) {
        return RandomUtils.getRandom(LOWER_CASE_LETTERS, length);
    }

    public static String getRandomCapitalLetters(int length) {
        return RandomUtils.getRandom(CAPITAL_LETTERS, length);
    }

    public static String getRandomLetters(int length) {
        return RandomUtils.getRandom(LETTERS, length);
    }

    public static String getRandomNumbersAndLetters(int length) {
        return RandomUtils.getRandom(NUMBERS_AND_LETTERS, length);
    }

    public static String getRandom(String source, int length) {
        if (source == null) {
            return null;
        }
        return RandomUtils.getRandom(source.toCharArray(), length);
    }

    public static String getRandom(char[] chars, int length) {
        if (length > 0 && chars != null && chars.length != 0) {
            StringBuilder builder = new StringBuilder(length);
            Random random = new Random();
            for (int i = 0; i < length; ++i) {
                builder.append(chars[random.nextInt(chars.length)]);
            }
            return builder.toString();
        }
        return null;
    }

    public static String getRandom(String[] strings, int length) {
        if (length > 0 && strings != null && strings.length != 0) {
            StringBuilder builder = new StringBuilder(length);
            Random random = new Random();
            for (int i = 0; i < length; ++i) {
                builder.append(strings[random.nextInt(strings.length)]);
            }
            return builder.toString();
        }
        return null;
    }

    public static int getRandom(int max) {
        return RandomUtils.getRandom(0, max);
    }

    public static int getRandom(int min, int max) {
        if (min > max) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        return min + new Random().nextInt(max - min);
    }

    public static boolean shuffle(Object[] objects) {
        if (objects == null) {
            return false;
        }
        return RandomUtils.shuffle(objects, RandomUtils.getRandom(1, objects.length));
    }

    public static boolean shuffle(Object[] objects, int shuffleCount) {
        int length;
        if (shuffleCount > 0 && objects != null && (length = objects.length) >= shuffleCount) {
            for (int i = 1; i <= shuffleCount; ++i) {
                int random = RandomUtils.getRandom(0, length - i);
                Object temp = objects[length - i];
                objects[length - i] = objects[random];
                objects[random] = temp;
            }
            return true;
        }
        return false;
    }

    public static int[] shuffle(int[] ints) {
        if (ints == null) {
            return null;
        }
        return RandomUtils.shuffle(ints, RandomUtils.getRandom(1, ints.length));
    }

    public static int[] shuffle(int[] ints, int shuffleCount) {
        int length;
        if (shuffleCount > 0 && ints != null && (length = ints.length) >= shuffleCount) {
            int[] out = new int[shuffleCount];
            for (int i = 1; i <= shuffleCount; ++i) {
                int random = RandomUtils.getRandom(0, length - i);
                out[i - 1] = ints[random];
                int temp = ints[length - i];
                ints[length - i] = ints[random];
                ints[random] = temp;
            }
            return out;
        }
        return null;
    }

    public static boolean shuffle2(Object[] objects) {
        if (objects == null) {
            return false;
        }
        int len = objects.length;
        if (len > 0) {
            for (int i = 0; i < len - 1; ++i) {
                int idx = (int)(Math.random() * (double)(len - i));
                Object temp = objects[idx];
                objects[idx] = objects[len - i - 1];
                objects[len - i - 1] = temp;
            }
            return true;
        }
        return false;
    }

    public static int nextIntRange(int origin, int bound) throws IllegalArgumentException {
        int r;
        if (origin > bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        if (origin == bound) {
            return origin;
        }
        Random random = new Random();
        int n = bound - origin;
        if (n > 0) {
            return random.nextInt(n) + origin;
        }
        while ((r = random.nextInt()) < origin || r >= bound) {
        }
        return r;
    }

    public static long nextLongRange(long origin, long bound) throws IllegalArgumentException {
        if (origin > bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        if (origin == bound) {
            return origin;
        }
        Random random = new Random();
        long r = random.nextLong();
        long n = bound - origin;
        long m = n - 1L;
        if ((n & m) == 0L) {
            r = (r & m) + origin;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m - (r = u % n) < 0L) {
                u = random.nextLong() >>> 1;
            }
            r += origin;
        } else {
            while (r < origin || r >= bound) {
                r = random.nextLong();
            }
        }
        return r;
    }

    public static double nextDoubleRange(double origin, double bound) throws IllegalArgumentException {
        if (origin > bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        if (origin == bound) {
            return origin;
        }
        double r = new Random().nextDouble();
        if ((r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    public static int[] ints(int streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            return null;
        }
        if (streamSize < 0) {
            return null;
        }
        try {
            int[] ints = new int[streamSize];
            for (int i = 0; i < streamSize; ++i) {
                ints[i] = RandomUtils.nextIntRange(randomNumberOrigin, randomNumberBound);
            }
            return ints;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "ints", new Object[0]);
            return null;
        }
    }

    public static long[] longs(int streamSize, long randomNumberOrigin, long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            return null;
        }
        if (streamSize < 0) {
            return null;
        }
        try {
            long[] longs = new long[streamSize];
            for (int i = 0; i < streamSize; ++i) {
                longs[i] = RandomUtils.nextLongRange(randomNumberOrigin, randomNumberBound);
            }
            return longs;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "longs", new Object[0]);
            return null;
        }
    }

    public static double[] doubles(int streamSize, double randomNumberOrigin, double randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            return null;
        }
        if (streamSize < 0) {
            return null;
        }
        try {
            double[] doubles = new double[streamSize];
            for (int i = 0; i < streamSize; ++i) {
                doubles[i] = RandomUtils.nextDoubleRange(randomNumberOrigin, randomNumberBound);
            }
            return doubles;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "doubles", new Object[0]);
            return null;
        }
    }
}

