/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;

public final class ClassUtils {
    private static final String TAG = ClassUtils.class.getSimpleName();

    private ClassUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<?>[] cons;
            Constructor<?>[] constructorArray = cons = clazz.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            if (n2 < n) {
                Constructor<?> c = constructorArray[n2];
                Class<?>[] cls = c.getParameterTypes();
                if (cls.length == 0) {
                    c.setAccessible(true);
                    return (T)c.newInstance(new Object[0]);
                }
                Object[] objects = new Object[cls.length];
                for (int i = 0; i < cls.length; ++i) {
                    objects[i] = ClassUtils.getDefaultPrimitiveValue(cls[i]);
                }
                c.setAccessible(true);
                return (T)c.newInstance(objects);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "newInstance", new Object[0]);
        }
        return null;
    }

    public static Object getDefaultPrimitiveValue(Class<?> clazz) {
        if (clazz != null && clazz.isPrimitive()) {
            return clazz == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        return null;
    }

    public static Class<?> getClass(Object object) {
        return object != null ? object.getClass() : null;
    }

    public static Class<?> getClass(Type type) {
        if (type == null) {
            return null;
        }
        try {
            Type[] upperBounds;
            if (type.getClass() == Class.class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return ClassUtils.getClass(((ParameterizedType)type).getRawType());
            }
            if (type instanceof TypeVariable) {
                Type boundType = ((TypeVariable)type).getBounds()[0];
                return (Class)boundType;
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return ClassUtils.getClass(upperBounds[0]);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getClass", new Object[0]);
        }
        return Object.class;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz != null && clazz.isPrimitive();
    }

    public static boolean isCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isGenericParamType(Type type) {
        if (type != null) {
            if (type instanceof ParameterizedType) {
                return true;
            }
            if (type instanceof Class) {
                try {
                    Type superType = ((Class)type).getGenericSuperclass();
                    return superType != Object.class && ClassUtils.isGenericParamType(superType);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "isGenericParamType", new Object[0]);
                }
            }
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type != null) {
            if (type instanceof ParameterizedType) {
                return type;
            }
            if (type instanceof Class) {
                try {
                    return ClassUtils.getGenericParamType(((Class)type).getGenericSuperclass());
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "getGenericParamType", new Object[0]);
                }
            }
        }
        return type;
    }

    public static Type getGenericSuperclass(Object object) {
        return ClassUtils.getGenericSuperclass(object, 0);
    }

    public static Type getGenericSuperclass(Object object, int pos) {
        return ClassUtils.getGenericSuperclass(ClassUtils.getClass(object), pos);
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return ClassUtils.getGenericSuperclass(clazz, 0);
    }

    public static Type getGenericSuperclass(Class<?> clazz, int pos) {
        if (clazz != null && pos >= 0) {
            try {
                return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[pos];
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getGenericSuperclass", new Object[0]);
            }
        }
        return null;
    }

    public static Type getGenericInterfaces(Object object, Class<?> interfaceClazz) {
        return ClassUtils.getGenericInterfaces(object, interfaceClazz, 0);
    }

    public static Type getGenericInterfaces(Object object, Class<?> interfaceClazz, int pos) {
        return ClassUtils.getGenericInterfaces(ClassUtils.getClass(object), interfaceClazz, pos);
    }

    public static Type getGenericInterfaces(Class<?> clazz, Class<?> interfaceClazz) {
        return ClassUtils.getGenericInterfaces(clazz, interfaceClazz, 0);
    }

    public static Type getGenericInterfaces(Class<?> clazz, Class<?> interfaceClazz, int pos) {
        if (clazz != null && interfaceClazz != null && pos >= 0) {
            try {
                Type[] types;
                String iName = interfaceClazz.getName();
                if ("".equals(iName)) {
                    return null;
                }
                for (Type type : types = clazz.getGenericInterfaces()) {
                    ParameterizedType parameterizedType;
                    String rawType;
                    if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType().toString()).startsWith("interface ") ? rawType.equals("interface " + iName) : rawType.equals(iName))) continue;
                    return parameterizedType.getActualTypeArguments()[pos];
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getGenericInterfaces", new Object[0]);
            }
        }
        return null;
    }
}

