/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.common.ChineseUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.validator.ValidatorUtils;
import java.math.BigDecimal;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static String addZero(int value) {
        return NumberUtils.addZero(value, true);
    }

    public static String addZero(int value, boolean appendZero) {
        if (!appendZero) {
            return String.valueOf(value);
        }
        int temp = Math.max(0, value);
        return temp >= 10 ? String.valueOf(temp) : "0" + temp;
    }

    public static String addZero(long value) {
        return NumberUtils.addZero(value, true);
    }

    public static String addZero(long value, boolean appendZero) {
        if (!appendZero) {
            return String.valueOf(value);
        }
        long temp = Math.max(0L, value);
        return temp >= 10L ? String.valueOf(temp) : "0" + temp;
    }

    public static String subZeroAndDot(double value) {
        return NumberUtils.subZeroAndDot(String.valueOf(value));
    }

    public static String subZeroAndDot(String value) {
        if (StringUtils.isNotEmpty(value)) {
            String str = value;
            if (str.contains(".")) {
                str = str.replaceAll("0+?$", "");
                str = str.replaceAll("[.]$", "");
            }
            return str;
        }
        return value;
    }

    public static double[] calculateUnitD(double value, double[] unitSpans) {
        if (value <= 0.0) {
            return null;
        }
        if (unitSpans == null) {
            return null;
        }
        int len = unitSpans.length;
        double[] result = new double[len];
        double temp = value;
        for (int i = 0; i < len; ++i) {
            if (!(temp >= unitSpans[i])) continue;
            double multiple = temp / unitSpans[i];
            if (i != len - 1) {
                multiple = (int)multiple;
            }
            temp -= multiple * unitSpans[i];
            result[i] = multiple;
        }
        return result;
    }

    public static int[] calculateUnitI(int value, int[] unitSpans) {
        if (value <= 0) {
            return null;
        }
        if (unitSpans == null) {
            return null;
        }
        int len = unitSpans.length;
        int[] result = new int[len];
        int temp = value;
        for (int i = 0; i < len; ++i) {
            if (temp < unitSpans[i]) continue;
            int multiple = temp / unitSpans[i];
            temp -= multiple * unitSpans[i];
            result[i] = multiple;
        }
        return result;
    }

    public static long[] calculateUnitL(long value, long[] unitSpans) {
        if (value <= 0L) {
            return null;
        }
        if (unitSpans == null) {
            return null;
        }
        int len = unitSpans.length;
        long[] result = new long[len];
        long temp = value;
        for (int i = 0; i < len; ++i) {
            if (temp < unitSpans[i]) continue;
            long multiple = temp / unitSpans[i];
            temp -= multiple * unitSpans[i];
            result[i] = multiple;
        }
        return result;
    }

    public static float[] calculateUnitF(float value, float[] unitSpans) {
        if (value <= 0.0f) {
            return null;
        }
        if (unitSpans == null) {
            return null;
        }
        int len = unitSpans.length;
        float[] result = new float[len];
        float temp = value;
        for (int i = 0; i < len; ++i) {
            if (!(temp >= unitSpans[i])) continue;
            float multiple = temp / unitSpans[i];
            if (i != len - 1) {
                multiple = (int)multiple;
            }
            temp -= multiple * unitSpans[i];
            result[i] = multiple;
        }
        return result;
    }

    public static Double percentD(double value, double max) {
        if (max <= 0.0) {
            return 0.0;
        }
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= max) {
            return 1.0;
        }
        return value / max;
    }

    public static int percentI(double value, double max) {
        return NumberUtils.percentD(value, max).intValue();
    }

    public static long percentL(double value, double max) {
        return NumberUtils.percentD(value, max).longValue();
    }

    public static float percentF(double value, double max) {
        return NumberUtils.percentD(value, max).floatValue();
    }

    public static Double percentD2(double value, double max) {
        if (max <= 0.0) {
            return 0.0;
        }
        if (value <= 0.0) {
            return 0.0;
        }
        return value / max;
    }

    public static int percentI2(double value, double max) {
        return NumberUtils.percentD2(value, max).intValue();
    }

    public static long percentL2(double value, double max) {
        return NumberUtils.percentD2(value, max).longValue();
    }

    public static float percentF2(double value, double max) {
        return NumberUtils.percentD2(value, max).floatValue();
    }

    public static Double multipleD(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0.0;
        }
        return value / divisor;
    }

    public static int multipleI(double value, double divisor) {
        return NumberUtils.multipleD(value, divisor).intValue();
    }

    public static long multipleL(double value, double divisor) {
        return NumberUtils.multipleD(value, divisor).longValue();
    }

    public static float multipleF(double value, double divisor) {
        return NumberUtils.multipleD(value, divisor).floatValue();
    }

    public static int multiple(double value, double divisor) {
        if (value <= 0.0 || divisor <= 0.0) {
            return 0;
        }
        if (value <= divisor) {
            return 1;
        }
        int result = (int)(value / divisor);
        return value - divisor * (double)result == 0.0 ? result : result + 1;
    }

    public static double clamp(double value, double max, double min) {
        return value > max ? max : Math.max(value, min);
    }

    public static int clamp(int value, int max, int min) {
        return value > max ? max : Math.max(value, min);
    }

    public static long clamp(long value, long max, long min) {
        return value > max ? max : Math.max(value, min);
    }

    public static float clamp(float value, float max, float min) {
        return value > max ? max : Math.max(value, min);
    }

    public static String numberToCHN(double number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static String numberToCHN(String number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static String numberToCHN(BigDecimal number, boolean isUpper) {
        return ChineseUtils.numberToCHN(number, isUpper);
    }

    public static boolean isNumber(String str) {
        return ValidatorUtils.isNumber(str);
    }

    public static boolean isNumberDecimal(String str) {
        return ValidatorUtils.isNumberDecimal(str);
    }
}

