/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.validator;

import dev.utils.common.validator.ValidatorUtils;

public final class ValiToPhoneUtils {
    public static final String CHAIN_PHONE_SIMPLE = "^(?:\\+86)?1\\d{10}$";
    public static final String CHINA_PHONE_PATTERN;
    public static final String CHINA_MOBILE_PATTERN;
    public static final String CHINA_UNICOM_PATTERN;
    public static final String CHINA_TELECOM_PATTERN;
    public static final String CHINA_BROADCAST_PATTERN;
    public static final String CHINA_VIRTUAL_PATTERN;
    public static final String CHINA_HK_PHONE_PATTERN = "^(5|6|8|9)\\d{7}$";
    public static final String PHONE_CALL_PATTERN = "^(?:\\(\\d{3,4}\\)|\\d{3,4}-)?\\d{7,8}(?:-\\d{1,4})?$";

    private ValiToPhoneUtils() {
    }

    public static boolean isPhoneSimple(String phone) {
        return ValidatorUtils.match(CHAIN_PHONE_SIMPLE, phone);
    }

    public static boolean isPhone(String phone) {
        return ValidatorUtils.match(CHINA_PHONE_PATTERN, phone);
    }

    public static boolean isPhoneToChinaMobile(String phone) {
        return ValidatorUtils.match(CHINA_MOBILE_PATTERN, phone);
    }

    public static boolean isPhoneToChinaUnicom(String phone) {
        return ValidatorUtils.match(CHINA_UNICOM_PATTERN, phone);
    }

    public static boolean isPhoneToChinaTelecom(String phone) {
        return ValidatorUtils.match(CHINA_TELECOM_PATTERN, phone);
    }

    public static boolean isPhoneToChinaBroadcast(String phone) {
        return ValidatorUtils.match(CHINA_BROADCAST_PATTERN, phone);
    }

    public static boolean isPhoneToChinaVirtual(String phone) {
        return ValidatorUtils.match(CHINA_VIRTUAL_PATTERN, phone);
    }

    public static boolean isPhoneToChinaHkMobile(String phone) {
        return ValidatorUtils.match(CHINA_HK_PHONE_PATTERN, phone);
    }

    public static boolean isPhoneCallNum(String phone) {
        return ValidatorUtils.match(PHONE_CALL_PATTERN, phone);
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("^13[4,5,6,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^14[7,8]{1}\\d{8}$");
        builder.append("|");
        builder.append("^15[0,1,2,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^17[2,8]{1}\\d{8}$");
        builder.append("|");
        builder.append("^18[2,3,4,7,8]{1}\\d{8}$");
        builder.append("|");
        builder.append("^19[5,8]{1}\\d{8}$");
        CHINA_MOBILE_PATTERN = builder.toString();
        builder = new StringBuilder();
        builder.append("^13[0,1,2]{1}\\d{8}$");
        builder.append("|");
        builder.append("^14[5,6]{1}\\d{8}$");
        builder.append("|");
        builder.append("^15[5,6]{1}\\d{8}$");
        builder.append("|");
        builder.append("^16[6,7]{1}\\d{8}$");
        builder.append("|");
        builder.append("^17[1,5,6]{1}\\d{8}$");
        builder.append("|");
        builder.append("^18[5,6]{1}\\d{8}$");
        builder.append("|");
        builder.append("^19[6]{1}\\d{8}$");
        CHINA_UNICOM_PATTERN = builder.toString();
        builder = new StringBuilder();
        builder.append("^13[3]{1}\\d{8}$");
        builder.append("|");
        builder.append("^14[9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^15[3]{1}\\d{8}$");
        builder.append("|");
        builder.append("^17[3,4,7]{1}\\d{8}$");
        builder.append("|");
        builder.append("^18[0,1,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^19[0,1,3,9]{1}\\d{8}$");
        CHINA_TELECOM_PATTERN = builder.toString();
        builder = new StringBuilder();
        builder.append("^19[2]{1}\\d{8}$");
        CHINA_BROADCAST_PATTERN = builder.toString();
        builder = new StringBuilder();
        builder.append("^16[2,5,7]{1}\\d{8}$");
        builder.append("|");
        builder.append("^17[0,1]{1}\\d{8}$");
        CHINA_VIRTUAL_PATTERN = builder.toString();
        builder = new StringBuilder();
        builder.append("^13[0,1,2,3,4,5,6,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^14[5,6,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^15[0,1,2,3,5,6,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^16[2,5,6,7,7]{1}\\d{8}$");
        builder.append("|");
        builder.append("^17[0,1,1,2,3,4,5,6,7,8]{1}\\d{8}$");
        builder.append("|");
        builder.append("^18[0,1,2,3,4,5,6,7,8,9]{1}\\d{8}$");
        builder.append("|");
        builder.append("^19[0,1,2,3,5,6,8,9]{1}\\d{8}$");
        CHINA_PHONE_PATTERN = builder.toString();
    }
}

