/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtils {
    private static final String TAG = AESUtils.class.getSimpleName();

    private AESUtils() {
    }

    public static byte[] initKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey secretKey = keyGen.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "initKey", new Object[0]);
            return null;
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        if (data == null || key == null) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "encrypt", new Object[0]);
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        if (data == null || key == null) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "decrypt", new Object[0]);
            return null;
        }
    }
}

