/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.format;

import dev.utils.JCLogUtils;

public class ArgsFormatter {
    private final String TAG = ArgsFormatter.class.getSimpleName();
    private final String startSpecifier;
    private final String middleSpecifier;
    private final String endSpecifier;
    private final boolean throwError;
    private final String defaultValue;

    public ArgsFormatter(String startSpecifier, String middleSpecifier, String endSpecifier, boolean throwError, String defaultValue) {
        this.startSpecifier = startSpecifier;
        this.middleSpecifier = middleSpecifier;
        this.endSpecifier = endSpecifier;
        this.throwError = throwError;
        this.defaultValue = defaultValue;
    }

    public static ArgsFormatter get(String startSpecifier, String middleSpecifier) {
        return new ArgsFormatter(startSpecifier, middleSpecifier, middleSpecifier, false, null);
    }

    public static ArgsFormatter get(String startSpecifier, String middleSpecifier, String endSpecifier) {
        return new ArgsFormatter(startSpecifier, middleSpecifier, endSpecifier, false, null);
    }

    public static ArgsFormatter get(String startSpecifier, String middleSpecifier, String endSpecifier, boolean throwError, String defaultValue) {
        return new ArgsFormatter(startSpecifier, middleSpecifier, endSpecifier, throwError, defaultValue);
    }

    public String getStartSpecifier() {
        return this.startSpecifier;
    }

    public String getMiddleSpecifier() {
        return this.middleSpecifier;
    }

    public String getEndSpecifier() {
        return this.endSpecifier;
    }

    public boolean isThrowError() {
        return this.throwError;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String format(Object ... args) {
        return this.formatByArray(args);
    }

    public String formatByArray(Object[] objects) {
        block3: {
            if (objects != null && objects.length != 0) {
                String format = this.createFormatString(objects);
                try {
                    return String.format(format, objects);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(this.TAG, e, "formatByArray", new Object[0]);
                    if (!this.throwError) break block3;
                    throw e;
                }
            }
        }
        return this.defaultValue;
    }

    private String createFormatString(Object[] objects) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.startSpecifier);
        int length = objects.length;
        for (int i = 1; i < length; ++i) {
            if (i == length - 1) {
                builder.append(this.endSpecifier);
                continue;
            }
            builder.append(this.middleSpecifier);
        }
        return builder.toString();
    }
}

