/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.bosslibrary.baseclasses;

import io.papermc.bosslibrary.baseclasses.BaseEntity;
import io.papermc.bosslibrary.baseclasses.CustomBoss;
import io.papermc.bosslibrary.singleton.HitboxManager;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;

public class CustomHitbox
extends BaseEntity {
    private final Random random = new Random();
    private final Interaction interaction;
    private CustomBoss boss;
    private double height = 1.0;
    private double width = 1.0;
    private int iframes;

    public CustomHitbox(Location location) {
        super(location);
        this.interaction = (Interaction)location.getWorld().spawn(location, Interaction.class, interaction -> interaction.setResponsive(true));
        HitboxManager.getInstance().registerHitbox(this);
    }

    public void setBoss(CustomBoss boss) {
        this.boss = boss;
    }

    public CustomBoss getBoss() {
        return this.boss;
    }

    @Override
    public void update() {
        if (this.iframes > 0) {
            --this.iframes;
        }
        for (Entity entity : this.interaction.getNearbyEntities(this.width / 2.0, this.height, this.width / 2.0)) {
            if (!(entity instanceof AbstractArrow)) continue;
            AbstractArrow arrow = (AbstractArrow)entity;
            float motionMultiplier = (float)arrow.getVelocity().length();
            int arrowDamage = (int)Math.ceil((double)motionMultiplier * arrow.getDamage());
            if (arrow.isCritical()) {
                long criticalMultiplier = this.random.nextInt(arrowDamage / 2 + 2);
                arrowDamage = (int)((long)arrowDamage + criticalMultiplier);
            }
            this.boss.damage(arrowDamage);
            arrow.remove();
        }
    }

    public Interaction getInteractionEntity() {
        return this.interaction;
    }

    public int getIframes() {
        return this.iframes;
    }

    public void setIframes(int iframes) {
        this.iframes = iframes;
    }

    @Override
    public void teleport(Location location) {
        this.interaction.teleport(location);
    }

    public void setHeight(float height) {
        this.interaction.setInteractionHeight(height);
        this.height = height;
    }

    public void setWidth(float width) {
        this.interaction.setInteractionWidth(width);
        this.width = width;
    }

    @Override
    public void cancel() {
        this.interaction.remove();
    }
}

