/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.bash;

import io.github.andreyzebin.gitSql.bash.BashCSS;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.bash.LogWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bash
implements BashIO {
    private static final Logger log = LoggerFactory.getLogger(Bash.class);
    public static final String WIN_BASH_PATH = "C:\\Program Files\\Git\\bin\\bash.exe";
    private final boolean isSilent;
    private final Runtime runtime;
    private final Function<Runtime, Process> terminals;
    private final LogWriter logWriter;

    public Bash(boolean isSilent, Runtime runtime, Function<Runtime, Process> terminals) {
        this(isSilent, runtime, terminals, new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, BashCSS::bashRender));
    }

    public Bash(boolean isSilent, Runtime runtime, Function<Runtime, Process> terminals, LogWriter logWriter) {
        this.isSilent = isSilent;
        this.runtime = runtime;
        this.terminals = terminals;
        this.logWriter = logWriter;
    }

    @Override
    public void runCommand(String str, PrintStream out, PrintStream err, Path cd) {
        Process t = this.terminals.apply(this.runtime);
        StringBuilder cmd = new StringBuilder();
        try (BufferedWriter bw = t.outputWriter();){
            cmd.append(Bash.cdAbs(cd));
            cmd.append(" && ");
            cmd.append(str);
            bw.write(cmd.toString());
            if (!this.isSilent) {
                log.debug(Color.YELLOW + cmd.toString() + Color.RESET);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        t.inputReader().lines().forEach(out::println);
        t.errorReader().lines().forEach(err::println);
    }

    @Override
    public void runCommand(String str, PrintWriter out, PrintWriter err, Path cd) {
        Process t = this.terminals.apply(this.runtime);
        StringBuilder cmd = new StringBuilder();
        try (BufferedWriter bw = t.outputWriter();
             LogWriter lw = this.logWriter;
             PrintWriter pw = lw.getPW();){
            cmd.append(Bash.cdAbs(cd));
            cmd.append(System.lineSeparator());
            cmd.append(str);
            String cmdLines = cmd.toString();
            bw.write(cmdLines);
            if (!this.isSilent) {
                cmdLines.lines().forEach(pw::println);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Thread thread = Bash.asyncRead(t.inputReader(), out);
            Thread thread1 = Bash.asyncRead(t.errorReader(), err);
            thread.join();
            thread1.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Thread asyncRead(BufferedReader t, PrintWriter out) {
        Thread thread = new Thread(() -> {
            try {
                String line;
                while ((line = t.readLine()) != null) {
                    out.println(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        thread.start();
        return thread;
    }

    public static String cdAbs(Path jump) {
        return "cd " + Bash.escape(Bash.toAbsolutePosix(jump));
    }

    public static String cd(String jump) {
        return "cd " + Bash.escape(Bash.toPosix(jump));
    }

    public static String cd(Path jump) {
        return "cd " + Bash.escape(Bash.toPosix(jump));
    }

    public static String escape(String posix) {
        return "\"" + posix + "\"";
    }

    public static String decode(String value) {
        return Bash.removeSurrounding(Bash.removeSurrounding(value, "'"), "\"");
    }

    private static String removeSurrounding(String value, String prefix) {
        if (value.startsWith(prefix) && value.endsWith(prefix)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String toAbsolutePosix(Path p) {
        return Bash.toPosix("/" + p.toAbsolutePath().normalize());
    }

    private static String toPosix(String p) {
        return p.replace("\\", "/").replace(":", "");
    }

    public static String posix(Path p) {
        Iterator<Path> iterator = p.iterator();
        StringBuilder r = new StringBuilder();
        while (iterator.hasNext()) {
            Path next = iterator.next();
            if (!r.isEmpty()) {
                r.append("/");
            } else if (p.isAbsolute()) {
                r.append("/");
            }
            r.append(next);
        }
        return r.toString();
    }

    public static String toPosix(Path p) {
        return Bash.toPosix(p.toString());
    }

    public static void append(StringBuffer buf, String line) {
        if (!buf.isEmpty()) {
            buf.append(System.lineSeparator());
        }
        buf.append(line);
    }

    public static Process runWinShell(Runtime runtime) {
        return Bash.runShell(runtime, WIN_BASH_PATH);
    }

    public static Process runShell(Runtime runtime, String winBashPath) {
        Process terminal = null;
        try {
            terminal = runtime.exec(new String[]{winBashPath});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return terminal;
    }

    public static Process runShellForOs(Runtime r) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows) {
            return Bash.runWinShell(r);
        }
        return Bash.runShell(r, "/bin/sh");
    }
}

